/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.smartkit.base.util;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ObjectMapperUtils {
    private static final Logger log = LoggerFactory.getLogger(ObjectMapperUtils.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static <T> T transKey(Map valueObj, Class<T> clazz, String key, T defaultVal) {
        if (valueObj == null || !valueObj.containsKey(key)) {
            return defaultVal;
        }
        try {
            return (T)ObjectUtils.defaultIfNull((Object)MAPPER.convertValue(valueObj.get(key), clazz), defaultVal);
        }
        catch (Exception e) {
            log.error("trans error", (Throwable)e);
            return defaultVal;
        }
    }

    public static <T> T transObject(Object object, Class<T> clazz, T defaultValue) {
        if (object == null || clazz == null) {
            return defaultValue;
        }
        try {
            return (T)ObjectUtils.defaultIfNull((Object)MAPPER.convertValue(object, clazz), defaultValue);
        }
        catch (IllegalArgumentException e) {
            log.error("trans obj error", (Throwable)e);
            return defaultValue;
        }
    }

    private ObjectMapperUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

