/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.ultravr.fit.impl;

import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.river.deploy.virtualization.common.entity.DeployTaskInfoVo;
import com.huawei.yinglong.river.deploy.virtualization.deployultravr.entity.UltraVRParams;
import com.huawei.yinglong.river.sitedeployment.dcs.constant.TaskOperateEnum;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.CommonTaskManager;
import com.huawei.yinglong.river.sitedeployment.dcs.ultravr.assembler.UltraVRAssembler;
import com.huawei.yinglong.river.sitedeployment.dcs.ultravr.context.UltraTaskContext;
import com.huawei.yinglong.river.sitedeployment.dcs.ultravr.fit.entity.DeployUltraVRParams;
import com.huawei.yinglong.river.sitedeployment.dcs.ultravr.service.task.DeployUltraVRTask;
import com.huawei.yinglong.river.sitedeployment.dcs.ultravr.service.task.UltraVRTaskFactory;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ResponseUtils;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.mapstruct.factory.Mappers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DeployUltraVRFitImpl {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeployUltraVRFitImpl.class);
    private final UltraVRAssembler assembler = (UltraVRAssembler)Mappers.getMapper(UltraVRAssembler.class);

    public Response<String> validUltraVRParams(UltraVRParams ultraVRParams) {
        DeployUltraVRParams deployUltraVRParams = this.assembler.toValidParams(ultraVRParams);
        List<String> invalidTips = deployUltraVRParams.validate(0, new Class[0]);
        if (invalidTips != null && !invalidTips.isEmpty()) {
            return ResponseUtils.success((Object)String.join((CharSequence)"\uff1b", invalidTips));
        }
        return ResponseUtils.success((Object)"");
    }

    public Response<Boolean> skipItem(String itemId) {
        log.info("start skip ultra vr task [{}]", (Object)itemId);
        return this.handleRetrySkipCommonResponse(CommonTaskManager.getInstance().skipSubTaskById(itemId), itemId, TaskOperateEnum.SKIP);
    }

    public Response<Boolean> retryItem(String itemId) {
        log.info("start retry ultra vr sub task [{}]", (Object)itemId);
        return this.handleRetrySkipCommonResponse(CommonTaskManager.getInstance().retrySubTaskById(itemId), itemId, TaskOperateEnum.RETRY);
    }

    public Response<Boolean> retryAllItems(String taskId) {
        log.info("start retry ultra vr task [{}]", (Object)taskId);
        return this.handleRetrySkipCommonResponse(CommonTaskManager.getInstance().retryAllTaskById(taskId), taskId, TaskOperateEnum.RETRY);
    }

    public Response<DeployTaskInfoVo> queryDeployDetails(String taskId) {
        log.info("query ultra vr task [{}]", (Object)taskId);
        Optional deployTaskInfoVo = CommonTaskManager.getInstance().queryTaskDetailById(taskId);
        return deployTaskInfoVo.map(ResponseUtils::success).orElse(ResponseUtils.failed((Object)DeployTaskInfoVo.builder().build()));
    }

    public Response<Boolean> startDeployUltraVR(UltraVRParams ultraVRParams) {
        UltraTaskContext.reset();
        DeployUltraVRTask ultraVRTask = UltraVRTaskFactory.createUltraVRTask(ultraVRParams);
        UltraTaskContext.getInstance().getRunningParamsCache().setUltraVRParams(ultraVRParams);
        CommonTaskManager.getInstance().addTask((BaseTask)ultraVRTask);
        boolean isSuccess = CommonTaskManager.getInstance().startTaskById(ultraVRTask.getTaskId());
        if (!isSuccess) {
            log.error("start deploy ultra vr task [{}] failed", (Object)ultraVRParams.getName());
            return ResponseUtils.failed((Object)false);
        }
        return ResponseUtils.success((Object)true);
    }

    public Response<Boolean> updateUltraVRParams(UltraVRParams ultraVRParams) {
        log.info("start update ultra vr params");
        if (Objects.isNull(ultraVRParams)) {
            log.error("ultra vr params is null");
            return ResponseUtils.failed((Object)false);
        }
        if (!UltraVRTaskFactory.isUpdateTaskParamSuccess(ultraVRParams)) {
            log.error("ultra vr params update failed");
            return ResponseUtils.failed((Object)false);
        }
        UltraTaskContext.getInstance().getRunningParamsCache().setUltraVRParams(ultraVRParams);
        return ResponseUtils.success((Object)true);
    }

    private Response<Boolean> handleRetrySkipCommonResponse(boolean isSuccess, String taskId, TaskOperateEnum operateEnum) {
        if (!isSuccess) {
            log.error("{} ultra vr task [{}] failed", (Object)operateEnum.name(), (Object)taskId);
            return ResponseUtils.failed((Object)false);
        }
        return ResponseUtils.success((Object)true);
    }
}

