/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.ultravr.fit.utils;

import com.huawei.yinglong.river.sitedeployment.dcs.consistency.ConsistencyPattern;
import com.huawei.yinglong.river.sitedeployment.dcs.task.CommonTaskManager;
import com.huawei.yinglong.river.sitedeployment.dcs.ultravr.fit.entity.DeployFusionComputeInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.ultravr.fit.entity.DeployTemplateInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.ultravr.fit.entity.DeployUltraVRParams;
import com.huawei.yinglong.river.sitedeployment.dcs.ultravr.utils.TaskResourceUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.IpUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;

public final class ValidationUtils {
    public static List<String> validateParams(DeployUltraVRParams ultraVRParams) {
        LinkedList<String> validResults = new LinkedList<String>();
        ValidationUtils.validManageIpReachable(ultraVRParams).ifPresent(validResults::add);
        ValidationUtils.validGatewayUnreachable(ultraVRParams).ifPresent(validResults::add);
        ValidationUtils.validManageIpFcFloatIpRepeated(ultraVRParams).ifPresent(validResults::add);
        ValidationUtils.validTemplateFileExist(ultraVRParams).ifPresent(validResults::add);
        return validResults;
    }

    private static Optional<String> validManageIpFcFloatIpRepeated(DeployUltraVRParams ultraVRParams) {
        DeployFusionComputeInfo fcInfo = ultraVRParams.getFusionComputeInfo();
        if (Objects.nonNull(fcInfo) && StringUtils.isNotEmpty((CharSequence)ultraVRParams.getIp()) && Objects.equals(ultraVRParams.getIp(), fcInfo.getFloatIp())) {
            return Optional.of(TaskResourceUtils.getString("error.validation.manage_ip_and_fc_float_ip_repeated"));
        }
        return Optional.empty();
    }

    private static Optional<String> validManageIpReachable(DeployUltraVRParams ultraVRParams) {
        String manageIp = ultraVRParams.getIp();
        if (IpUtils.isValidIpV4((String)manageIp) && ValidationUtils.isNeedCheckReachable(ultraVRParams.getTaskId(), manageIp)) {
            String formatName = StringUtils.formatTxt((String)"%s(%s)", (Object[])new Object[]{TaskResourceUtils.getString("ip"), manageIp});
            return Optional.of(StringUtils.formatTxt((String)TaskResourceUtils.getString("error.validation.ip.can.reachable"), (Object[])new Object[]{formatName}));
        }
        return Optional.empty();
    }

    private static Optional<String> validGatewayUnreachable(DeployUltraVRParams ultraVRParams) {
        String gateway = ultraVRParams.getGateway();
        if (IpUtils.isValidIpV4((String)gateway) && !IpUtils.isReachable((String)gateway)) {
            String formatName = StringUtils.formatTxt((String)"%s(%s)", (Object[])new Object[]{TaskResourceUtils.getString("gateway"), gateway});
            return Optional.of(StringUtils.formatTxt((String)TaskResourceUtils.getString("error.validation.ip.not.reachable"), (Object[])new Object[]{formatName}));
        }
        return Optional.empty();
    }

    private static Optional<String> validTemplateFileExist(DeployUltraVRParams ultraVRParams) {
        DeployTemplateInfo templateInfo = ultraVRParams.getTemplateInfo();
        if (Objects.isNull(templateInfo) || StringUtils.isEmpty((CharSequence)templateInfo.getTemplateFile())) {
            return Optional.empty();
        }
        File templateFile = new File(templateInfo.getTemplateFile());
        if (!templateFile.exists() || !ConsistencyPattern.isMatchUltraVRTemplateFile((String)templateFile.getName())) {
            return Optional.of(TaskResourceUtils.getString("error.validation.template.file.not.exist"));
        }
        return Optional.empty();
    }

    private static boolean isNeedCheckReachable(String taskId, String ip) {
        return !CommonTaskManager.getInstance().isTaskExecuted(taskId) && IpUtils.isReachable((String)ip);
    }

    @Generated
    private ValidationUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

