/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.ultravr.service.task;

import com.huawei.yinglong.river.deploy.virtualization.deployultravr.entity.UltraVRParams;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskStatus;
import com.huawei.yinglong.river.sitedeployment.dcs.ultravr.context.UltraTaskContext;
import com.huawei.yinglong.river.sitedeployment.dcs.ultravr.exception.UltraVRError;
import com.huawei.yinglong.river.sitedeployment.dcs.ultravr.exception.UltraVRException;
import com.huawei.yinglong.river.sitedeployment.dcs.ultravr.utils.TaskResourceUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.ultravr.utils.UltraVRConfigUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectVmDatastoreTask
extends BaseTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SelectVmDatastoreTask.class);
    public static final String NAME_KEY = "deploy.ultra.vr.datastore";

    public void execute() throws TaskException {
        UltraTaskContext context = UltraTaskContext.getInstance();
        this.appendTaskDetail("start to check vm datastore.");
        if (this.checkNeedSkipSelectDatastore()) {
            log.info("ultraVR skip select datastore.");
            this.appendTaskDetail("UltraVR skip select datastore.");
            return;
        }
        UltraVRParams ultraVRParams = context.getRunningParamsCache().getUltraVRParams().orElseThrow(() -> new UltraVRException(UltraVRError.PARAM_ERROR));
        if (Objects.isNull(ultraVRParams.getTemplateInfo())) {
            log.error("ultraVR template info is null.");
            throw new UltraVRException(UltraVRError.PARAM_ERROR);
        }
        String datastoreName = ultraVRParams.getTemplateInfo().getDatastoreName();
        if (StringUtils.isEmpty((CharSequence)datastoreName)) {
            log.error("not found ultraVR template datastore.");
            this.appendTaskDetail(TaskResourceUtils.getString("task.config.datastore.detail"));
            throw new UltraVRException(UltraVRError.CONFIG_DATASTORE, TaskStatus.PAUSE);
        }
        this.appendTaskDetail("UltraVR template vm datastore : " + datastoreName);
        datastoreName = ultraVRParams.getDatastoreName();
        if (StringUtils.isEmpty((CharSequence)datastoreName)) {
            log.error("not found ultraVR VM datastore.");
            this.appendTaskDetail(TaskResourceUtils.getString("task.config.datastore.detail"));
            throw new UltraVRException(UltraVRError.CONFIG_DATASTORE, TaskStatus.PAUSE);
        }
        this.appendTaskDetail("UltraVR Vm datastore : " + datastoreName);
    }

    private boolean checkNeedSkipSelectDatastore() {
        return Boolean.parseBoolean(UltraVRConfigUtils.getPropertiesValue("deploy.skip.datastore.select", "false"));
    }

    @Generated
    protected SelectVmDatastoreTask(SelectVmDatastoreTaskBuilder<?, ?> b) {
        super(b);
    }

    @Generated
    public static SelectVmDatastoreTaskBuilder<?, ?> builder() {
        return new SelectVmDatastoreTaskBuilderImpl();
    }

    @Generated
    private static final class SelectVmDatastoreTaskBuilderImpl
    extends SelectVmDatastoreTaskBuilder<SelectVmDatastoreTask, SelectVmDatastoreTaskBuilderImpl> {
        @Generated
        private SelectVmDatastoreTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected SelectVmDatastoreTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public SelectVmDatastoreTask build() {
            return new SelectVmDatastoreTask(this);
        }
    }

    @Generated
    public static abstract class SelectVmDatastoreTaskBuilder<C extends SelectVmDatastoreTask, B extends SelectVmDatastoreTaskBuilder<C, B>>
    extends BaseTask.BaseTaskBuilder<C, B> {
        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "SelectVmDatastoreTask.SelectVmDatastoreTaskBuilder(super=" + super.toString() + ")";
        }
    }
}

