/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.ultravr.service.task;

import com.huawei.yinglong.river.deploy.virtualization.common.entity.FusionComputeInfo;
import com.huawei.yinglong.river.deploy.virtualization.deployultravr.entity.UltraVRParams;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.client.ApiClient;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.base.FcLoginInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.service.FcClientService;
import com.huawei.yinglong.river.sitedeployment.dcs.http.HttpRequestApiFactory;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.ultravr.assembler.UltraVRAssembler;
import com.huawei.yinglong.river.sitedeployment.dcs.ultravr.context.UltraTaskContext;
import com.huawei.yinglong.river.sitedeployment.dcs.ultravr.exception.UltraVRError;
import com.huawei.yinglong.river.sitedeployment.dcs.ultravr.exception.UltraVRException;
import com.huawei.yinglong.river.sitedeployment.dcs.ultravr.service.http.UltraVRHttpRequest;
import com.huawei.yinglong.river.sitedeployment.dcs.ultravr.utils.UltraVRConfigUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FileOperateUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ThreadUtils;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.mapstruct.factory.Mappers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateCheckAndCleanTask
extends BaseTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TemplateCheckAndCleanTask.class);
    public static final String NAME_KEY = "template.check.clean";
    private static final UltraVRAssembler ASSEMBLER = (UltraVRAssembler)Mappers.getMapper(UltraVRAssembler.class);
    private static final String WAIT_TIME_KEY = "deploy.ultra.vr.limit.time";
    private UltraVRHttpRequest requestApi;

    public void beforeExecute() {
        log.info("start to clean ultra vr template dir");
        this.requestApi = (UltraVRHttpRequest)HttpRequestApiFactory.createRequestApi((String)String.format("https://%s:9443", UltraTaskContext.getInstance().getRunningParamsCache().getUltraVRParams().map(UltraVRParams::getIp).orElse("")), UltraVRHttpRequest.class);
    }

    public void execute() throws TaskException {
        long waitTime;
        UltraTaskContext context = UltraTaskContext.getInstance();
        this.appendTaskDetail("start to delete local template file.");
        context.getRunningParamsCache().getTemplateCacheFile().ifPresent(FileOperateUtils::deleteDirectory);
        this.deleteFcTemplate(context);
        long startTime = System.currentTimeMillis();
        int templateCreateTimeMinus = Math.max(1, UltraVRConfigUtils.getPropertiesValue(WAIT_TIME_KEY, 30));
        log.info("ultra vr wait time:[{}} minus", (Object)templateCreateTimeMinus);
        this.appendTaskDetail("start to check UltraVR service status.");
        do {
            ThreadUtils.threadSafeSleep((int)10, (TimeUnit)TimeUnit.SECONDS);
            this.appendTaskDetail("try to access UltraVR UI portal.");
            if (this.isUltraVRPortalAccess()) {
                log.info("can access ultra vr portal,deploy success");
                this.appendTaskDetail("access UltraVR UI portal successfully.");
                return;
            }
            log.warn("can not access ultra vr portal,wait to next access");
        } while ((waitTime = System.currentTimeMillis() - startTime) <= TimeUnit.MINUTES.toMillis(templateCreateTimeMinus));
        throw new UltraVRException(UltraVRError.PORTAL_CHECK_ERROR);
    }

    private void deleteFcTemplate(UltraTaskContext context) {
        Optional<String> templateId = context.getRunningParamsCache().getTemplateId();
        if (!templateId.isPresent()) {
            log.info("template id is empty, no need to delete.");
            return;
        }
        FusionComputeInfo fcInfo = context.getRunningParamsCache().getUltraVRParams().map(UltraVRParams::getFusionComputeInfo).orElseThrow(() -> new UltraVRException(UltraVRError.PARAM_ERROR));
        ApiClient apiService = FcClientService.createApiService((FcLoginInfo)ASSEMBLER.toFcInfo(fcInfo));
        apiService.deleteVm(templateId.get());
        log.info("delete template {}", (Object)templateId.get());
        this.appendTaskDetail("delete UltraVR template, id:" + templateId.get());
    }

    private boolean isUltraVRPortalAccess() {
        try {
            return this.requestApi.getUltraVRPortalStatus().execute().isSuccessful();
        }
        catch (IOException exception) {
            log.error("can not access ultra vr portal", (Throwable)exception);
            return false;
        }
    }

    @Generated
    protected TemplateCheckAndCleanTask(TemplateCheckAndCleanTaskBuilder<?, ?> b) {
        super(b);
        this.requestApi = ((TemplateCheckAndCleanTaskBuilder)b).requestApi;
    }

    @Generated
    public static TemplateCheckAndCleanTaskBuilder<?, ?> builder() {
        return new TemplateCheckAndCleanTaskBuilderImpl();
    }

    @Generated
    private static final class TemplateCheckAndCleanTaskBuilderImpl
    extends TemplateCheckAndCleanTaskBuilder<TemplateCheckAndCleanTask, TemplateCheckAndCleanTaskBuilderImpl> {
        @Generated
        private TemplateCheckAndCleanTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected TemplateCheckAndCleanTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public TemplateCheckAndCleanTask build() {
            return new TemplateCheckAndCleanTask(this);
        }
    }

    @Generated
    public static abstract class TemplateCheckAndCleanTaskBuilder<C extends TemplateCheckAndCleanTask, B extends TemplateCheckAndCleanTaskBuilder<C, B>>
    extends BaseTask.BaseTaskBuilder<C, B> {
        @Generated
        private UltraVRHttpRequest requestApi;

        @Generated
        public B requestApi(UltraVRHttpRequest requestApi) {
            this.requestApi = requestApi;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "TemplateCheckAndCleanTask.TemplateCheckAndCleanTaskBuilder(super=" + super.toString() + ", requestApi=" + this.requestApi + ")";
        }
    }
}

