/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.ultravr.service.task;

import com.huawei.yinglong.river.deploy.virtualization.deployultravr.entity.UltraVRParams;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.ultravr.context.DeployUltraVRConstant;
import com.huawei.yinglong.river.sitedeployment.dcs.ultravr.context.UltraTaskContext;
import com.huawei.yinglong.river.sitedeployment.dcs.ultravr.exception.UltraVRError;
import com.huawei.yinglong.river.sitedeployment.dcs.ultravr.exception.UltraVRException;
import com.huawei.yinglong.river.sitedeployment.dcs.ultravr.utils.UltraVRConfigUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FileOperateUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FilePathValidatorUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ZipUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.exception.ErrorKey;
import java.io.File;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateUnzipTask
extends BaseTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TemplateUnzipTask.class);
    public static final String NAME_KEY = "template.unzip";
    private static final String WAIT_TIME_KEY = "unzip.wait.time.limit";

    public void beforeExecute() {
        log.info("start start unzip template");
    }

    public void execute() throws TaskException {
        Optional<UltraVRParams> ultraVRParams = UltraTaskContext.getInstance().getRunningParamsCache().getUltraVRParams();
        if (!ultraVRParams.isPresent()) {
            log.error("ultra vr deploy params not exists");
            throw new UltraVRException(UltraVRError.PARAM_ERROR);
        }
        this.appendTaskDetail("start to valid template file.");
        String templateFile = ultraVRParams.get().getTemplateInfo().getTemplateFile();
        this.validTemplateFile(templateFile);
        String templateCacheDir = this.generateTemplateCacheDir(ultraVRParams.get());
        this.appendTaskDetail("start to unzip template file.");
        FileOperateUtils.deleteDirectory((String)templateCacheDir);
        ZipUtils.decompressFileBy7Zip((String)DeployUltraVRConstant.ZIP_TOOL_PATH, (String)templateFile, (String)templateCacheDir);
        this.appendTaskDetail("finish to unzip template file.");
        this.updateTemplateFilePaths(templateCacheDir);
    }

    private String generateTemplateCacheDir(UltraVRParams ultraVRParams) {
        return (String)FileOperateUtils.createTemplateCacheFile((String)ultraVRParams.getTaskId()).orElseThrow(() -> new TaskException((ErrorKey)UltraVRError.PARAM_ERROR));
    }

    private void validTemplateFile(String templateFile) {
        File file = new File(templateFile);
        if (!file.exists()) {
            log.error("ultra vr template file not exists");
            throw new UltraVRException(UltraVRError.TEMPLATE_FILE_NOT_EXIST);
        }
    }

    private void updateTemplateFilePaths(String templateCacheDir) {
        String vhdFile = this.getTemplateUnzipFile(templateCacheDir, "vhd");
        this.checkUnzipFinish(vhdFile);
        UltraTaskContext.getInstance().getRunningParamsCache().setTemplateVhdFile(vhdFile);
        String ovfFile = this.getTemplateUnzipFile(templateCacheDir, "ovf");
        this.checkUnzipFinish(ovfFile);
        UltraTaskContext.getInstance().getRunningParamsCache().setTemplateOvfFile(ovfFile);
        UltraTaskContext.getInstance().getRunningParamsCache().setTemplateCacheFile(templateCacheDir);
    }

    private void checkUnzipFinish(String unzipFile) {
        int waitSecond = Math.max(1, UltraVRConfigUtils.getPropertiesValue(WAIT_TIME_KEY, 10));
        if (StringUtils.isEmpty((CharSequence)unzipFile)) {
            log.error("unzip file not exists");
            throw new UltraVRException(UltraVRError.TEMPLATE_FILE_NOT_EXIST);
        }
        if (!ZipUtils.checkDecompressFileExist((String)unzipFile, (long)waitSecond, (TimeUnit)TimeUnit.SECONDS)) {
            log.error("check unzip file failed");
            throw new UltraVRException(UltraVRError.TEMPLATE_FILE_NOT_EXIST);
        }
    }

    private String getTemplateUnzipFile(String templateCacheDir, String fileSuffix) {
        return FileUtils.listFiles((File)new File(templateCacheDir), (String[])new String[]{fileSuffix}, (boolean)true).stream().findFirst().flatMap(FilePathValidatorUtils::getSafePath).orElse("");
    }

    @Generated
    protected TemplateUnzipTask(TemplateUnzipTaskBuilder<?, ?> b) {
        super(b);
    }

    @Generated
    public static TemplateUnzipTaskBuilder<?, ?> builder() {
        return new TemplateUnzipTaskBuilderImpl();
    }

    @Generated
    private static final class TemplateUnzipTaskBuilderImpl
    extends TemplateUnzipTaskBuilder<TemplateUnzipTask, TemplateUnzipTaskBuilderImpl> {
        @Generated
        private TemplateUnzipTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected TemplateUnzipTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public TemplateUnzipTask build() {
            return new TemplateUnzipTask(this);
        }
    }

    @Generated
    public static abstract class TemplateUnzipTaskBuilder<C extends TemplateUnzipTask, B extends TemplateUnzipTaskBuilder<C, B>>
    extends BaseTask.BaseTaskBuilder<C, B> {
        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "TemplateUnzipTask.TemplateUnzipTaskBuilder(super=" + super.toString() + ")";
        }
    }
}

