/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.ultravr.service.task;

import com.huawei.yinglong.river.deploy.virtualization.common.entity.TemplateInfo;
import com.huawei.yinglong.river.deploy.virtualization.deployultravr.entity.UltraVRParams;
import com.huawei.yinglong.river.sitedeployment.dcs.constant.TaskOperateEnum;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.base.FcLoginInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.enviroment.EnvironmentCheckTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.enviroment.cmd.EnvironmentCheckCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.vm.template.CreateVmByTemplateTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.vm.template.UploadTemplateTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.vm.template.cmd.CreateVmByTemplateCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.vm.template.cmd.UploadTemplateCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.service.FcTaskService;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.CommonTaskManager;
import com.huawei.yinglong.river.sitedeployment.dcs.ultravr.assembler.UltraVRAssembler;
import com.huawei.yinglong.river.sitedeployment.dcs.ultravr.context.UltraTaskContext;
import com.huawei.yinglong.river.sitedeployment.dcs.ultravr.context.UltraVRRuntimeParams;
import com.huawei.yinglong.river.sitedeployment.dcs.ultravr.service.task.DeployUltraVRTask;
import com.huawei.yinglong.river.sitedeployment.dcs.ultravr.service.task.SelectVmDatastoreTask;
import com.huawei.yinglong.river.sitedeployment.dcs.ultravr.service.task.TemplateCheckAndCleanTask;
import com.huawei.yinglong.river.sitedeployment.dcs.ultravr.service.task.TemplateUnzipTask;
import com.huawei.yinglong.river.sitedeployment.dcs.ultravr.utils.TaskResourceUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.ultravr.utils.UltraVRConfigUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.mapstruct.factory.Mappers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UltraVRTaskFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UltraVRTaskFactory.class);
    private static final UltraVRAssembler ASSEMBLER = (UltraVRAssembler)Mappers.getMapper(UltraVRAssembler.class);
    private static final int ULTRA_VR_UP_DISK = 50;
    private static final int ULTRA_VR_UP_CPU = 2;
    private static final int ULTRA_VR_UP_MEMORY = 4;

    public static DeployUltraVRTask createUltraVRTask(UltraVRParams ultraVRParams) {
        List<BaseTask> subTasks = Arrays.asList(new BaseTask[]{UltraVRTaskFactory.createSelectVmDatastoreTask(), UltraVRTaskFactory.createEnvironmentCheckTask(ultraVRParams), UltraVRTaskFactory.createUnzipTask(), UltraVRTaskFactory.createTemplateTask(ultraVRParams), UltraVRTaskFactory.createVmByTemplateTask(ultraVRParams), UltraVRTaskFactory.createCleanTask()});
        subTasks.forEach(task -> task.setEventType("ultraVRDeployEvent"));
        return ((DeployUltraVRTask.DeployUltraVRTaskBuilder)((DeployUltraVRTask.DeployUltraVRTaskBuilder)((DeployUltraVRTask.DeployUltraVRTaskBuilder)((DeployUltraVRTask.DeployUltraVRTaskBuilder)((DeployUltraVRTask.DeployUltraVRTaskBuilder)((DeployUltraVRTask.DeployUltraVRTaskBuilder)DeployUltraVRTask.builder().taskId(ultraVRParams.getTaskId())).taskName(TaskResourceUtils.getTaskName("deploy.ultra.vr"))).duration(TaskResourceUtils.getTaskDuration("deploy.ultra.vr"))).eventType("ultraVRDeployEvent")).subTasks(subTasks)).supportOperates(Collections.singletonList(TaskOperateEnum.RETRY))).build();
    }

    public static boolean isUpdateTaskParamSuccess(UltraVRParams ultraVRParams) {
        Optional baseTask = CommonTaskManager.getInstance().queryTaskById(ultraVRParams.getTaskId());
        if (!baseTask.isPresent()) {
            return false;
        }
        List subTasks = ((BaseTask)baseTask.get()).getSubTasks();
        if (CollectionUtils.isNotEmpty((Collection)subTasks)) {
            subTasks.forEach(subTask -> UltraVRTaskFactory.updateTask(ultraVRParams, subTask));
        }
        return true;
    }

    private static void updateTask(UltraVRParams params, BaseTask subTask) {
        if (subTask instanceof EnvironmentCheckTask) {
            ((EnvironmentCheckTask)subTask).update((Object)UltraVRTaskFactory.buildEnvironmentCheckCmd(params), ASSEMBLER.toFcInfo(params.getFusionComputeInfo()));
        } else if (subTask instanceof UploadTemplateTask) {
            ((UploadTemplateTask)subTask).update((Object)UltraVRTaskFactory.buildUploadTemplateCmd(params), ASSEMBLER.toFcInfo(params.getFusionComputeInfo()));
        } else if (subTask instanceof CreateVmByTemplateTask) {
            ((CreateVmByTemplateTask)subTask).update((Object)UltraVRTaskFactory.buildCreateVmByTemplateCmd(params), ASSEMBLER.toFcInfo(params.getFusionComputeInfo()));
        } else {
            log.info("task {} does not need to update", (Object)subTask.getTaskName());
        }
    }

    private static SelectVmDatastoreTask createSelectVmDatastoreTask() {
        return ((SelectVmDatastoreTask.SelectVmDatastoreTaskBuilder)((SelectVmDatastoreTask.SelectVmDatastoreTaskBuilder)((SelectVmDatastoreTask.SelectVmDatastoreTaskBuilder)((SelectVmDatastoreTask.SelectVmDatastoreTaskBuilder)SelectVmDatastoreTask.builder().supportOperates(Arrays.asList(TaskOperateEnum.RESUME, TaskOperateEnum.RETRY))).eventType("ultraVRDeployEvent")).taskName(TaskResourceUtils.getTaskName("deploy.ultra.vr.datastore"))).duration(TaskResourceUtils.getTaskDuration("deploy.ultra.vr.datastore"))).build();
    }

    private static EnvironmentCheckTask createEnvironmentCheckTask(UltraVRParams params) {
        return FcTaskService.createEnvironmentCheckTask((EnvironmentCheckCmd)UltraVRTaskFactory.buildEnvironmentCheckCmd(params), (FcLoginInfo)ASSEMBLER.toFcInfo(params.getFusionComputeInfo()));
    }

    private static EnvironmentCheckCmd buildEnvironmentCheckCmd(UltraVRParams params) {
        EnvironmentCheckCmd checkCmd = EnvironmentCheckCmd.builder().cpuMuxRatio(UltraVRConfigUtils.getCpuMuxRatio()).memoryMuxRatio(UltraVRConfigUtils.getMemoryMuxRatio()).oldVmIds(() -> UltraTaskContext.getInstance().getRunningParamsCache().getVmIds()).build();
        Optional.ofNullable(params.getTemplateInfo()).ifPresent(templateInfo -> UltraVRTaskFactory.addReservation(checkCmd, templateInfo));
        return checkCmd;
    }

    private static void addReservation(EnvironmentCheckCmd checkCmd, TemplateInfo templateInfo) {
        if (StringUtils.isNotEmpty((CharSequence)templateInfo.getDatastoreName())) {
            checkCmd.addDatastore(templateInfo.getDatastoreName(), 100);
        } else {
            checkCmd.addDisk(templateInfo.getBelongCnaName(), 100);
        }
        checkCmd.addCpu(templateInfo.getBelongCnaName(), 4);
        checkCmd.addMemory(templateInfo.getBelongCnaName(), 8);
    }

    private static TemplateUnzipTask createUnzipTask() {
        return ((TemplateUnzipTask.TemplateUnzipTaskBuilder)((TemplateUnzipTask.TemplateUnzipTaskBuilder)((TemplateUnzipTask.TemplateUnzipTaskBuilder)((TemplateUnzipTask.TemplateUnzipTaskBuilder)TemplateUnzipTask.builder().taskName(TaskResourceUtils.getTaskName("template.unzip"))).duration(TaskResourceUtils.getTaskDuration("template.unzip"))).eventType("ultraVRDeployEvent")).supportOperates(Arrays.asList(TaskOperateEnum.SKIP, TaskOperateEnum.RETRY))).build();
    }

    private static UploadTemplateTask createTemplateTask(UltraVRParams ultraVRParams) {
        UploadTemplateCmd cmd = UltraVRTaskFactory.buildUploadTemplateCmd(ultraVRParams);
        return FcTaskService.uploadTemplateTask((UploadTemplateCmd)cmd, (FcLoginInfo)ASSEMBLER.toFcInfo(ultraVRParams.getFusionComputeInfo()));
    }

    private static UploadTemplateCmd buildUploadTemplateCmd(UltraVRParams ultraVRParams) {
        UltraTaskContext context = UltraTaskContext.getInstance();
        return UploadTemplateCmd.builder().templateName(ultraVRParams.getName()).filePath(() -> context.getRunningParamsCache().getTemplateVhdFile().orElse("")).ovfFilePath(() -> context.getRunningParamsCache().getTemplateOvfFile().orElse("")).cnaName(ultraVRParams.getTemplateInfo().getBelongCnaName()).datastoreName(ultraVRParams.getTemplateInfo().getDatastoreName()).templateIdHandler(UltraVRTaskFactory.templateIdHandler(context)).build();
    }

    private static Consumer<String> templateIdHandler(UltraTaskContext context) {
        return templateId -> {
            UltraVRRuntimeParams runningParamsCache = context.getRunningParamsCache();
            runningParamsCache.setTemplateId((String)templateId);
            runningParamsCache.addVmId((String)templateId);
        };
    }

    private static CreateVmByTemplateTask createVmByTemplateTask(UltraVRParams ultraVRParams) {
        CreateVmByTemplateCmd ultraVRVmCmd = UltraVRTaskFactory.buildCreateVmByTemplateCmd(ultraVRParams);
        return FcTaskService.createVmByTemplateTask((CreateVmByTemplateCmd)ultraVRVmCmd, (FcLoginInfo)ASSEMBLER.toFcInfo(ultraVRParams.getFusionComputeInfo()));
    }

    private static CreateVmByTemplateCmd buildCreateVmByTemplateCmd(UltraVRParams ultraVRParams) {
        UltraTaskContext context = UltraTaskContext.getInstance();
        return ((CreateVmByTemplateCmd.CreateVmByTemplateCmdBuilder)((CreateVmByTemplateCmd.CreateVmByTemplateCmdBuilder)((CreateVmByTemplateCmd.CreateVmByTemplateCmdBuilder)((CreateVmByTemplateCmd.CreateVmByTemplateCmdBuilder)CreateVmByTemplateCmd.builder().templateId(() -> context.getRunningParamsCache().getTemplateId().orElse("")).vmName(ultraVRParams.getName())).cnaName(ultraVRParams.getTemplateInfo().getBelongCnaName())).datastoreName(ultraVRParams.getDatastoreName())).hostName(ultraVRParams.getName()).nicConfigs(Collections.singletonList(ASSEMBLER.toNic(ultraVRParams))).vmIdHandler(vmId -> context.getRunningParamsCache().addVmId((String)vmId))).build();
    }

    private static TemplateCheckAndCleanTask createCleanTask() {
        return ((TemplateCheckAndCleanTask.TemplateCheckAndCleanTaskBuilder)((TemplateCheckAndCleanTask.TemplateCheckAndCleanTaskBuilder)((TemplateCheckAndCleanTask.TemplateCheckAndCleanTaskBuilder)((TemplateCheckAndCleanTask.TemplateCheckAndCleanTaskBuilder)((TemplateCheckAndCleanTask.TemplateCheckAndCleanTaskBuilder)TemplateCheckAndCleanTask.builder().supportOperates(Arrays.asList(TaskOperateEnum.SKIP, TaskOperateEnum.RETRY))).skipMsg(TaskResourceUtils.getString("skip.msg.template.clean"))).taskName(TaskResourceUtils.getTaskName("template.check.clean"))).duration(TaskResourceUtils.getTaskDuration("template.check.clean"))).eventType("ultraVRDeployEvent")).build();
    }

    @Generated
    private UltraVRTaskFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

