/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.lifecycle.util;

import com.alibaba.fastjson.JSON;
import com.huawei.ism.tool.lifecycle.model.ToolLifecycleMessage;
import com.huawei.ism.tool.obase.exception.ToolException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ToolLifecycleMessageReportUtil {
    private static final Logger log = LoggerFactory.getLogger(ToolLifecycleMessageReportUtil.class);
    public static final Path TOOL_MESSAGE_DIRECTORY = Paths.get("data", "tool_message");
    private static final Path SUB_TOOLS_TOOL_MESSAGE_DIRECTORY = ToolLifecycleMessageReportUtil.getToolBoxPathBySystemProperty();
    private static final DateTimeFormatter FILE_SUFFIX_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS");
    private static final String UNREPORTED_EVENT = "unreportedEvent";
    private static final String TOOLS_PATH = "tools";

    public static void reportMessage(ToolLifecycleMessage toolLifecycleMessage) throws ToolException {
        String toolName = toolLifecycleMessage.getToolName();
        String bizType = toolLifecycleMessage.getBizType();
        log.info("Start to report {}--{} message", (Object)toolName, (Object)bizType);
        try {
            if (SUB_TOOLS_TOOL_MESSAGE_DIRECTORY == null) {
                log.error("Get tool message path failed ");
                return;
            }
            ToolLifecycleMessageReportUtil.makeSaveDir(toolName);
            String messageJson = JSON.toJSONString((Object)toolLifecycleMessage);
            Files.write(SUB_TOOLS_TOOL_MESSAGE_DIRECTORY.resolve(toolName).resolve(ToolLifecycleMessageReportUtil.generateMessageFileName(bizType)), messageJson.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
        }
        catch (IOException e) {
            throw new ToolException("report message failed.", false, (Throwable)e);
        }
    }

    public static void saveUnreportedMessage(ToolLifecycleMessage toolLifecycleMessage) throws ToolException {
        String toolName = toolLifecycleMessage.getToolName();
        try {
            if (SUB_TOOLS_TOOL_MESSAGE_DIRECTORY == null) {
                log.error("Get tool message path failed ");
                return;
            }
            ToolLifecycleMessageReportUtil.makeSaveDir(toolName + File.separator + UNREPORTED_EVENT);
            String messageJson = JSON.toJSONString((Object)toolLifecycleMessage);
            Files.write(SUB_TOOLS_TOOL_MESSAGE_DIRECTORY.resolve(toolName).resolve(UNREPORTED_EVENT).resolve(ToolLifecycleMessageReportUtil.generateMessageFileName(toolLifecycleMessage.getBizType())), messageJson.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
        }
        catch (IOException e) {
            throw new ToolException("Failed to save unreportedEvent.", false, (Throwable)e);
        }
    }

    private static String generateMessageFileName(String bizType) {
        return bizType + "-" + FILE_SUFFIX_FORMATTER.format(LocalDateTime.now()) + ".json";
    }

    private static void makeSaveDir(String toolName) throws ToolException {
        Path toolDirectory = SUB_TOOLS_TOOL_MESSAGE_DIRECTORY.resolve(toolName);
        try {
            Files.createDirectories(toolDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new ToolException("Failed to create directory", false, (Throwable)e);
        }
    }

    private static Path getToolBoxPathBySystemProperty() {
        String currentDir = System.getProperty("user.dir");
        int lastIndex = currentDir.lastIndexOf(TOOLS_PATH);
        if (lastIndex == -1) {
            return null;
        }
        return Paths.get(currentDir.substring(0, lastIndex), new String[0]).resolve(TOOL_MESSAGE_DIRECTORY);
    }

    private ToolLifecycleMessageReportUtil() {
    }
}

