/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.spring.boot.starter.webapp;

import org.camunda.bpm.spring.boot.starter.CamundaBpmAutoConfiguration;
import org.camunda.bpm.spring.boot.starter.property.CamundaBpmProperties;
import org.camunda.bpm.spring.boot.starter.property.WebappProperty;
import org.camunda.bpm.spring.boot.starter.webapp.CamundaBpmWebappInitializer;
import org.camunda.bpm.spring.boot.starter.webapp.filter.LazyDelegateFilter;
import org.camunda.bpm.spring.boot.starter.webapp.filter.LazyInitRegistration;
import org.camunda.bpm.spring.boot.starter.webapp.filter.ResourceLoaderDependingFilter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ResourceLoader;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@ConditionalOnProperty(prefix="camunda.bpm.webapp", name={"enabled"}, matchIfMissing=true)
@ConditionalOnBean(value={CamundaBpmProperties.class})
@ConditionalOnWebApplication
@AutoConfigureAfter(value={CamundaBpmAutoConfiguration.class})
public class CamundaBpmWebappAutoConfiguration
implements WebMvcConfigurer {
    @Autowired
    private ResourceLoader resourceLoader;
    @Autowired
    private CamundaBpmProperties properties;

    @Bean
    public CamundaBpmWebappInitializer camundaBpmWebappInitializer() {
        return new CamundaBpmWebappInitializer(this.properties);
    }

    @Bean(name={"resourceLoaderDependingInitHook"})
    public LazyDelegateFilter.InitHook<ResourceLoaderDependingFilter> resourceLoaderDependingInitHook() {
        return filter -> {
            filter.setResourceLoader(this.resourceLoader);
            filter.setWebappProperty(this.properties.getWebapp());
        };
    }

    @Bean
    public LazyInitRegistration lazyInitRegistration() {
        return new LazyInitRegistration();
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        String classpath = "classpath:" + this.properties.getWebapp().getWebjarClasspath();
        WebappProperty webapp = this.properties.getWebapp();
        String applicationPath = webapp.getApplicationPath();
        registry.addResourceHandler(new String[]{applicationPath + "/lib/**"}).addResourceLocations(new String[]{classpath + "/lib/"});
        registry.addResourceHandler(new String[]{applicationPath + "/api/**"}).addResourceLocations(new String[]{"classpath:/api/"});
        registry.addResourceHandler(new String[]{applicationPath + "/app/**"}).addResourceLocations(new String[]{classpath + "/app/"});
    }

    public void addViewControllers(ViewControllerRegistry registry) {
        WebappProperty webapp = this.properties.getWebapp();
        if (webapp.isIndexRedirectEnabled()) {
            String applicationPath = webapp.getApplicationPath();
            registry.addRedirectViewController("/", applicationPath + "/app/");
        }
    }
}

