/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.variable.impl.type;

import java.util.Map;
import org.camunda.bpm.engine.variable.type.ValueType;
import org.camunda.bpm.engine.variable.value.TypedValue;

public abstract class AbstractValueTypeImpl
implements ValueType {
    private static final long serialVersionUID = 1L;
    protected String name;

    public AbstractValueTypeImpl(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @Override
    public ValueType getParent() {
        return null;
    }

    @Override
    public boolean canConvertFromTypedValue(TypedValue typedValue) {
        return false;
    }

    @Override
    public TypedValue convertFromTypedValue(TypedValue typedValue) {
        throw this.unsupportedConversion(typedValue.getType());
    }

    protected IllegalArgumentException unsupportedConversion(ValueType typeToConvertTo) {
        return new IllegalArgumentException("The type " + this.getName() + " supports no conversion from type: " + typeToConvertTo.getName());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractValueTypeImpl other = (AbstractValueTypeImpl)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    protected Boolean isTransient(Map<String, Object> valueInfo) {
        if (valueInfo != null && valueInfo.containsKey("transient")) {
            Object isTransient = valueInfo.get("transient");
            if (isTransient instanceof Boolean) {
                return (Boolean)isTransient;
            }
            throw new IllegalArgumentException("The property 'transient' should have a value of type 'boolean'.");
        }
        return false;
    }
}

