/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.huawei.json.JSONArrayIntf;
import com.huawei.json.JSONException;
import com.huawei.json.JSONObject;
import com.huawei.json.JSONUtils;
import java.util.Collection;
import java.util.Map;

public class JSONArray
implements JSONArrayIntf {
    private JsonArray members;

    public JSONArray() {
        this.members = new JsonArray();
    }

    public JSONArray(String source) throws JSONException {
        this.members = JSONUtils.parseToJsonArray(source);
    }

    public JSONArray(Collection collection) {
        JsonElement var = JSONUtils.parseToJsonElement(collection);
        this.members = var instanceof JsonArray ? (JsonArray)var : new JsonArray();
    }

    JSONArray(JsonArray array) {
        this.members = array;
    }

    @Override
    public Object get(int index) throws JSONException {
        Object object = this.opt(index);
        if (object instanceof JsonObject) {
            return new JSONObject((JsonObject)object);
        }
        if (object instanceof JsonNull) {
            return JSONObject.NULL;
        }
        if (object instanceof JsonArray) {
            return new JSONArray((JsonArray)object);
        }
        if (object instanceof JsonPrimitive) {
            return JSONUtils.INSTANCE.castJsonElement((JsonPrimitive)object);
        }
        return object;
    }

    @Override
    public boolean getBoolean(int index) throws JSONException {
        boolean result;
        JsonElement element = (JsonElement)this.opt(index);
        try {
            result = element.getAsJsonPrimitive().getAsBoolean();
        }
        catch (Exception e) {
            throw new JSONException("JSONObject is not a Boolean.");
        }
        return result;
    }

    @Override
    public double getDouble(int index) throws JSONException {
        double result;
        JsonElement element = (JsonElement)this.opt(index);
        try {
            result = element.getAsJsonPrimitive().getAsDouble();
        }
        catch (Exception e) {
            throw new JSONException("JSONObject is not a Number.");
        }
        return result;
    }

    @Override
    public int getInt(int index) throws JSONException {
        int result;
        JsonElement element = (JsonElement)this.opt(index);
        try {
            result = element.getAsJsonPrimitive().getAsInt();
        }
        catch (Exception e) {
            throw new JSONException("JSONObject is not a Number.");
        }
        return result;
    }

    @Override
    public JSONArray getJSONArray(int index) throws JSONException {
        Object object = this.get(index);
        if (object instanceof JSONArray) {
            return (JSONArray)object;
        }
        throw new JSONException("JSONArray[" + index + "] is not a JSONArray.");
    }

    @Override
    public JSONObject getJSONObject(int index) throws JSONException {
        Object object = this.get(index);
        if (object instanceof JSONObject) {
            return (JSONObject)object;
        }
        throw new JSONException("JSONArray[" + index + "] is not a JSONObject.");
    }

    @Override
    public long getLong(int index) throws JSONException {
        long result;
        JsonElement element = (JsonElement)this.opt(index);
        try {
            result = element.getAsJsonPrimitive().getAsLong();
        }
        catch (Exception e) {
            throw new JSONException("JSONObject is not a Number.");
        }
        return result;
    }

    @Override
    public String getString(int index) throws JSONException {
        String result;
        JsonElement element = (JsonElement)this.opt(index);
        try {
            result = element.getAsJsonPrimitive().getAsString();
        }
        catch (Exception e) {
            throw new JSONException("JSONObject is not a String.");
        }
        return result;
    }

    @Override
    public boolean isNull(int index) {
        return this.members.get(index).isJsonNull();
    }

    @Override
    public int length() {
        return this.members.size();
    }

    @Override
    public Object opt(int index) {
        JsonElement object;
        JsonElement jsonElement = object = index < 0 || index >= this.length() ? null : this.members.get(index);
        if (object == null) {
            throw new JSONException("JSONArray[" + index + "] not found.");
        }
        return object;
    }

    @Override
    public boolean optBoolean(int index) {
        return this.optBoolean(index, false);
    }

    @Override
    public boolean optBoolean(int index, boolean defaultValue) {
        try {
            return this.getBoolean(index);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @Override
    public double optDouble(int index) {
        return this.optDouble(index, Double.NaN);
    }

    @Override
    public double optDouble(int index, double defaultValue) {
        try {
            return this.getDouble(index);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @Override
    public int optInt(int index) {
        return this.optInt(index, 0);
    }

    @Override
    public int optInt(int index, int defaultValue) {
        try {
            return this.getInt(index);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @Override
    public long optLong(int index) {
        return this.optLong(index, 0L);
    }

    @Override
    public long optLong(int index, long defaultValue) {
        try {
            return this.getLong(index);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @Override
    public String optString(int index) {
        return this.optString(index, "");
    }

    @Override
    public String optString(int index, String defaultValue) {
        try {
            return this.getString(index);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @Override
    public JSONArray put(boolean value) {
        return this.put(value ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public JSONArray put(Collection value) {
        this.put(new JSONArray(value));
        return this;
    }

    @Override
    public JSONArray put(double value) throws JSONException {
        Double aDouble = new Double(value);
        this.put(aDouble);
        return this;
    }

    @Override
    public JSONArray put(int value) {
        this.put(new Integer(value));
        return this;
    }

    @Override
    public JSONArray put(long value) {
        this.put(new Long(value));
        return this;
    }

    @Override
    public JSONArray put(Map value) {
        this.put(new JSONObject(value));
        return this;
    }

    @Override
    public JSONArray put(Object value) {
        this.add(value);
        return this;
    }

    @Override
    public Object remove(int index) {
        Object object = this.opt(index);
        this.members.remove(index);
        return object;
    }

    public String toString() {
        return this.members.toString();
    }

    private void add(Object object) {
        if (object instanceof Number) {
            this.members.add((Number)object);
        } else if (object instanceof Boolean) {
            this.members.add((Boolean)object);
        } else if (object instanceof Character) {
            this.members.add((Character)object);
        } else if (object instanceof String) {
            this.members.add((String)object);
        } else if (object instanceof JSONObject) {
            this.members.add(((JSONObject)object).getMembers());
        } else if (object instanceof JSONArray) {
            this.members.add(((JSONArray)object).getMembers());
        } else {
            this.members.add(JSONUtils.parseToJsonElement(object));
        }
    }

    public JsonArray getMembers() {
        return this.members;
    }
}

