/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.os.bean;

import com.huawei.yinglong.river.sitedeployment.dcs.os.bean.BaseOsTemplate;
import com.huawei.yinglong.river.sitedeployment.dcs.os.bean.OsType;
import com.huawei.yinglong.river.sitedeployment.dcs.os.context.DeployOsContext;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FilePathValidatorUtils;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

public class AtlasOsArmTemplate
extends BaseOsTemplate {
    private OsType osType = OsType.ATLAS_ARM;
    private String defaultIsoName = "EulerOS-V2.0SP12-ARM_64-dvd.iso";
    private String packageCmd = "\"" + DeployOsContext.GENISOIMAGE_TOOL_DIR + "\" -R -J -T -r -l -d -allow-multidot -o \"" + this.defaultIsoName + "\" -b \"images/efiboot.img\" -no-emul-boot .";
    private String templatesPath = FilePathValidatorUtils.joinChildPath((String[])new String[]{DeployOsContext.BASE_DIR, "templates", "atlas", "a2", "arm"});
    private Map<String, String> renameFiles = new HashMap<String, String>();

    public AtlasOsArmTemplate() {
        this.initRenameFiles();
        this.initAtlasArmReplaceFiles();
        this.initAtlasArmAddFiles();
    }

    private void initRenameFiles() {
        this.renameFiles.put("efibootimg", "efiboot.img");
    }

    private void initAtlasArmReplaceFiles() {
        super.getReplaceFiles().put("grub.cfg", Collections.singletonList(String.join((CharSequence)File.separator, "EFI", "BOOT", "grub.cfg")));
    }

    private void initAtlasArmAddFiles() {
        super.getAddFiles().put("ks.cfg", Collections.singletonList(String.join((CharSequence)File.separator, "ks", "ks.cfg")));
    }

    @Override
    @Generated
    public OsType getOsType() {
        return this.osType;
    }

    @Override
    @Generated
    public String getDefaultIsoName() {
        return this.defaultIsoName;
    }

    @Override
    @Generated
    public String getPackageCmd() {
        return this.packageCmd;
    }

    @Override
    @Generated
    public String getTemplatesPath() {
        return this.templatesPath;
    }

    @Override
    @Generated
    public Map<String, String> getRenameFiles() {
        return this.renameFiles;
    }
}

