/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.os.bean;

import com.huawei.yinglong.river.sitedeployment.dcs.os.bean.BaseOsTemplate;
import com.huawei.yinglong.river.sitedeployment.dcs.os.bean.OsType;
import com.huawei.yinglong.river.sitedeployment.dcs.os.context.DeployOsContext;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FilePathValidatorUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.iamge.ImageConstant;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

public class AtlasOsX86Template
extends BaseOsTemplate {
    private OsType osType = OsType.ATLAS_X86;
    private String defaultIsoName = "EulerOS-V2.0SP12-x86_64-dvd.iso";
    private String packageCmd = "\"" + ImageConstant.XORRISO_TOOL_PATH + "\"  as mkisofs -R -J -T -r -l -d -joliet-long -allow-multidot -allow-leading-dots -no-bak -V \"EulerOS-V2.0SP12-x86_64\" -o \"" + this.defaultIsoName + "\" -b \"isolinux/isolinux.bin\" -c isolinux/boot.cat -no-emul-boot -boot-load-size 4 -boot-info-table -eltorito-alt-boot -e \"images/efiboot.img\" -no-emul-boot .";
    private String templatesPath = FilePathValidatorUtils.joinChildPath((String[])new String[]{DeployOsContext.BASE_DIR, "templates", "atlas", "a2", "x86"});
    private Map<String, String> renameFiles = new HashMap<String, String>();

    public AtlasOsX86Template() {
        this.initRenameFiles();
        this.initAtlasX86ReplaceFiles();
    }

    private void initRenameFiles() {
        this.renameFiles.put(String.join((CharSequence)File.separator, "images", "efiboot"), String.join((CharSequence)File.separator, "images", "efiboot.img"));
    }

    private void initAtlasX86ReplaceFiles() {
        super.getReplaceFiles().put("grub.cfg", Collections.singletonList(String.join((CharSequence)File.separator, "EFI", "BOOT", "grub.cfg")));
    }

    @Override
    @Generated
    public OsType getOsType() {
        return this.osType;
    }

    @Override
    @Generated
    public String getDefaultIsoName() {
        return this.defaultIsoName;
    }

    @Override
    @Generated
    public String getPackageCmd() {
        return this.packageCmd;
    }

    @Override
    @Generated
    public String getTemplatesPath() {
        return this.templatesPath;
    }

    @Override
    @Generated
    public Map<String, String> getRenameFiles() {
        return this.renameFiles;
    }
}

