/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.os.config;

import com.huawei.yinglong.river.sitedeployment.dcs.utils.ConfigFilesUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.NumberUtils;
import java.io.File;
import lombok.Generated;

public final class DeployOsConfigUtils {
    private static final String CONFIG_DIR = "configProperties";
    private static final String CONFIG_FILE_NAME = "deployos.properties";
    private static final String WAIT_TIME_KEY = "deployos.reboot.limit.time";
    private static final String WAIT_TIME_A3000_KEY = "deployos.reboot.a3000.limit.time";
    private static final String WAIT_BATCH_INSTALL_KEY = "deployos.batch.wait.limit.time";
    private static final String CONFIG_PATH = String.join((CharSequence)File.separator, "configProperties", "deployos.properties");

    public static int getRebootWaitTime() {
        String waitMinusTime = ConfigFilesUtils.getConfigValueFromCustomFile((String)CONFIG_PATH, (String)WAIT_TIME_KEY).orElse("30");
        return Math.max(1, NumberUtils.parseInt((String)waitMinusTime, (int)30));
    }

    public static int getRebootA3000WaitTime() {
        String waitMinusTime = ConfigFilesUtils.getConfigValueFromCustomFile((String)CONFIG_PATH, (String)WAIT_TIME_A3000_KEY).orElse("60");
        return Math.max(15, NumberUtils.parseInt((String)waitMinusTime, (int)60));
    }

    public static int getBatchInstallWaitTime() {
        String waitMinusTime = ConfigFilesUtils.getConfigValueFromCustomFile((String)CONFIG_PATH, (String)WAIT_BATCH_INSTALL_KEY).orElse("60");
        return Math.max(1, NumberUtils.parseInt((String)waitMinusTime, (int)60));
    }

    public static String getString(String key) {
        return ConfigFilesUtils.getConfigValueFromCustomFile((String)CONFIG_PATH, (String)key).orElse("");
    }

    @Generated
    private DeployOsConfigUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

