/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.os.fit;

import com.huawei.yinglong.river.sitedeployment.dcs.os.bean.OsDeployBaseInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.os.bean.OsDeployImagesInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.os.bean.OsDeployNode;
import com.huawei.yinglong.river.sitedeployment.dcs.os.bean.OsType;
import com.huawei.yinglong.river.sitedeployment.dcs.os.bean.raid.RaidNodeInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.os.entity.params.A3000BmcInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.os.entity.params.A3000OsDeployParams;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class A3000OsAssembler {
    public OsDeployNode toOsDeployNode(A3000OsDeployParams params) {
        if (params == null) {
            return new OsDeployNode();
        }
        OsDeployNode osDeployNode = new OsDeployNode();
        osDeployNode.setOsType(Objects.equals("ARM", params.getArch()) ? OsType.ATLAS_ARM : OsType.ATLAS_X86);
        osDeployNode.setBaseInfo(this.toOsBaseInfo(params));
        osDeployNode.setRaidNodeInfo(new RaidNodeInfo());
        OsDeployImagesInfo imagesInfo = new OsDeployImagesInfo();
        imagesInfo.setIsoImagesPath(params.getIsoImagesPath());
        osDeployNode.setImagesInfo(imagesInfo);
        osDeployNode.setNetworkPlaneInfoList(params.getNetworkPlaneInfoList());
        osDeployNode.setDiskInfo(params.getDiskInfo());
        return osDeployNode;
    }

    private OsDeployBaseInfo toOsBaseInfo(A3000OsDeployParams params) {
        A3000BmcInfo bmc = params.getBmcInfo();
        if (bmc == null) {
            return new OsDeployBaseInfo();
        }
        OsDeployBaseInfo baseInfo = new OsDeployBaseInfo();
        baseInfo.setHostName(params.getDevName());
        baseInfo.setBmcIp(bmc.getIp());
        if (!StringUtils.isBlank((CharSequence)params.getPortName())) {
            baseInfo.setDevice(params.getPortName());
        }
        baseInfo.setBmcUser(bmc.getUsername());
        baseInfo.setBmcPassword(bmc.getPassword());
        baseInfo.setKsPassword(params.getRootPwd());
        baseInfo.setAtlasIp(params.getManagerIp());
        baseInfo.setAtlasSubNetMask(params.getNetmask());
        baseInfo.setAtlasGateway(params.getGateway());
        baseInfo.setRoot("root");
        baseInfo.setRootPassword(params.getRootPwd());
        baseInfo.setInterconnectPwd(params.getInterconnectPwd());
        baseInfo.setFc2mgmtPwd(bmc.getFc2mgmtPwd());
        return baseInfo;
    }
}

