/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.os.fit.impl;

import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.river.deploy.virtualization.common.entity.DeployTaskInfoVo;
import com.huawei.yinglong.river.sitedeployment.dcs.os.entity.params.A3000OsDeployParams;
import com.huawei.yinglong.river.sitedeployment.dcs.os.exception.DeployOsError;
import com.huawei.yinglong.river.sitedeployment.dcs.os.exception.DeployOsException;
import com.huawei.yinglong.river.sitedeployment.dcs.os.fit.A3000OsAssembler;
import com.huawei.yinglong.river.sitedeployment.dcs.os.service.task.BatchDeployAtlasOsTask;
import com.huawei.yinglong.river.sitedeployment.dcs.os.service.task.DeployAtlasOsFactory;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.CommonTaskManager;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskStatus;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ResponseUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.exception.ErrorDetail;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class A3000DeployOsFitImpl {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(A3000DeployOsFitImpl.class);
    private final A3000OsAssembler a3000OsAssembler;

    public Response<String> retryDeployOsService(String taskId) {
        log.info("retry {} a3000 os deploy task", (Object)taskId);
        Optional deployAtlasTask = CommonTaskManager.getInstance().queryTaskById(taskId);
        if (!deployAtlasTask.isPresent()) {
            return ResponseUtils.failed((Object)"not find task.");
        }
        LinkedList<String> failedTaskIds = new LinkedList<String>();
        CommonTaskManager.getInstance().queryTaskById(taskId).map(BaseTask::getSubTasks).ifPresent(subTasks -> failedTaskIds.addAll(subTasks.stream().filter(task -> task.getTaskResult().getTaskStatus() == TaskStatus.ERROR).map(BaseTask::getTaskId).collect(Collectors.toList())));
        return this.retryDeployOsService(taskId, failedTaskIds);
    }

    public Response<String> retryDeployOsService(String taskId, List<String> serverIds) {
        log.info("retry {} a3000 os servers {} deploy task", (Object)taskId, serverIds);
        Optional deployAtlasTask = CommonTaskManager.getInstance().queryTaskById(taskId);
        if (!deployAtlasTask.isPresent()) {
            return ResponseUtils.failed((Object)"");
        }
        deployAtlasTask.filter(task -> task instanceof BatchDeployAtlasOsTask).map(BatchDeployAtlasOsTask.class::cast).ifPresent(task -> {
            task.getTaskResult().setTaskStatus(TaskStatus.NOT_START);
            task.setNeedExecTaskIds(serverIds);
        });
        boolean result = CommonTaskManager.getInstance().startTaskById(taskId);
        log.info("retry task {} servers {} result {}", new Object[]{taskId, serverIds, result});
        return result ? ResponseUtils.success((Object)taskId) : ResponseUtils.failed((Object)"");
    }

    public Response<DeployTaskInfoVo> queryDeployDetails(String taskId) {
        log.info("query a3000 os deploy task {} status", (Object)taskId);
        Optional deployTaskInfoVo = CommonTaskManager.getInstance().queryTaskDetailById(taskId);
        if (deployTaskInfoVo.isPresent()) {
            return ResponseUtils.success(deployTaskInfoVo.get());
        }
        return ResponseUtils.failed((ErrorDetail)new DeployOsException(DeployOsError.PARAM_ERROR));
    }

    public Response<String> startDeployOsService(String taskId, List<A3000OsDeployParams> deployOsParams) {
        log.info("start new a3000 os deploy task {}", (Object)taskId);
        CommonTaskManager.getInstance().addTask((BaseTask)DeployAtlasOsFactory.createDeployAtlasOsTask(deployOsParams.stream().map(this.a3000OsAssembler::toOsDeployNode).collect(Collectors.toList()), taskId));
        CommonTaskManager.getInstance().startTaskById(taskId);
        return ResponseUtils.success((Object)taskId);
    }

    @Generated
    public A3000DeployOsFitImpl(A3000OsAssembler a3000OsAssembler) {
        this.a3000OsAssembler = a3000OsAssembler;
    }
}

