/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.os.fit.impl;

import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.river.deploy.virtualization.common.entity.DeployTaskInfoVo;
import com.huawei.yinglong.river.deploy.virtualization.deployos.entity.DeployOsParams;
import com.huawei.yinglong.river.sitedeployment.dcs.os.bean.OsDeployNode;
import com.huawei.yinglong.river.sitedeployment.dcs.os.exception.DeployOsError;
import com.huawei.yinglong.river.sitedeployment.dcs.os.exception.DeployOsException;
import com.huawei.yinglong.river.sitedeployment.dcs.os.fit.OsAssembler;
import com.huawei.yinglong.river.sitedeployment.dcs.os.service.task.DeployOsFactory;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.CommonTaskManager;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ResponseUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.exception.ErrorDetail;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DeployOsFitImpl {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeployOsFitImpl.class);
    private final OsAssembler assembler;

    public Response<Boolean> updateDeployOsParam(DeployOsParams deployOsParams) {
        String taskId = deployOsParams.getTaskId();
        log.info("update os deploy task param {}", (Object)taskId);
        Optional deployTaskByTaskId = CommonTaskManager.getInstance().queryTaskById(taskId);
        if (!deployTaskByTaskId.isPresent()) {
            return ResponseUtils.failed((Object)false);
        }
        if (!((BaseTask)deployTaskByTaskId.get()).canStart()) {
            log.error("current task {} status is {} ,can't update param.", (Object)taskId, (Object)((BaseTask)deployTaskByTaskId.get()).getTaskResult().getTaskStatus());
            return ResponseUtils.failed((Object)false);
        }
        OsDeployNode node = this.assembler.toBo(deployOsParams);
        CommonTaskManager.getInstance().addTask((BaseTask)DeployOsFactory.createDeployCnaOsTask(node, taskId));
        return ResponseUtils.success((Object)true);
    }

    public Response<String> retryDeployOsService(String taskId) {
        log.info("retry {} os deploy task", (Object)taskId);
        Optional deployTask = CommonTaskManager.getInstance().queryTaskById(taskId);
        if (!deployTask.isPresent()) {
            return ResponseUtils.failed((Object)"");
        }
        CommonTaskManager.getInstance().startTaskById(taskId);
        log.info("retry task {} success", (Object)taskId);
        return ResponseUtils.success((Object)taskId);
    }

    public Response<DeployTaskInfoVo> queryDeployDetails(String taskId) {
        log.info("query os deploy task {} status", (Object)taskId);
        Optional deployTaskInfoVo = CommonTaskManager.getInstance().queryTaskDetailById(taskId);
        if (deployTaskInfoVo.isPresent()) {
            return ResponseUtils.success(deployTaskInfoVo.get());
        }
        return ResponseUtils.failed((ErrorDetail)new DeployOsException(DeployOsError.PARAM_ERROR));
    }

    public Response<String> startDeployOsService(DeployOsParams deployOsParams) {
        String taskId = deployOsParams.getTaskId();
        log.info("start new os deploy task {}", (Object)taskId);
        OsDeployNode node = this.assembler.toBo(deployOsParams);
        CommonTaskManager.getInstance().addTask((BaseTask)DeployOsFactory.createDeployCnaOsTask(node, taskId));
        CommonTaskManager.getInstance().startTaskById(taskId);
        return ResponseUtils.success((Object)taskId);
    }

    public Response<Boolean> skipDeployOsService(String taskId, String taskKey) {
        boolean isSuccessSkipTask = CommonTaskManager.getInstance().skipSubTaskById(taskKey);
        log.info("skip task {} {} ,result:{}", new Object[]{taskId, taskKey, isSuccessSkipTask});
        return ResponseUtils.success((Object)isSuccessSkipTask);
    }

    @Generated
    public DeployOsFitImpl(OsAssembler assembler) {
        this.assembler = assembler;
    }
}

