/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.os.network.util;

import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.SshException;
import com.huawei.yinglong.river.sitedeployment.dcs.os.network.bean.NetworkConstant;
import com.huawei.yinglong.river.sitedeployment.dcs.os.network.bean.NetworkNodeInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.os.network.bean.User;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshConnInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshConnService;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshManager;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshShellService;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ThreadUtils;
import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sshd.client.session.ClientSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshConnectNetworkManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SshConnectNetworkManager.class);
    private static final SshConnectNetworkManager INSTANCE = new SshConnectNetworkManager();
    private final ConcurrentHashMap<String, ClientSession> sessionMap = new ConcurrentHashMap();

    public synchronized SshShellService getShellClient(NetworkNodeInfo networkNodeInfo) throws SshException {
        try {
            log.info("start to create the ssh shell service of {}.", (Object)networkNodeInfo.getBmcIp());
            ClientSession session = SshManager.getSession((SshConnInfo)this.getSshConnInfo(networkNodeInfo));
            this.sessionMap.put(networkNodeInfo.getBmcIp(), session);
            SshShellService sshShellService = SshManager.createSshShellService((ClientSession)session);
            sshShellService.connect();
            for (int retryTimes = 1; retryTimes <= 3; ++retryTimes) {
                log.info("start to open sol, time:{}.", (Object)retryTimes);
                String sshResult = this.executeWithTimeoutAndRecord(sshShellService, "ipmcset -t sol -d activate -v 1 1", 5);
                if (sshResult.contains("Current SOL session is in private mode")) {
                    this.executeWithTimeoutAndRecord(sshShellService, "ipmcset -t sol -d deactivate -v 1", 5);
                    SshConnectNetworkManager.safeSleep(5000);
                    sshResult = this.executeWithTimeoutAndRecord(sshShellService, "ipmcset -t sol -d activate -v 1 1", 5);
                }
                ThreadUtils.threadSafeSleep((int)10, (TimeUnit)TimeUnit.SECONDS);
                if (StringUtils.containIgnoreCase((String)sshResult, (String[])new String[]{"Connect SOL successfully"}) && this.switchToRoot(networkNodeInfo, sshShellService, sshResult)) break;
            }
            return sshShellService;
        }
        catch (SshException e) {
            log.error("create ssh error,", (Throwable)e);
            throw e;
        }
    }

    private boolean switchToRoot(NetworkNodeInfo networkNodeInfo, SshShellService sshShellService, String sshResult) throws SshException {
        Pair<Boolean, Boolean> needLogin = this.isNeedLogin(sshShellService, sshResult, networkNodeInfo);
        if (!((Boolean)needLogin.getLeft()).booleanValue()) {
            if (((Boolean)needLogin.getRight()).booleanValue()) {
                log.info("login successfully.");
            } else {
                log.error("login os failed.");
            }
            return true;
        }
        Pair<Boolean, Boolean> solToOsResult = this.solToOs(sshShellService, networkNodeInfo);
        if (((Boolean)solToOsResult.getLeft()).booleanValue()) {
            return false;
        }
        if (((Boolean)solToOsResult.getRight()).booleanValue()) {
            log.info("login successfully.");
        } else {
            log.error("login os successfully, but switch to root failed.");
        }
        return true;
    }

    private boolean hadLoginSuccess(String sshResult) {
        String sshResultTemp = this.eliminatesResultColorCode(sshResult);
        return Arrays.stream(NetworkConstant.END_MARKS).anyMatch(endKey -> sshResultTemp.trim().endsWith((String)endKey));
    }

    private String eliminatesResultColorCode(String sshResult) {
        return sshResult.replaceAll("\\e\\[[\\d;]*[^\\d;]", "");
    }

    private Pair<Boolean, Boolean> isNeedLogin(SshShellService sshShellService, String sshResult, NetworkNodeInfo networkNodeInfo) throws SshException {
        if (sshResult.trim().endsWith("exit.]")) {
            return Pair.of((Object)true, (Object)true);
        }
        Pair<Boolean, Boolean> needContinueLogin = this.isNeedContinueLogin(sshShellService, sshResult, networkNodeInfo);
        if (!((Boolean)needContinueLogin.getLeft()).booleanValue()) {
            return needContinueLogin;
        }
        if (!sshResult.trim().endsWith("exit.]") && !sshResult.trim().endsWith("login:")) {
            return Pair.of((Object)false, (Object)false);
        }
        return Pair.of((Object)true, (Object)true);
    }

    private Pair<Boolean, Boolean> isNeedContinueLogin(SshShellService sshShellService, String sshResult, NetworkNodeInfo networkNodeInfo) throws SshException {
        if (this.hadLoginSuccess(sshResult)) {
            boolean isLoginedRoot = this.loginedRoot(sshResult, sshShellService) || this.suToRoot(sshShellService, networkNodeInfo);
            return Pair.of((Object)false, (Object)isLoginedRoot);
        }
        return Pair.of((Object)true, (Object)false);
    }

    private Pair<Boolean, Boolean> solToOs(SshShellService sshShellService, NetworkNodeInfo networkNodeInfo) throws SshException {
        String osUserName = networkNodeInfo.getOsUser().getUsername();
        if (!StringUtils.isEmpty((CharSequence)osUserName) && !StringUtils.isEmpty((CharSequence)networkNodeInfo.getOsUser().getPassword())) {
            String sshResult = this.executeWithTimeoutAndRecord(sshShellService, osUserName, 5);
            if ("TOOLKIT_SEND_CMD_TIME_OUT".equals(sshResult)) {
                this.offAndOnSol(sshShellService);
                return Pair.of((Object)true, (Object)false);
            }
            Pair<Boolean, Boolean> needContinueLogin = this.isNeedContinueLogin(sshShellService, sshResult, networkNodeInfo);
            if (((Boolean)needContinueLogin.getLeft()).booleanValue()) {
                return Pair.of((Object)false, (Object)this.suRootToLoginRoot(sshShellService, networkNodeInfo));
            }
            return needContinueLogin;
        }
        String sshResult = this.executeWithTimeoutAndRecord(sshShellService, networkNodeInfo.getRootUser().getUsername(), 5);
        if ("TOOLKIT_SEND_CMD_TIME_OUT".equals(sshResult)) {
            this.offAndOnSol(sshShellService);
            return Pair.of((Object)true, (Object)false);
        }
        Pair<Boolean, Boolean> needContinueLogin = this.isNeedContinueLogin(sshShellService, sshResult, networkNodeInfo);
        if (((Boolean)needContinueLogin.getLeft()).booleanValue()) {
            return Pair.of((Object)false, (Object)this.directLoginRoot(sshShellService, networkNodeInfo));
        }
        return needContinueLogin;
    }

    private boolean suToRoot(SshShellService sshShellService, NetworkNodeInfo networkNodeInfo) throws SshException {
        this.executeAndRecord(sshShellService, "su - root");
        String sshResult = sshShellService.execCommand(networkNodeInfo.getRootUser().getPassword());
        return this.loginedRoot(sshResult, sshShellService);
    }

    private boolean suRootToLoginRoot(SshShellService sshShellService, NetworkNodeInfo networkNodeInfo) throws SshException {
        sshShellService.execCommand(networkNodeInfo.getOsUser().getPassword());
        return this.suToRoot(sshShellService, networkNodeInfo);
    }

    private boolean directLoginRoot(SshShellService sshShellService, NetworkNodeInfo networkNodeInfo) throws SshException {
        String sshResult = sshShellService.execCommand(networkNodeInfo.getRootUser().getPassword());
        return this.loginedRoot(sshResult, sshShellService);
    }

    private boolean loginedRoot(String sshResult, SshShellService sshShellService) throws SshException {
        if (sshResult.contains("[root@")) {
            return true;
        }
        String whoamiResult = this.executeAndRecord(sshShellService, "whoami");
        return whoamiResult.contains("root");
    }

    private void offAndOnSol(SshShellService sshShellService) throws SshException {
        String sshResult = this.executeWithTimeoutAndRecord(sshShellService, "ipmcset -t service -d state -v RMCP+ disabled", 5).trim();
        if (!sshResult.toLowerCase(Locale.ROOT).contains("successfully")) {
            SshConnectNetworkManager.safeSleep(5000);
            this.executeWithTimeoutAndRecord(sshShellService, "ipmcset -t service -d state -v RMCP+ disabled", 5);
        }
        SshConnectNetworkManager.safeSleep(5000);
        sshResult = this.executeWithTimeoutAndRecord(sshShellService, "ipmcset -t service -d state -v RMCP+ enabled", 5).trim();
        if (!sshResult.toLowerCase(Locale.ROOT).contains("successfully")) {
            SshConnectNetworkManager.safeSleep(5000);
            this.executeWithTimeoutAndRecord(sshShellService, "ipmcset -t service -d state -v RMCP+ enabled", 5);
        }
        SshConnectNetworkManager.safeSleep(30000);
    }

    private SshConnInfo getSshConnInfo(NetworkNodeInfo networkNodeInfo) {
        String bmcIp = networkNodeInfo.getBmcIp();
        User bmcUser = networkNodeInfo.getBmcUser();
        return SshConnInfo.builder().hostName(bmcIp).userName(bmcUser.getUsername()).userPwd(bmcUser.getPassword()).build();
    }

    private String executeAndRecord(SshShellService sshShellService, String cmd) throws SshException {
        log.info("execute command line: {}", (Object)cmd);
        String sshResult = sshShellService.execCommand(cmd);
        log.info("result: {}", (Object)sshResult);
        return sshResult;
    }

    private String executeWithTimeoutAndRecord(SshShellService sshShellService, String cmd, int timeout) throws SshException {
        log.info("execute command line: {}", (Object)cmd);
        String sshResult = sshShellService.execCommandWithTimeout(cmd, timeout);
        log.info("result: {}", (Object)sshResult);
        return sshResult;
    }

    public static SshConnectNetworkManager getInstance() {
        return INSTANCE;
    }

    public static void safeSleep(int sleepTime) {
        ThreadUtils.threadSafeSleep((int)sleepTime, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public synchronized boolean releaseConnection(SshShellService sshShellService, String bmcIp) {
        ClientSession session = this.sessionMap.get(bmcIp);
        return SshManager.releaseConnService((SshConnService)sshShellService) && (session == null || SshManager.releaseSession((ClientSession)session));
    }

    @Generated
    private SshConnectNetworkManager() {
    }
}

