/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.os.service.cdrom;

import com.huawei.ism.cdrommount.CdRomMount;
import com.huawei.yinglong.river.sitedeployment.dcs.os.bean.OsDeployNode;
import com.huawei.yinglong.river.sitedeployment.dcs.os.service.cdrom.CdRomMountServiceFactory;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FilePathValidatorUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ThreadUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdRomMountServiceManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CdRomMountServiceManager.class);
    private static final CdRomMountServiceManager INSTANCE = new CdRomMountServiceManager();
    private final String defultVvmPort = "8208";
    private final String defultIpmiPort = "623";
    private Map<String, CdRomMount> cdromMountMap = new ConcurrentHashMap<String, CdRomMount>();

    public static CdRomMountServiceManager getInstance() {
        return INSTANCE;
    }

    public boolean mount(OsDeployNode deployNode) {
        String bmcIp = deployNode.getBaseInfo().getBmcIp();
        log.info("start mount iso image at {}", (Object)bmcIp);
        if (!this.cdromMountMap.containsKey(bmcIp)) {
            log.error("current node {} has not mount service", (Object)bmcIp);
            return false;
        }
        try {
            return this.cdromMountMap.get(bmcIp).mount();
        }
        catch (InterruptedException exception) {
            log.error("mount {} iso error", (Object)bmcIp, (Object)exception);
            return false;
        }
    }

    public void initCDRomMountService(OsDeployNode deployNode) {
        String bmcIp = deployNode.getBaseInfo().getBmcIp();
        String localImagePath = FilePathValidatorUtils.joinChildPath((String[])new String[]{deployNode.getImagesInfo().getLocalCacheImagesPath(), deployNode.getOsTemplate().getDefaultIsoName()});
        CdRomMount cdromMount = CdRomMountServiceFactory.create(deployNode, localImagePath, "8208", "623");
        this.cdromMountMap.put(bmcIp, cdromMount);
    }

    public boolean umount(OsDeployNode deployNode) {
        String bmcIp = deployNode.getBaseInfo().getBmcIp();
        if (!this.cdromMountMap.containsKey(bmcIp)) {
            return true;
        }
        CdRomMount cdromMount = this.cdromMountMap.get(bmcIp);
        try {
            boolean isUmountSuccess = (Boolean)ThreadUtils.submit(() -> ((CdRomMount)cdromMount).uMount()).get(5L, TimeUnit.MINUTES);
            log.info("{} umount iso {}", (Object)bmcIp, (Object)isUmountSuccess);
            return isUmountSuccess;
        }
        catch (Exception exception) {
            log.error("{} umount iso error", (Object)bmcIp, (Object)exception);
            return false;
        }
    }

    @Generated
    private CdRomMountServiceManager() {
    }
}

