/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.os.service.task;

import com.huawei.yinglong.river.sitedeployment.dcs.os.config.DeployOsConfigUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.os.exception.DeployOsError;
import com.huawei.yinglong.river.sitedeployment.dcs.os.exception.DeployOsException;
import com.huawei.yinglong.river.sitedeployment.dcs.os.utils.CommonRetryUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTaskResult;
import com.huawei.yinglong.river.sitedeployment.dcs.task.CommonTaskManager;
import com.huawei.yinglong.river.sitedeployment.dcs.task.DeployVmsTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.DeployVmsTaskManager;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;

public class BatchDeployAtlasOsTask
extends BaseTask {
    public static final String NAME_KEY = "deploy.atlas.os.batch";
    private List<String> needExecTaskIds;

    public void execute() throws TaskException {
        List<DeployVmsTask> deployVmsTasks = this.getSubTasks().stream().filter(task -> task instanceof DeployVmsTask).map(DeployVmsTask.class::cast).collect(Collectors.toList());
        List execVmTasks = deployVmsTasks.stream().filter(task -> CollectionUtils.isEmpty(this.needExecTaskIds) || this.needExecTaskIds.contains(task.getTaskId())).peek(task -> CommonTaskManager.getInstance().clearTaskResult((BaseTask)task)).collect(Collectors.toList());
        DeployVmsTaskManager.getInstance().addAndStartTask(execVmTasks);
        try {
            CommonRetryUtils.retry(() -> this.isTaskFinish(execVmTasks), DeployOsConfigUtils.getBatchInstallWaitTime(), TimeUnit.MINUTES);
        }
        catch (DeployOsException exception) {
            execVmTasks.stream().filter(BaseTask::isRunning).forEach(task -> this.setTaskTimeoutStatus((BaseTask)task, exception));
            throw exception;
        }
        finally {
            this.needExecTaskIds = Collections.emptyList();
        }
        if (!this.isTaskSuccess(deployVmsTasks)) {
            throw new DeployOsException(DeployOsError.DEPLOY_OS_FAILED);
        }
    }

    private void setTaskTimeoutStatus(BaseTask baseTask, TaskException exception) {
        if (baseTask.isRunning()) {
            BaseTaskResult taskResult = baseTask.getTaskResult();
            taskResult.setTaskStatus(exception.getTaskStatus());
            taskResult.setErrorMessage(exception.getErrorMessage());
            taskResult.setSuggestion(exception.getSuggestMessage());
            taskResult.setEndTime(LocalDateTime.now());
        }
        CollectionUtils.emptyIfNull((Collection)baseTask.getSubTasks()).stream().filter(BaseTask::isRunning).forEach(subTask -> this.setTaskTimeoutStatus((BaseTask)subTask, exception));
    }

    private boolean isTaskSuccess(List<DeployVmsTask> vmTasks) {
        return vmTasks.stream().map(task -> this.queryTask(task.getTaskId())).allMatch(BaseTask::isSuccess);
    }

    private boolean isTaskFinish(List<DeployVmsTask> vmTasks) {
        return vmTasks.stream().map(task -> this.queryTask(task.getTaskId())).allMatch(BaseTask::isFinish);
    }

    private BaseTask queryTask(String taskId) {
        return (BaseTask)CommonTaskManager.getInstance().queryTaskById(taskId).orElseThrow(() -> new DeployOsException(DeployOsError.PARAM_ERROR));
    }

    @Generated
    private static List<String> $default$needExecTaskIds() {
        return Collections.emptyList();
    }

    @Generated
    protected BatchDeployAtlasOsTask(BatchDeployAtlasOsTaskBuilder<?, ?> b) {
        super(b);
        this.needExecTaskIds = ((BatchDeployAtlasOsTaskBuilder)b).needExecTaskIds$set ? ((BatchDeployAtlasOsTaskBuilder)b).needExecTaskIds$value : BatchDeployAtlasOsTask.$default$needExecTaskIds();
    }

    @Generated
    public static BatchDeployAtlasOsTaskBuilder<?, ?> builder() {
        return new BatchDeployAtlasOsTaskBuilderImpl();
    }

    @Generated
    public void setNeedExecTaskIds(List<String> needExecTaskIds) {
        this.needExecTaskIds = needExecTaskIds;
    }

    @Generated
    private static final class BatchDeployAtlasOsTaskBuilderImpl
    extends BatchDeployAtlasOsTaskBuilder<BatchDeployAtlasOsTask, BatchDeployAtlasOsTaskBuilderImpl> {
        @Generated
        private BatchDeployAtlasOsTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected BatchDeployAtlasOsTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public BatchDeployAtlasOsTask build() {
            return new BatchDeployAtlasOsTask(this);
        }
    }

    @Generated
    public static abstract class BatchDeployAtlasOsTaskBuilder<C extends BatchDeployAtlasOsTask, B extends BatchDeployAtlasOsTaskBuilder<C, B>>
    extends BaseTask.BaseTaskBuilder<C, B> {
        @Generated
        private boolean needExecTaskIds$set;
        @Generated
        private List<String> needExecTaskIds$value;

        @Generated
        public B needExecTaskIds(List<String> needExecTaskIds) {
            this.needExecTaskIds$value = needExecTaskIds;
            this.needExecTaskIds$set = true;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "BatchDeployAtlasOsTask.BatchDeployAtlasOsTaskBuilder(super=" + super.toString() + ", needExecTaskIds$value=" + this.needExecTaskIds$value + ")";
        }
    }
}

