/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.os.service.task;

import com.huawei.yinglong.river.sitedeployment.dcs.constant.TaskOperateEnum;
import com.huawei.yinglong.river.sitedeployment.dcs.os.bean.OsDeployNode;
import com.huawei.yinglong.river.sitedeployment.dcs.os.config.ResourceConfigLoader;
import com.huawei.yinglong.river.sitedeployment.dcs.os.context.DeployOsContext;
import com.huawei.yinglong.river.sitedeployment.dcs.os.service.os.OsTemplateService;
import com.huawei.yinglong.river.sitedeployment.dcs.os.service.task.DeployOsTask;
import com.huawei.yinglong.river.sitedeployment.dcs.os.service.task.subtask.impl.BmcMountSubTask;
import com.huawei.yinglong.river.sitedeployment.dcs.os.service.task.subtask.impl.BmcUnmountSubTask;
import com.huawei.yinglong.river.sitedeployment.dcs.os.service.task.subtask.impl.EnvCleanSubTask;
import com.huawei.yinglong.river.sitedeployment.dcs.os.service.task.subtask.impl.IsoImagesSubTask;
import com.huawei.yinglong.river.sitedeployment.dcs.os.service.task.subtask.impl.MonitIsoSetupSubTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FilePathValidatorUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DeployOsFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeployOsFactory.class);

    public static DeployOsTask createDeployCnaOsTask(OsDeployNode osDeployNode, String taskId) {
        DeployOsFactory.initOsTemplate(osDeployNode);
        List<BaseTask> subTasks = Arrays.asList(new BaseTask[]{DeployOsFactory.createIsoImagesSubTask(osDeployNode, "update.iso.image"), DeployOsFactory.createBmcMountSubTask(osDeployNode, "mount.os.to.ibmc"), DeployOsFactory.createMonitIsoSetupSubTask(osDeployNode), DeployOsFactory.createBmcUnmountSubTask(osDeployNode, "unmount.os.to.ibmc"), DeployOsFactory.createEnvCleanSubTask(osDeployNode, "clean.env.iso")});
        BaseTask osTask = ((DeployOsTask.DeployOsTaskBuilder)((DeployOsTask.DeployOsTaskBuilder)((DeployOsTask.DeployOsTaskBuilder)((DeployOsTask.DeployOsTaskBuilder)((DeployOsTask.DeployOsTaskBuilder)((DeployOsTask.DeployOsTaskBuilder)((DeployOsTask.DeployOsTaskBuilder)((DeployOsTask.DeployOsTaskBuilder)DeployOsTask.builder().taskId(UUID.randomUUID().toString())).taskName(ResourceConfigLoader.getTaskName("deploy.cna.os"))).taskDescription(ResourceConfigLoader.getTaskDescription("deploy.cna.os"))).duration(ResourceConfigLoader.getTaskDuration("deploy.cna.os"))).eventType("osDeployEvent")).subTasks(subTasks)).supportOperates(Collections.singletonList(TaskOperateEnum.SKIP))).skipMsg(ResourceConfigLoader.getStringFromFailedMsg("deployos.first.node.skip"))).build();
        return ((DeployOsTask.DeployOsTaskBuilder)((DeployOsTask.DeployOsTaskBuilder)((DeployOsTask.DeployOsTaskBuilder)((DeployOsTask.DeployOsTaskBuilder)((DeployOsTask.DeployOsTaskBuilder)((DeployOsTask.DeployOsTaskBuilder)DeployOsTask.builder().taskId(taskId)).taskName(ResourceConfigLoader.getTaskName("deploy.cna.os"))).taskDescription(ResourceConfigLoader.getTaskDescription("deploy.cna.os"))).duration(ResourceConfigLoader.getTaskDuration("deploy.cna.os"))).eventType("osDeployEvent")).subTasks(Collections.singletonList(osTask))).build();
    }

    static void initOsTemplate(OsDeployNode osDeployNode) {
        String isoCacheDir = osDeployNode.getBaseInfo().getBmcIp() + "_" + StringUtils.formatTimeText((String)"yyyyMMddHHmmssSS");
        Optional.ofNullable(osDeployNode.getImagesInfo()).ifPresent(info -> info.setLocalCacheImagesPath(FilePathValidatorUtils.joinChildPath((String[])new String[]{DeployOsContext.BASE_DIR, "iso_cache", isoCacheDir})));
        osDeployNode.setOsTemplate(OsTemplateService.getInstance().getOsTemplatesByOsType(osDeployNode.getOsType()));
    }

    static IsoImagesSubTask createIsoImagesSubTask(OsDeployNode osDeployNode, String taskNameKey) {
        return ((IsoImagesSubTask.IsoImagesSubTaskBuilder)((Object)((IsoImagesSubTask.IsoImagesSubTaskBuilder)((IsoImagesSubTask.IsoImagesSubTaskBuilder)((IsoImagesSubTask.IsoImagesSubTaskBuilder)((IsoImagesSubTask.IsoImagesSubTaskBuilder)IsoImagesSubTask.builder().taskName(ResourceConfigLoader.getTaskName(taskNameKey))).taskDescription(ResourceConfigLoader.getTaskDescription(taskNameKey))).duration(ResourceConfigLoader.getTaskDuration(taskNameKey))).eventType("osDeployEvent")).osDeployNode(osDeployNode))).build();
    }

    static BmcMountSubTask createBmcMountSubTask(OsDeployNode osDeployNode, String taskNameKey) {
        return ((BmcMountSubTask.BmcMountSubTaskBuilder)((Object)((BmcMountSubTask.BmcMountSubTaskBuilder)((BmcMountSubTask.BmcMountSubTaskBuilder)((BmcMountSubTask.BmcMountSubTaskBuilder)((BmcMountSubTask.BmcMountSubTaskBuilder)BmcMountSubTask.builder().taskName(ResourceConfigLoader.getTaskName(taskNameKey))).taskDescription(ResourceConfigLoader.getTaskDescription(taskNameKey))).duration(ResourceConfigLoader.getTaskDuration(taskNameKey))).eventType("osDeployEvent")).osDeployNode(osDeployNode))).build();
    }

    static MonitIsoSetupSubTask createMonitIsoSetupSubTask(OsDeployNode osDeployNode) {
        return ((MonitIsoSetupSubTask.MonitIsoSetupSubTaskBuilder)((Object)((MonitIsoSetupSubTask.MonitIsoSetupSubTaskBuilder)((MonitIsoSetupSubTask.MonitIsoSetupSubTaskBuilder)((MonitIsoSetupSubTask.MonitIsoSetupSubTaskBuilder)((MonitIsoSetupSubTask.MonitIsoSetupSubTaskBuilder)MonitIsoSetupSubTask.builder().taskName(ResourceConfigLoader.getTaskName("monit.iso.setup"))).taskDescription(ResourceConfigLoader.getTaskDescription("monit.iso.setup"))).duration(ResourceConfigLoader.getTaskDuration("monit.iso.setup"))).eventType("osDeployEvent")).osDeployNode(osDeployNode))).build();
    }

    static BmcUnmountSubTask createBmcUnmountSubTask(OsDeployNode osDeployNode, String taskNameKey) {
        return ((BmcUnmountSubTask.BmcUnmountSubTaskBuilder)((Object)((BmcUnmountSubTask.BmcUnmountSubTaskBuilder)((BmcUnmountSubTask.BmcUnmountSubTaskBuilder)((BmcUnmountSubTask.BmcUnmountSubTaskBuilder)((BmcUnmountSubTask.BmcUnmountSubTaskBuilder)BmcUnmountSubTask.builder().taskName(ResourceConfigLoader.getTaskName(taskNameKey))).taskDescription(ResourceConfigLoader.getTaskDescription(taskNameKey))).duration(ResourceConfigLoader.getTaskDuration(taskNameKey))).eventType("osDeployEvent")).osDeployNode(osDeployNode))).build();
    }

    static EnvCleanSubTask createEnvCleanSubTask(OsDeployNode osDeployNode, String taskNameKey) {
        return ((EnvCleanSubTask.EnvCleanSubTaskBuilder)((Object)((EnvCleanSubTask.EnvCleanSubTaskBuilder)((EnvCleanSubTask.EnvCleanSubTaskBuilder)((EnvCleanSubTask.EnvCleanSubTaskBuilder)((EnvCleanSubTask.EnvCleanSubTaskBuilder)EnvCleanSubTask.builder().taskName(ResourceConfigLoader.getTaskName(taskNameKey))).taskDescription(ResourceConfigLoader.getTaskDescription(taskNameKey))).duration(ResourceConfigLoader.getTaskDuration(taskNameKey))).eventType("osDeployEvent")).osDeployNode(osDeployNode))).build();
    }

    @Generated
    private DeployOsFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

