/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.os.service.task.subtask;

import com.huawei.yinglong.river.sitedeployment.dcs.http.HttpRequestApiFactory;
import com.huawei.yinglong.river.sitedeployment.dcs.os.bean.OsDeployNode;
import com.huawei.yinglong.river.sitedeployment.dcs.os.exception.DeployOsError;
import com.huawei.yinglong.river.sitedeployment.dcs.os.exception.DeployOsException;
import com.huawei.yinglong.river.sitedeployment.dcs.os.service.httprequest.BmcHttpRequest;
import com.huawei.yinglong.river.sitedeployment.dcs.os.service.httprequest.BmcQuerySupplier;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Response;

public abstract class BasicBmcSubTask
extends BaseTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BasicBmcSubTask.class);
    protected BmcHttpRequest requestApi;
    protected Map<String, String> defaultBmcHeaders;
    protected OsDeployNode osDeployNode;
    protected String bmcIp;
    private String bmcSessionId;

    public void beforeExecute() {
        super.beforeExecute();
        if (Objects.isNull(this.osDeployNode) || Objects.isNull(this.osDeployNode.getBaseInfo())) {
            log.error("os base info is empty");
            throw new DeployOsException(DeployOsError.PARAM_ERROR);
        }
        this.bmcIp = this.osDeployNode.getBaseInfo().getBmcIp();
        this.initBmcRequestFactory();
        this.loginBmc();
        this.tryUpdateSystemIdInfo(() -> this.requestApi.getSystems(this.defaultBmcHeaders).execute(), systemId -> {
            this.osDeployNode.setSystemId((String)systemId);
            Optional.ofNullable(this.osDeployNode.getRaidNodeInfo()).ifPresent(raidNodeInfo -> raidNodeInfo.setSystemId((String)systemId));
        });
    }

    public void afterExecute() {
        super.afterExecute();
        if (StringUtils.isNotEmpty((CharSequence)this.bmcSessionId) && !this.logoutBmc()) {
            log.warn("release bmc [{}] session failed.", (Object)this.bmcIp);
        }
    }

    protected void tryUpdateSystemIdInfo(BmcQuerySupplier<Response<Map<String, Object>>> apiSupplier, Consumer<String> consumer) {
        try {
            Response<Map<String, Object>> response = apiSupplier.execute();
            if (!response.isSuccessful()) {
                log.error("response failed. status : {}.", (Object)response.code());
                return;
            }
            String idUrl = Optional.ofNullable(response.body()).map(map -> map.get("Members")).filter(members -> !((List)members).isEmpty()).map(members -> ((List)members).get(0)).map(member -> ((Map)member).get("@odata.id")).map(String::valueOf).orElse("");
            if (StringUtils.isNotEmpty((CharSequence)idUrl) && idUrl.contains("/")) {
                log.info("query system id url : {}.", (Object)idUrl);
                consumer.accept(idUrl.substring(idUrl.lastIndexOf("/") + 1));
            }
        }
        catch (IOException e) {
            log.error("request exception failed.", (Throwable)e);
        }
    }

    private void initBmcRequestFactory() {
        String baseUrl = "https://" + this.bmcIp;
        this.requestApi = (BmcHttpRequest)HttpRequestApiFactory.createRequestApi((String)baseUrl, BmcHttpRequest.class);
    }

    private boolean logoutBmc() {
        try {
            return this.requestApi.logoutBmc(this.bmcSessionId, this.defaultBmcHeaders).execute().isSuccessful();
        }
        catch (IOException e) {
            log.error("release bmc session error", (Throwable)e);
            return false;
        }
    }

    private void loginBmc() {
        Response response;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("UserName", this.osDeployNode.getBaseInfo().getBmcUser());
        map.put("Password", this.osDeployNode.getBaseInfo().getBmcPassword());
        try {
            response = this.requestApi.loginBmc(this.getPreLoginBmcRequestHeader(), map).execute();
        }
        catch (IOException e) {
            log.error("old password login bmc failed", (Throwable)e);
            throw new DeployOsException(DeployOsError.LOGIN_SEND_REQ_ERROR);
        }
        if (!response.isSuccessful()) {
            log.error("login bmc failed,current code {}", (Object)response.code());
            throw new DeployOsException(DeployOsError.LOGIN_USER_PASSWORD_ERROR);
        }
        String token = response.headers().get("X-Auth-Token");
        if (StringUtils.isBlank((CharSequence)token)) {
            log.error("login in bmc failed, bmc ip: {}", (Object)this.bmcIp);
            throw new DeployOsException(DeployOsError.LOGIN_GET_TOKEN_ERROR);
        }
        this.initBmcHeader(token);
        this.bmcSessionId = this.getSessionId((Response<Map<String, Object>>)response);
    }

    private String getSessionId(Response<Map<String, Object>> response) {
        return Optional.ofNullable(response.body()).map(resp -> resp.get("Id")).map(String::valueOf).orElseGet(() -> Optional.ofNullable(response.headers().get("Location")).filter(location -> location.contains("/")).map(location -> location.substring(location.lastIndexOf("/") + 1)).orElse(""));
    }

    private void initBmcHeader(String token) {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("X-Auth-Token", token);
        header.put("Content-Type", "application/json");
        this.defaultBmcHeaders = header;
    }

    private Map<String, String> getPreLoginBmcRequestHeader() {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/json");
        header.put("Connection", "keep-alive");
        header.put("Accept-Encoding", "gzip, deflate, br");
        header.put("Accept", "*/*");
        return header;
    }

    @Generated
    protected BasicBmcSubTask(BasicBmcSubTaskBuilder<?, ?> b) {
        super(b);
        this.requestApi = ((BasicBmcSubTaskBuilder)b).requestApi;
        this.defaultBmcHeaders = ((BasicBmcSubTaskBuilder)b).defaultBmcHeaders;
        this.osDeployNode = ((BasicBmcSubTaskBuilder)b).osDeployNode;
        this.bmcIp = ((BasicBmcSubTaskBuilder)b).bmcIp;
        this.bmcSessionId = ((BasicBmcSubTaskBuilder)b).bmcSessionId;
    }

    @Generated
    public static abstract class BasicBmcSubTaskBuilder<C extends BasicBmcSubTask, B extends BasicBmcSubTaskBuilder<C, B>>
    extends BaseTask.BaseTaskBuilder<C, B> {
        @Generated
        private BmcHttpRequest requestApi;
        @Generated
        private Map<String, String> defaultBmcHeaders;
        @Generated
        private OsDeployNode osDeployNode;
        @Generated
        private String bmcIp;
        @Generated
        private String bmcSessionId;

        @Generated
        public B requestApi(BmcHttpRequest requestApi) {
            this.requestApi = requestApi;
            return (B)this.self();
        }

        @Generated
        public B defaultBmcHeaders(Map<String, String> defaultBmcHeaders) {
            this.defaultBmcHeaders = defaultBmcHeaders;
            return (B)this.self();
        }

        @Generated
        public B osDeployNode(OsDeployNode osDeployNode) {
            this.osDeployNode = osDeployNode;
            return (B)this.self();
        }

        @Generated
        public B bmcIp(String bmcIp) {
            this.bmcIp = bmcIp;
            return (B)this.self();
        }

        @Generated
        public B bmcSessionId(String bmcSessionId) {
            this.bmcSessionId = bmcSessionId;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "BasicBmcSubTask.BasicBmcSubTaskBuilder(super=" + super.toString() + ", requestApi=" + this.requestApi + ", defaultBmcHeaders=" + this.defaultBmcHeaders + ", osDeployNode=" + this.osDeployNode + ", bmcIp=" + this.bmcIp + ", bmcSessionId=" + this.bmcSessionId + ")";
        }
    }
}

