/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.os.service.task.subtask.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.huawei.yinglong.river.sitedeployment.dcs.os.bean.OsDeployNode;
import com.huawei.yinglong.river.sitedeployment.dcs.os.config.ConfigLoader;
import com.huawei.yinglong.river.sitedeployment.dcs.os.exception.DeployOsError;
import com.huawei.yinglong.river.sitedeployment.dcs.os.exception.DeployOsException;
import com.huawei.yinglong.river.sitedeployment.dcs.os.service.cdrom.CdRomMountServiceManager;
import com.huawei.yinglong.river.sitedeployment.dcs.os.service.task.subtask.BasicBmcSubTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ThreadUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Response;

public class BmcMountSubTask
extends BasicBmcSubTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BmcMountSubTask.class);
    public static final String NAME_KEY = "mount.os.to.ibmc";
    public static final String ATLAS_NAME_KEY = "atlas.mount.os.to.ibmc";
    private static final String BOOTSEQUNECE_JSON = "bootsequnece.json";

    public void execute() throws TaskException {
        this.umountCurrentExistsIsoImages(this.osDeployNode);
        if (!this.configBmcBootSequence()) {
            log.error("can't set {} boot sequence", (Object)this.bmcIp);
            throw new DeployOsException(DeployOsError.CONFIG_BOOT_SEQ);
        }
        if (!this.mountIsoImage(this.osDeployNode)) {
            log.error("can't mount {} iso image", (Object)this.bmcIp);
            throw new DeployOsException(DeployOsError.MOUNT_IMAGE);
        }
        ThreadUtils.threadSafeSleep((int)30, (TimeUnit)TimeUnit.SECONDS);
        log.info("wait 30s for mount iso at {} by ipmi...", (Object)this.bmcIp);
        if (!this.rebootDeviceToInstallOs(this.osDeployNode)) {
            log.error("can't reboot {}", (Object)this.bmcIp);
            throw new DeployOsException(DeployOsError.REBOOT_OS);
        }
    }

    private void umountCurrentExistsIsoImages(OsDeployNode osDeployNode) {
        if (!this.isAlreadyExistVirtualMedia(osDeployNode)) {
            log.info("node {} hasn't exist virtual media", (Object)this.bmcIp);
            return;
        }
        this.umountVirtualMedia(osDeployNode);
    }

    private void umountVirtualMedia(OsDeployNode osDeployNode) {
        Response umountResponse;
        HashMap<String, String> content = new HashMap<String, String>();
        content.put("VmmControlType", "Disconnect");
        try {
            umountResponse = this.requestApi.umountCurrentExistsMedia(osDeployNode.getSystemId(), this.defaultBmcHeaders, content).execute();
        }
        catch (IOException e) {
            log.error("{} can't send umount request", (Object)this.bmcIp);
            return;
        }
        if (!umountResponse.isSuccessful()) {
            log.error("umount node {} request failed", (Object)this.bmcIp);
            return;
        }
        if (Objects.equals(MapUtils.emptyIfNull((Map)((Map)umountResponse.body())).get("TaskState"), "Running")) {
            ThreadUtils.threadSafeSleep((int)5, (TimeUnit)TimeUnit.SECONDS);
        }
    }

    private boolean isAlreadyExistVirtualMedia(OsDeployNode osDeployNode) {
        Response currentVirtualMediaResponse;
        try {
            currentVirtualMediaResponse = this.requestApi.currentVirtualMedia(osDeployNode.getSystemId(), this.defaultBmcHeaders).execute();
        }
        catch (IOException exception) {
            log.error("query node {} current virtual media error", (Object)this.bmcIp, (Object)exception);
            return false;
        }
        if (!currentVirtualMediaResponse.isSuccessful()) {
            log.error("query current node {} exist virtual media error", (Object)this.bmcIp);
            return false;
        }
        boolean isVirtualMediaInserted = MapUtils.emptyIfNull((Map)((Map)currentVirtualMediaResponse.body())).getOrDefault("Inserted", false);
        log.info("current node {} insert media:{}", (Object)this.bmcIp, (Object)isVirtualMediaInserted);
        this.disableFloppyDrive(osDeployNode, (Response<Map<String, Object>>)currentVirtualMediaResponse);
        return isVirtualMediaInserted;
    }

    private void disableFloppyDrive(OsDeployNode osDeployNode, Response<Map<String, Object>> response) {
        if (!osDeployNode.isNeedModifyFloppy() || Objects.isNull(response.body())) {
            return;
        }
        JSONObject virtualMediaObject = new JSONObject((Map)response.body());
        boolean isFloppyDriveEnabled = virtualMediaObject.getJSONObject("Oem").getJSONObject("Huawei").getBooleanValue("FloppyDriveEnabled");
        osDeployNode.getBaseInfo().setFloppyOriginValue(isFloppyDriveEnabled);
        if (!isFloppyDriveEnabled) {
            log.info("FloppyDrive is disabled, no need to change.");
            return;
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("FloppyDriveEnabled", (Object)false);
        JSONObject huaweiObject = new JSONObject();
        huaweiObject.put("Huawei", (Object)jsonObject);
        JSONObject oemObject = new JSONObject();
        oemObject.put("Oem", (Object)huaweiObject);
        try {
            String eTag = response.headers().get("ETag");
            HashMap<String, String> headers = new HashMap<String, String>(this.defaultBmcHeaders);
            headers.put("If-Match", eTag);
            Response modifyFloppyResponse = this.requestApi.modifyFloppyDriveEnabled(osDeployNode.getSystemId(), headers, (Map<String, Object>)oemObject).execute();
            log.info("modify floppy result : {}.", (Object)modifyFloppyResponse.isSuccessful());
        }
        catch (IOException exception) {
            log.error("query node {} current virtual media error", (Object)this.bmcIp, (Object)exception);
        }
    }

    private boolean mountIsoImage(OsDeployNode osDeployNode) {
        CdRomMountServiceManager.getInstance().initCDRomMountService(osDeployNode);
        return CdRomMountServiceManager.getInstance().mount(osDeployNode);
    }

    private boolean rebootDeviceToInstallOs(OsDeployNode osDeployNode) {
        if (!this.powerOff(osDeployNode)) {
            log.error("power off {} failed", (Object)this.bmcIp);
        }
        log.info("wait 10s for power off");
        ThreadUtils.threadSafeSleep((int)10, (TimeUnit)TimeUnit.SECONDS);
        return this.powerOn(osDeployNode);
    }

    private boolean configBmcBootSequence() {
        return this.getBmcBootSequence(this.osDeployNode) && this.setBmcBootSequence(this.osDeployNode);
    }

    private boolean setBmcBootSequence(OsDeployNode osDeployNode) {
        Response currentBootSequence;
        Optional<String> configFileContent = ConfigLoader.getConfigFileContent(BOOTSEQUNECE_JSON);
        if (!configFileContent.isPresent()) {
            return false;
        }
        Map bootSettingMap = (Map)JSON.parseObject((String)configFileContent.get(), Map.class);
        try {
            currentBootSequence = this.requestApi.setBootSequence(osDeployNode.getSystemId(), bootSettingMap, this.defaultBmcHeaders).execute();
        }
        catch (IOException exception) {
            log.error("set boot sequence request failed", (Throwable)exception);
            return false;
        }
        if (!currentBootSequence.isSuccessful()) {
            return false;
        }
        Map currentBootInfo = (Map)((Map)currentBootSequence.body()).get("Boot");
        Map targetBootInfo = (Map)bootSettingMap.get("Boot");
        log.info("current target boot settings {} ", (Object)currentBootInfo);
        return targetBootInfo.entrySet().stream().allMatch(entry -> ((String)entry.getValue()).equals(currentBootInfo.get(entry.getKey())));
    }

    private boolean getBmcBootSequence(OsDeployNode osDeployNode) {
        Response bootSequenceResponse;
        try {
            bootSequenceResponse = this.requestApi.getSystemInfos(osDeployNode.getSystemId(), this.defaultBmcHeaders).execute();
        }
        catch (IOException exception) {
            log.error("get boot sequence failed,can't set header", (Throwable)exception);
            return false;
        }
        String match = bootSequenceResponse.headers().get("ETag");
        this.defaultBmcHeaders.put("If-Match", match);
        return true;
    }

    private boolean powerOff(OsDeployNode osDeployNode) {
        Response powerOffResponse;
        this.defaultBmcHeaders.remove("If-Match");
        HashMap<String, Object> powerMap = new HashMap<String, Object>();
        powerMap.put("ResetType", "ForceOff");
        try {
            powerOffResponse = this.requestApi.setPower(osDeployNode.getSystemId(), this.defaultBmcHeaders, powerMap).execute();
        }
        catch (IOException exception) {
            log.error("power off {} error", (Object)this.bmcIp, (Object)exception);
            return false;
        }
        return powerOffResponse.isSuccessful();
    }

    private boolean powerOn(OsDeployNode osDeployNode) {
        Response powerOnResponse;
        HashMap<String, Object> powerMap = new HashMap<String, Object>();
        powerMap.put("ResetType", "On");
        try {
            powerOnResponse = this.requestApi.setPower(osDeployNode.getSystemId(), this.defaultBmcHeaders, powerMap).execute();
        }
        catch (IOException exception) {
            log.error("power on {} failed", (Object)this.bmcIp, (Object)exception);
            return false;
        }
        return powerOnResponse.isSuccessful();
    }

    @Generated
    protected BmcMountSubTask(BmcMountSubTaskBuilder<?, ?> b) {
        super(b);
    }

    @Generated
    public static BmcMountSubTaskBuilder<?, ?> builder() {
        return new BmcMountSubTaskBuilderImpl();
    }

    @Generated
    private static final class BmcMountSubTaskBuilderImpl
    extends BmcMountSubTaskBuilder<BmcMountSubTask, BmcMountSubTaskBuilderImpl> {
        @Generated
        private BmcMountSubTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected BmcMountSubTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public BmcMountSubTask build() {
            return new BmcMountSubTask(this);
        }
    }

    @Generated
    public static abstract class BmcMountSubTaskBuilder<C extends BmcMountSubTask, B extends BmcMountSubTaskBuilder<C, B>>
    extends BasicBmcSubTask.BasicBmcSubTaskBuilder<C, B> {
        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "BmcMountSubTask.BmcMountSubTaskBuilder(super=" + super.toString() + ")";
        }
    }
}

