/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.os.service.task.subtask.impl;

import com.alibaba.fastjson.JSONObject;
import com.huawei.yinglong.river.sitedeployment.dcs.os.bean.OsDeployNode;
import com.huawei.yinglong.river.sitedeployment.dcs.os.exception.DeployOsError;
import com.huawei.yinglong.river.sitedeployment.dcs.os.exception.DeployOsException;
import com.huawei.yinglong.river.sitedeployment.dcs.os.service.cdrom.CdRomMountServiceManager;
import com.huawei.yinglong.river.sitedeployment.dcs.os.service.task.subtask.BasicBmcSubTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Response;

public class BmcUnmountSubTask
extends BasicBmcSubTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BmcUnmountSubTask.class);
    public static final String NAME_KEY = "unmount.os.to.ibmc";
    public static final String ATLAS_NAME_KEY = "atlas.unmount.os.to.ibmc";

    public void execute() throws TaskException {
        this.appendTaskDetail("start to umount device");
        if (!this.isAlreadyExistVirtualMedia()) {
            log.info("node {} hasn't exist virtual media", (Object)this.bmcIp);
            return;
        }
        boolean isUmount = CdRomMountServiceManager.getInstance().umount(this.osDeployNode);
        log.info("umount device {},result {}", (Object)this.bmcIp, (Object)isUmount);
        this.appendTaskDetail(StringUtils.formatTxt((String)"umount device result: %s", (Object[])new Object[]{isUmount}));
        if (this.osDeployNode.isNeedModifyFloppy()) {
            this.recoveryFloppyDrive(this.osDeployNode);
        }
        if (!isUmount) {
            throw new DeployOsException(DeployOsError.UNMOUNT_IMAGE);
        }
    }

    private boolean isAlreadyExistVirtualMedia() {
        Response currentVirtualMediaResponse;
        try {
            currentVirtualMediaResponse = this.requestApi.currentVirtualMedia(this.osDeployNode.getSystemId(), this.defaultBmcHeaders).execute();
        }
        catch (IOException exception) {
            log.error("query node {} current virtual media error", (Object)this.bmcIp, (Object)exception);
            return false;
        }
        if (!currentVirtualMediaResponse.isSuccessful()) {
            log.error("query current node {} exist virtual media error", (Object)this.bmcIp);
            return false;
        }
        boolean isVirtualMediaInserted = MapUtils.emptyIfNull((Map)((Map)currentVirtualMediaResponse.body())).getOrDefault("Inserted", false);
        log.info("current node {} insert media:{}", (Object)this.bmcIp, (Object)isVirtualMediaInserted);
        return isVirtualMediaInserted;
    }

    private void recoveryFloppyDrive(OsDeployNode osDeployNode) {
        Response currentVirtualMediaResponse;
        try {
            currentVirtualMediaResponse = this.requestApi.currentVirtualMedia(osDeployNode.getSystemId(), this.defaultBmcHeaders).execute();
        }
        catch (IOException exception) {
            log.error("query node {} current virtual media error", (Object)this.bmcIp, (Object)exception);
            return;
        }
        JSONObject virtualMediaObject = new JSONObject((Map)currentVirtualMediaResponse.body());
        boolean isFloppyDriveEnabled = virtualMediaObject.getJSONObject("Oem").getJSONObject("Huawei").getBooleanValue("FloppyDriveEnabled");
        if (isFloppyDriveEnabled == osDeployNode.getBaseInfo().isFloppyOriginValue()) {
            log.info("FloppyDrive is same as the origin one, no need to change.");
            return;
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("FloppyDriveEnabled", (Object)osDeployNode.getBaseInfo().isFloppyOriginValue());
        JSONObject huaweiObject = new JSONObject();
        huaweiObject.put("Huawei", (Object)jsonObject);
        JSONObject oemObject = new JSONObject();
        oemObject.put("Oem", (Object)huaweiObject);
        try {
            String eTag = currentVirtualMediaResponse.headers().get("ETag");
            HashMap<String, String> headers = new HashMap<String, String>(this.defaultBmcHeaders);
            headers.put("If-Match", eTag);
            Response modifyFloppyResponse = this.requestApi.modifyFloppyDriveEnabled(osDeployNode.getSystemId(), headers, (Map<String, Object>)oemObject).execute();
            log.info("modify floppy result : {}.", (Object)modifyFloppyResponse.isSuccessful());
        }
        catch (IOException exception) {
            log.error("query node {} current virtual media error", (Object)this.bmcIp, (Object)exception);
        }
    }

    @Generated
    protected BmcUnmountSubTask(BmcUnmountSubTaskBuilder<?, ?> b) {
        super(b);
    }

    @Generated
    public static BmcUnmountSubTaskBuilder<?, ?> builder() {
        return new BmcUnmountSubTaskBuilderImpl();
    }

    @Generated
    private static final class BmcUnmountSubTaskBuilderImpl
    extends BmcUnmountSubTaskBuilder<BmcUnmountSubTask, BmcUnmountSubTaskBuilderImpl> {
        @Generated
        private BmcUnmountSubTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected BmcUnmountSubTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public BmcUnmountSubTask build() {
            return new BmcUnmountSubTask(this);
        }
    }

    @Generated
    public static abstract class BmcUnmountSubTaskBuilder<C extends BmcUnmountSubTask, B extends BmcUnmountSubTaskBuilder<C, B>>
    extends BasicBmcSubTask.BasicBmcSubTaskBuilder<C, B> {
        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "BmcUnmountSubTask.BmcUnmountSubTaskBuilder(super=" + super.toString() + ")";
        }
    }
}

