/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.os.service.task.subtask.impl;

import com.huawei.yinglong.river.sitedeployment.dcs.os.bean.OsDeployNode;
import com.huawei.yinglong.river.sitedeployment.dcs.os.exception.DeployOsError;
import com.huawei.yinglong.river.sitedeployment.dcs.os.exception.DeployOsException;
import com.huawei.yinglong.river.sitedeployment.dcs.os.service.task.subtask.BasicBmcSubTask;
import com.huawei.yinglong.river.sitedeployment.dcs.os.utils.CommonRetryUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Response;

public class CheckServerPowerStatusSubTask
extends BasicBmcSubTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CheckServerPowerStatusSubTask.class);
    public static final String NAME_KEY = "server.power.check";

    public void execute() throws TaskException {
        this.appendTaskDetail("start to check power status");
        if (this.checkStorageConfigReady(this.osDeployNode)) {
            log.info("check storage config ready success");
            return;
        }
        if (!this.checkPowerStatusIsOn(this.osDeployNode) && !this.powerOn(this.osDeployNode)) {
            log.error("check server power status failed");
            throw new DeployOsException(DeployOsError.POWER_CHECK_FAILED);
        }
        log.info("The device is powered on properly. Check the disk status.");
        CommonRetryUtils.retry(() -> this.checkStorageConfigReady(this.osDeployNode), result -> result, 30, TimeUnit.MINUTES, 60);
        this.appendTaskDetail("finish to check power status");
    }

    private boolean checkStorageConfigReady(OsDeployNode osDeployNode) {
        try {
            Response response = this.requestApi.getSystemInfos(osDeployNode.getSystemId(), this.defaultBmcHeaders).execute();
            return response.isSuccessful() && Optional.ofNullable(response.body()).map(maps -> maps.get("Oem")).map(oem -> (Map)oem).map(oemMaps -> Objects.nonNull(oemMaps.get("Huawei")) ? oemMaps.get("Huawei") : oemMaps.get("OEM")).map(huawei -> (Map)huawei).map(huaweiMaps -> huaweiMaps.get("StorageConfigReady")).map(String::valueOf).filter(flag -> Arrays.asList("1.0", "4.0").contains(flag)).isPresent();
        }
        catch (IOException exception) {
            log.error("check storage config ready failed", (Throwable)exception);
            return false;
        }
    }

    private boolean checkPowerStatusIsOn(OsDeployNode osDeployNode) {
        try {
            Response response = this.requestApi.getSystemInfos(osDeployNode.getSystemId(), this.defaultBmcHeaders).execute();
            return response.isSuccessful() && response.body() != null && Objects.equals("On", ((Map)response.body()).get("PowerState"));
        }
        catch (IOException exception) {
            log.error("check server power status is on failed", (Throwable)exception);
            return false;
        }
    }

    private boolean powerOn(OsDeployNode osDeployNode) {
        HashMap<String, Object> powerMap = new HashMap<String, Object>();
        powerMap.put("ResetType", "On");
        try {
            return this.requestApi.setPower(osDeployNode.getSystemId(), this.defaultBmcHeaders, powerMap).execute().isSuccessful();
        }
        catch (IOException exception) {
            log.error("power on {} failed", (Object)this.bmcIp, (Object)exception);
            return false;
        }
    }

    @Generated
    protected CheckServerPowerStatusSubTask(CheckServerPowerStatusSubTaskBuilder<?, ?> b) {
        super(b);
    }

    @Generated
    public static CheckServerPowerStatusSubTaskBuilder<?, ?> builder() {
        return new CheckServerPowerStatusSubTaskBuilderImpl();
    }

    @Generated
    private static final class CheckServerPowerStatusSubTaskBuilderImpl
    extends CheckServerPowerStatusSubTaskBuilder<CheckServerPowerStatusSubTask, CheckServerPowerStatusSubTaskBuilderImpl> {
        @Generated
        private CheckServerPowerStatusSubTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected CheckServerPowerStatusSubTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public CheckServerPowerStatusSubTask build() {
            return new CheckServerPowerStatusSubTask(this);
        }
    }

    @Generated
    public static abstract class CheckServerPowerStatusSubTaskBuilder<C extends CheckServerPowerStatusSubTask, B extends CheckServerPowerStatusSubTaskBuilder<C, B>>
    extends BasicBmcSubTask.BasicBmcSubTaskBuilder<C, B> {
        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "CheckServerPowerStatusSubTask.CheckServerPowerStatusSubTaskBuilder(super=" + super.toString() + ")";
        }
    }
}

