/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.os.service.task.subtask.impl;

import com.huawei.yinglong.river.sitedeployment.dcs.consistency.ConsistencyPattern;
import com.huawei.yinglong.river.sitedeployment.dcs.constant.LineSeparator;
import com.huawei.yinglong.river.sitedeployment.dcs.os.bean.BaseOsTemplate;
import com.huawei.yinglong.river.sitedeployment.dcs.os.bean.OsDeployBaseInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.os.bean.OsDeployNode;
import com.huawei.yinglong.river.sitedeployment.dcs.os.bean.OsType;
import com.huawei.yinglong.river.sitedeployment.dcs.os.context.DeployOsContext;
import com.huawei.yinglong.river.sitedeployment.dcs.os.entity.params.A3000DiskInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.os.exception.DeployOsError;
import com.huawei.yinglong.river.sitedeployment.dcs.os.exception.DeployOsException;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FileContentOperateUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FileOperateUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FilePathValidatorUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.OsCmdUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ZipUtils;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.apache.commons.codec.digest.Crypt;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsoImagesSubTask
extends BaseTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IsoImagesSubTask.class);
    public static final String NAME_KEY = "update.iso.image";
    public static final String ATLAS_NAME_KEY = "atlas.update.iso.image";
    private OsDeployNode osDeployNode;

    public void execute() throws TaskException {
        this.appendTaskDetail("start to build iso images");
        if (!this.unzipIsoImageToCacheDirectory(this.osDeployNode.getImagesInfo().getIsoImagesPath(), this.osDeployNode.getImagesInfo().getLocalCacheImagesPath())) {
            log.error("unzip iso image error");
            throw new DeployOsException(DeployOsError.UPDATE_IMAGE_FAILED);
        }
        if (this.osDeployNode.getOsType() == OsType.CNA_ARM || OsType.isAtlasOs(this.osDeployNode.getOsType())) {
            this.removeBootDirectory(this.osDeployNode.getImagesInfo().getLocalCacheImagesPath());
        }
        if (OsType.isAtlasOs(this.osDeployNode.getOsType()) && !this.handleAtlasOsTemplateFiles()) {
            log.error("handle atlas os template file failed.");
            throw new DeployOsException(DeployOsError.HANDLE_OS_TEMPLATE_FILE_FAILED);
        }
        this.replaceIsoFiles(this.osDeployNode);
        if (this.osDeployNode.getOsType() == OsType.ATLAS_ARM) {
            this.addIsoFiles(this.osDeployNode);
        }
        this.renameIsoFiles(this.osDeployNode);
        this.replaceIsoConfigContentFiles(this.osDeployNode);
        this.replaceIsoRootPwdContentFiles(this.osDeployNode);
        this.packageIsoInCacheDir(this.osDeployNode);
        this.appendTaskDetail("success to build iso images");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean handleAtlasOsTemplateFiles() {
        String templateSrcPath;
        String isoImagePath = this.osDeployNode.getImagesInfo().getIsoImagesPath();
        List fileNames = FileOperateUtils.getSpecialFileNames((File)new File(isoImagePath), ConsistencyPattern::isA3000EContainerInstallerPackage);
        if (CollectionUtils.isEmpty((Collection)fileNames) || fileNames.size() > 1) {
            log.error("not find or more installer tar file, size : {}.", (Object)fileNames.size());
            return false;
        }
        String cacheTmpPath = FilePathValidatorUtils.joinChildPath((String[])new String[]{this.osDeployNode.getImagesInfo().getLocalCacheImagesPath(), "temp"});
        String installerFile = FilePathValidatorUtils.joinChildPath((String[])new String[]{isoImagePath, (String)fileNames.get(0)});
        if (!ZipUtils.decompressFileBy7Zip((String)DeployOsContext.ZIP_TOOL_DOR, (String)installerFile, (String)cacheTmpPath)) {
            log.error("unzip installer tar file failed, fileName : {}.", fileNames.get(0));
            return false;
        }
        fileNames = FileOperateUtils.getSpecialFileNames((File)new File(cacheTmpPath), fileName -> true);
        if (CollectionUtils.isEmpty((Collection)fileNames) || fileNames.size() > 1) {
            log.error("not find or more installer tar file, size : {}.", (Object)fileNames.size());
            return false;
        }
        installerFile = FilePathValidatorUtils.joinChildPath((String[])new String[]{cacheTmpPath, (String)fileNames.get(0)});
        if (!ZipUtils.decompressFileBy7Zip((String)DeployOsContext.ZIP_TOOL_DOR, (String)installerFile, (String)cacheTmpPath)) {
            log.warn("unzip tar file failed, fileName : {}.", fileNames.get(0));
        }
        if (!FilePathValidatorUtils.isValidExistPaths((String[])new String[]{templateSrcPath = FilePathValidatorUtils.joinChildPath((String[])new String[]{cacheTmpPath, "eContainerInstaller", "smartKit", "atlas-euler", "V2.0SP12", this.osDeployNode.getOsType() == OsType.ATLAS_X86 ? "x86" : "arm"})})) {
            log.error("not find template file in installer package, path: {}.", (Object)templateSrcPath);
            return false;
        }
        try {
            Class<IsoImagesSubTask> clazz = IsoImagesSubTask.class;
            synchronized (IsoImagesSubTask.class) {
                FileUtils.copyDirectory((File)new File(templateSrcPath), (File)new File(this.osDeployNode.getOsTemplate().getTemplatesPath()));
                // ** MonitorExit[var6_6] (shouldn't be in output)
            }
        }
        catch (IOException e) {
            log.error("copy template file failed.", (Throwable)e);
            return false;
        }
        {
            FileOperateUtils.deleteDirectory((String)cacheTmpPath);
            return true;
        }
    }

    private static boolean unzipAtlasTgzIsoPackageFile(String isoImagePath, String cacheDirectory) {
        List fileNames = FileOperateUtils.getSpecialFileNames((File)new File(isoImagePath), ConsistencyPattern::isA3000EulerOsPackage);
        if (CollectionUtils.isEmpty((Collection)fileNames) || fileNames.size() > 1) {
            log.error("not find or more atlas os tgz file, size : {}.", (Object)fileNames.size());
            return false;
        }
        String cacheTmpPath = FilePathValidatorUtils.joinChildPath((String[])new String[]{cacheDirectory, "temp"});
        String isoFile = FilePathValidatorUtils.joinChildPath((String[])new String[]{isoImagePath, (String)fileNames.get(0)});
        if (!ZipUtils.decompressFileBy7Zip((String)DeployOsContext.ZIP_TOOL_DOR, (String)isoFile, (String)cacheTmpPath)) {
            log.error("unzip tgz file failed, fileName : {}.", fileNames.get(0));
            return false;
        }
        fileNames = FileOperateUtils.getSpecialFileNames((File)new File(cacheTmpPath), fileName -> fileName.endsWith(".tar"));
        if (CollectionUtils.isEmpty((Collection)fileNames) || fileNames.size() > 1) {
            log.error("not find or more atlas os tar file, size : {}.", (Object)fileNames.size());
            return false;
        }
        isoFile = FilePathValidatorUtils.joinChildPath((String[])new String[]{cacheTmpPath, (String)fileNames.get(0)});
        if (!ZipUtils.decompressFileBy7Zip((String)DeployOsContext.ZIP_TOOL_DOR, (String)isoFile, (String)cacheTmpPath)) {
            log.error("unzip tar file failed, fileName : {}.", fileNames.get(0));
            return false;
        }
        fileNames = FileOperateUtils.getSpecialFileNames((File)new File(cacheTmpPath), fileName -> fileName.endsWith(".iso"));
        if (CollectionUtils.isEmpty((Collection)fileNames) || fileNames.size() > 1) {
            log.error("not find or more atlas os iso file, size : {}.", (Object)fileNames.size());
            return false;
        }
        isoFile = FilePathValidatorUtils.joinChildPath((String[])new String[]{cacheTmpPath, (String)fileNames.get(0)});
        if (!ZipUtils.decompressFileBy7Zip((String)DeployOsContext.ZIP_TOOL_DOR, (String)isoFile, (String)cacheDirectory)) {
            log.error("unzip iso file failed, fileName : {}.", fileNames.get(0));
            return false;
        }
        FileOperateUtils.deleteDirectory((String)cacheTmpPath);
        return true;
    }

    private void renameIsoFiles(OsDeployNode osDeployNode) {
        if (OsType.isAtlasOs(osDeployNode.getOsType())) {
            return;
        }
        BaseOsTemplate baseOsTemplate = osDeployNode.getOsTemplate();
        String cacheDir = osDeployNode.getImagesInfo().getLocalCacheImagesPath();
        baseOsTemplate.getRenameFiles().forEach((oldNameFile, replaceNameFile) -> this.renameSingleFile(FilePathValidatorUtils.joinChildPath((String[])new String[]{cacheDir, oldNameFile}), FilePathValidatorUtils.joinChildPath((String[])new String[]{cacheDir, replaceNameFile})));
    }

    private void renameSingleFile(String oldNameFile, String replaceNameFile) {
        if (StringUtils.isEmpty((CharSequence)oldNameFile) || StringUtils.isEmpty((CharSequence)replaceNameFile)) {
            log.error("rename file is null");
            return;
        }
        File oldFile = new File(oldNameFile);
        if (!oldFile.renameTo(new File(replaceNameFile))) {
            log.error("rename file error");
        }
    }

    private void packageIsoInCacheDir(OsDeployNode osDeployNode) {
        String cacheDir = osDeployNode.getImagesInfo().getLocalCacheImagesPath();
        String cmd = osDeployNode.getOsTemplate().getPackageCmd();
        String packageResult = OsCmdUtils.executeCmd((String)cmd, null, (File)new File(cacheDir), (int)30).toLowerCase();
        if (StringUtils.isEmpty((CharSequence)packageResult) || packageResult.contains("error")) {
            log.error("package ios images error");
        }
    }

    private boolean unzipIsoImageToCacheDirectory(String isoImagePath, String cacheDirectory) {
        if (!FilePathValidatorUtils.isValidExistPaths((String[])new String[]{isoImagePath}) || !FilePathValidatorUtils.isValidPaths((String[])new String[]{cacheDirectory})) {
            return false;
        }
        File cacheDir = new File(FilePathValidatorUtils.getSafePath((String)cacheDirectory).orElse(""));
        if (cacheDir.exists() && cacheDir.isFile()) {
            return false;
        }
        FileOperateUtils.deleteDirectory((String)FilePathValidatorUtils.getSafePath((File)cacheDir).orElse(""));
        if (OsType.isAtlasOs(this.osDeployNode.getOsType())) {
            return IsoImagesSubTask.unzipAtlasTgzIsoPackageFile(isoImagePath, cacheDirectory);
        }
        return ZipUtils.decompressFileBy7Zip((String)DeployOsContext.ZIP_TOOL_DOR, (String)isoImagePath, (String)cacheDirectory);
    }

    private void replaceIsoFiles(OsDeployNode osDeployNode) {
        BaseOsTemplate template = osDeployNode.getOsTemplate();
        String templateDir = template.getTemplatesPath();
        String cacheDir = osDeployNode.getImagesInfo().getLocalCacheImagesPath();
        template.getReplaceFiles().forEach((templateFile, replacedFiles) -> this.replaceFiles(FilePathValidatorUtils.joinChildPath((String[])new String[]{templateDir, templateFile}), cacheDir, (List<String>)replacedFiles));
    }

    private void replaceFiles(String templateFilePath, String cacheDir, List<String> replacedFiles) {
        for (String replacedFile : replacedFiles) {
            this.replaceSingleFile(templateFilePath, FilePathValidatorUtils.joinChildPath((String[])new String[]{cacheDir, replacedFile}));
        }
    }

    private void replaceSingleFile(String templateFilePath, String replacedFilePath) {
        File replacedFile = new File(replacedFilePath);
        if (!replacedFile.exists()) {
            log.error("{} not exists,do not need replace", (Object)replacedFile.getName());
            return;
        }
        if (!replacedFile.delete()) {
            log.error("delete file {} failed", (Object)replacedFile.getName());
        }
        try {
            FileUtils.copyFile((File)new File(templateFilePath), (File)replacedFile);
        }
        catch (IOException exception) {
            log.error("copy file error", (Throwable)exception);
        }
    }

    private void addIsoFiles(OsDeployNode osDeployNode) {
        BaseOsTemplate template = osDeployNode.getOsTemplate();
        String templateDir = template.getTemplatesPath();
        String cacheDir = osDeployNode.getImagesInfo().getLocalCacheImagesPath();
        template.getAddFiles().forEach((templateFile, replacedFiles) -> this.addFiles(FilePathValidatorUtils.joinChildPath((String[])new String[]{templateDir, templateFile}), cacheDir, (List<String>)replacedFiles));
    }

    private void addFiles(String templateFilePath, String cacheDir, List<String> replacedFiles) {
        for (String replacedFile : replacedFiles) {
            this.addSingleFile(templateFilePath, FilePathValidatorUtils.joinChildPath((String[])new String[]{cacheDir, replacedFile}));
        }
    }

    private void addSingleFile(String templateFilePath, String replacedFilePath) {
        File replacedFile = new File(replacedFilePath);
        if (replacedFile.exists()) {
            log.error("{} exists,do not need add", (Object)replacedFile.getName());
            return;
        }
        try {
            FileUtils.copyFile((File)new File(templateFilePath), (File)replacedFile);
        }
        catch (IOException exception) {
            log.error("copy file error", (Throwable)exception);
        }
    }

    private void replaceIsoConfigContentFiles(OsDeployNode osDeployNode) {
        if (OsType.isCnaOs(osDeployNode.getOsType())) {
            this.replaceSetupConfigFile(osDeployNode.getOsTemplate().getTemplatesPath(), osDeployNode.getImagesInfo().getLocalCacheImagesPath(), osDeployNode.getBaseInfo());
        }
        if (OsType.isAtlasOs(osDeployNode.getOsType())) {
            this.replaceAtlasSetupConfigFile(osDeployNode.getOsTemplate().getTemplatesPath(), osDeployNode.getImagesInfo().getLocalCacheImagesPath(), osDeployNode);
        }
    }

    private void replaceIsoRootPwdContentFiles(OsDeployNode osDeployNode) {
        if (OsType.isCnaOs(osDeployNode.getOsType())) {
            this.replacePwdConfigFile(osDeployNode.getOsTemplate().getTemplatesPath(), osDeployNode.getImagesInfo().getLocalCacheImagesPath(), osDeployNode.getBaseInfo());
        }
    }

    private void replacePwdConfigFile(String templateDir, String cacheDir, OsDeployBaseInfo baseInfo) {
        String pwdConfig = FilePathValidatorUtils.joinChildPath((String[])new String[]{cacheDir, "all", "cfg", "rootnew.conf"});
        File pwdFile = new File(pwdConfig);
        if (!pwdFile.delete()) {
            log.error("delete old pwd file error");
            return;
        }
        HashMap<String, String> replaceMap = new HashMap<String, String>();
        replaceMap.put("{pwd}", Crypt.crypt((String)baseInfo.getCnaPassword()));
        String templatePwd = FilePathValidatorUtils.joinChildPath((String[])new String[]{templateDir, "rootnew.conf"});
        if (!FileContentOperateUtils.replaceTextFileContent((String)templatePwd, (String)pwdConfig, replaceMap, (LineSeparator)LineSeparator.LINUX)) {
            log.error("replace cna config content failed");
        }
    }

    private void replaceSetupConfigFile(String templateDir, String cacheDir, OsDeployBaseInfo baseInfo) {
        String templateSetupConfig;
        String setupConfig = FilePathValidatorUtils.joinChildPath((String[])new String[]{cacheDir, "all", "cfg", "UVPOSsetup.conf"});
        File setupFile = new File(setupConfig);
        if (!setupFile.delete()) {
            log.error("delete cna config file error");
            return;
        }
        HashMap<String, String> replaceMap = new HashMap<String, String>();
        replaceMap.put("{hostname}", baseInfo.getHostName());
        replaceMap.put("{netcard_num}", baseInfo.getManageIpEth().substring(3));
        replaceMap.put("{netcard}", baseInfo.getManageIpEth());
        replaceMap.put("{ip}", baseInfo.getCnaIp());
        replaceMap.put("{netmask}", baseInfo.getCnaSubNetMask());
        replaceMap.put("{gateway}", baseInfo.getCnaGateway());
        replaceMap.put("{vlan}", baseInfo.getManageVlan());
        String string = templateSetupConfig = this.needConfigVlan(baseInfo.getManageVlan()) ? FilePathValidatorUtils.joinChildPath((String[])new String[]{templateDir, "UVPOSsetupVlan.conf"}) : FilePathValidatorUtils.joinChildPath((String[])new String[]{templateDir, "UVPOSsetup.conf"});
        if (!FileContentOperateUtils.replaceTextFileContent((String)templateSetupConfig, (String)setupConfig, replaceMap, (LineSeparator)LineSeparator.LINUX)) {
            log.error("replace cna config content failed");
        }
    }

    private void replaceAtlasSetupConfigFile(String templateDir, String cacheDir, OsDeployNode osDeployNode) {
        String setupConfig = FilePathValidatorUtils.joinChildPath((String[])new String[]{cacheDir, "ks", "ks.cfg"});
        File setupFile = new File(setupConfig);
        if (!setupFile.delete()) {
            log.error("delete atlas config file error");
            return;
        }
        HashMap<String, String> replaceMap = new HashMap<String, String>();
        OsDeployBaseInfo baseInfo = osDeployNode.getBaseInfo();
        replaceMap.put("{device}", baseInfo.getDevice());
        replaceMap.put("{ip}", baseInfo.getAtlasIp());
        replaceMap.put("{netmask}", baseInfo.getAtlasSubNetMask());
        replaceMap.put("{gateway}", baseInfo.getAtlasGateway());
        replaceMap.put("{password}", Crypt.crypt((String)baseInfo.getKsPassword()));
        replaceMap.put("{interconnectPwd}", baseInfo.getInterconnectPwd());
        replaceMap.put("{is_hard_raid_card}", String.valueOf(baseInfo.isHardRaid()));
        replaceMap.put("{hard_raid_driver_letter}", baseInfo.getHardRaidDeviceLetter());
        replaceMap.put("{soft_raid_driver_a}", baseInfo.getSoftRaidDeviceLetterA());
        replaceMap.put("{soft_raid_driver_b}", baseInfo.getSoftRaidDeviceLetterB());
        A3000DiskInfo diskInfo = osDeployNode.getDiskInfo();
        replaceMap.put("{size_total_euleros}", this.transferDiskSizeInKsCfg(diskInfo.getDiskSizeOfRoot() + diskInfo.getDiskSizeOfHome() + diskInfo.getDiskSizeOfRepo() + diskInfo.getDiskSizeOfLog() + 10));
        replaceMap.put("{size_root}", this.transferDiskSizeInKsCfg(diskInfo.getDiskSizeOfRoot()));
        replaceMap.put("{size_home}", this.transferDiskSizeInKsCfg(diskInfo.getDiskSizeOfHome()));
        replaceMap.put("{size_repo}", this.transferDiskSizeInKsCfg(diskInfo.getDiskSizeOfRepo()));
        replaceMap.put("{size_log}", this.transferDiskSizeInKsCfg(diskInfo.getDiskSizeOfLog()));
        replaceMap.put("{size_total_k8s}", this.transferDiskSizeInKsCfg(diskInfo.getDiskSizeOfK8s() + 5));
        replaceMap.put("{size_k8s}", this.transferDiskSizeInKsCfg(diskInfo.getDiskSizeOfK8s()));
        replaceMap.put("{size_total_k8s_data}", this.transferDiskSizeInKsCfg(diskInfo.getDiskSizeOfK8sDb() + diskInfo.getDiskSizeOfK8sCri() + 5));
        replaceMap.put("{size_k8s_db}", this.transferDiskSizeInKsCfg(diskInfo.getDiskSizeOfK8sDb()));
        replaceMap.put("{size_k8s_cri}", this.transferDiskSizeInKsCfg(diskInfo.getDiskSizeOfK8sCri()));
        String templateSetupConfig = FilePathValidatorUtils.joinChildPath((String[])new String[]{templateDir, "ks.cfg"});
        try {
            if (!FileContentOperateUtils.replaceTextFileContentByUtf((String)templateSetupConfig, (String)setupConfig, replaceMap, (LineSeparator)LineSeparator.LINUX)) {
                log.error("replace atlas config content failed");
            }
        }
        catch (IOException e) {
            log.error("replace atlas config content failed", (Throwable)e);
        }
    }

    private String transferDiskSizeInKsCfg(int size) {
        return String.valueOf((long)size * 1024L);
    }

    private void removeBootDirectory(String cacheDirectory) {
        String bootDir = FilePathValidatorUtils.joinChildPath((String[])new String[]{cacheDirectory, "[BOOT]"});
        if (!FileOperateUtils.deleteDirectory((String)bootDir)) {
            log.error("delete boot dir error");
        }
    }

    private boolean needConfigVlan(String vlanMange) {
        return StringUtils.isNotEmpty((CharSequence)vlanMange) && !"0".equals(vlanMange);
    }

    @Generated
    protected IsoImagesSubTask(IsoImagesSubTaskBuilder<?, ?> b) {
        super(b);
        this.osDeployNode = ((IsoImagesSubTaskBuilder)b).osDeployNode;
    }

    @Generated
    public static IsoImagesSubTaskBuilder<?, ?> builder() {
        return new IsoImagesSubTaskBuilderImpl();
    }

    @Generated
    private static final class IsoImagesSubTaskBuilderImpl
    extends IsoImagesSubTaskBuilder<IsoImagesSubTask, IsoImagesSubTaskBuilderImpl> {
        @Generated
        private IsoImagesSubTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected IsoImagesSubTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public IsoImagesSubTask build() {
            return new IsoImagesSubTask(this);
        }
    }

    @Generated
    public static abstract class IsoImagesSubTaskBuilder<C extends IsoImagesSubTask, B extends IsoImagesSubTaskBuilder<C, B>>
    extends BaseTask.BaseTaskBuilder<C, B> {
        @Generated
        private OsDeployNode osDeployNode;

        @Generated
        public B osDeployNode(OsDeployNode osDeployNode) {
            this.osDeployNode = osDeployNode;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "IsoImagesSubTask.IsoImagesSubTaskBuilder(super=" + super.toString() + ", osDeployNode=" + this.osDeployNode + ")";
        }
    }
}

