/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.os.service.task.subtask.impl;

import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.SshException;
import com.huawei.yinglong.river.sitedeployment.dcs.os.config.DeployOsConfigUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.os.exception.DeployOsError;
import com.huawei.yinglong.river.sitedeployment.dcs.os.exception.DeployOsException;
import com.huawei.yinglong.river.sitedeployment.dcs.os.service.task.subtask.BasicBmcSubTask;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshConnInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshConnService;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshManager;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshShellService;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ThreadUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.collections4.MapUtils;
import org.apache.sshd.client.session.ClientSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Response;

public class MonitAtlasIsoSetupSubTask
extends BasicBmcSubTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MonitAtlasIsoSetupSubTask.class);
    public static final String NAME_KEY = "atlas.monit.iso.setup";

    public void execute() throws TaskException {
        this.appendTaskDetail("installing iso, now waiting");
        int waitRebootMinusTime = DeployOsConfigUtils.getRebootA3000WaitTime();
        log.info("current {} wait reboot minus time is {}", (Object)this.osDeployNode.getBaseInfo().getBmcIp(), (Object)waitRebootMinusTime);
        long startTime = System.currentTimeMillis();
        log.info("sleep 15 min wait for reboot");
        int checkCnt = 0;
        while (true) {
            log.info("check os install status : {}.", (Object)checkCnt);
            if (!this.checkVvmConnectedIgnoreFailed()) {
                this.appendTaskDetail("check vvm connect status failed.");
                throw new DeployOsException(DeployOsError.INSTALL_VVM_DISCONNECT);
            }
            if (++checkCnt > 15 && this.checkOsInstalled()) {
                return;
            }
            long waitTime = System.currentTimeMillis() - startTime;
            if (TimeUnit.MILLISECONDS.toMinutes(waitTime) > (long)waitRebootMinusTime) {
                this.appendTaskDetail(StringUtils.formatTxt((String)"waiting reboot timeout.", (Object[])new Object[0]));
                throw new DeployOsException(DeployOsError.INSTALL_TIMEOUT);
            }
            ThreadUtils.threadSafeSleep((int)60, (TimeUnit)TimeUnit.SECONDS);
        }
    }

    private boolean checkVvmConnectedIgnoreFailed() {
        Response currentVirtualMediaResponse;
        try {
            currentVirtualMediaResponse = this.requestApi.currentVirtualMedia(this.osDeployNode.getSystemId(), this.defaultBmcHeaders).execute();
        }
        catch (IOException exception) {
            log.error("query node {} current virtual media error, ignore", (Object)this.bmcIp, (Object)exception);
            return true;
        }
        if (!currentVirtualMediaResponse.isSuccessful()) {
            log.error("query current node {} exist virtual media error, ignore", (Object)this.bmcIp);
            return true;
        }
        boolean isVirtualMediaInserted = MapUtils.emptyIfNull((Map)((Map)currentVirtualMediaResponse.body())).getOrDefault("Inserted", true);
        log.info("current node {} insert media:{}", (Object)this.bmcIp, (Object)isVirtualMediaInserted);
        return isVirtualMediaInserted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkOsInstalled() {
        boolean bl;
        SshShellService sshShellService;
        ClientSession session;
        block6: {
            session = null;
            sshShellService = null;
            log.info("start to create the ssh shell service of {}.", (Object)this.osDeployNode.getBaseInfo().getBmcIp());
            session = SshManager.getSession((SshConnInfo)this.getSshConnInfo());
            sshShellService = SshManager.createSshShellService((ClientSession)session);
            sshShellService.connect();
            log.info("start to open sol");
            String sshResult = sshShellService.execCommandWithTimeout("ipmcset -t sol -d activate -v 1 1", 5, false);
            log.info("open sol result: {}", (Object)sshResult);
            if (StringUtils.containIgnoreCase((String)sshResult, (String[])new String[]{"Current SOL session is in private mode"})) {
                sshResult = sshShellService.execCommandWithTimeout("ipmcset -t sol -d deactivate -v 1", 5, false);
                log.info("close sol result : {}.", (Object)sshResult);
                ThreadUtils.threadSafeSleep((int)5, (TimeUnit)TimeUnit.SECONDS);
                sshResult = sshShellService.execCommandWithTimeout("ipmcset -t sol -d activate -v 1 1", 5, false);
                log.info("retry open sol result: {}", (Object)sshResult);
            }
            ThreadUtils.threadSafeSleep((int)5, (TimeUnit)TimeUnit.SECONDS);
            if (!StringUtils.containIgnoreCase((String)sshResult, (String[])new String[]{"Connect SOL successfully"})) break block6;
            log.info("start to input enter");
            sshResult = sshShellService.execCommandWithTimeout("\n", 10, false);
            log.info("enter result: {}", (Object)sshResult);
            boolean bl2 = StringUtils.containIgnoreCase((String)sshResult, (String[])new String[]{"login:"});
            SshManager.releaseConnService((SshConnService)sshShellService);
            SshManager.releaseSession((ClientSession)session);
            return bl2;
        }
        try {
            bl = false;
        }
        catch (SshException e) {
            boolean bl3;
            try {
                log.error("create bmc ssh error.", (Throwable)e);
                bl3 = false;
            }
            catch (Throwable throwable) {
                SshManager.releaseConnService(sshShellService);
                SshManager.releaseSession(session);
                throw throwable;
            }
            SshManager.releaseConnService(sshShellService);
            SshManager.releaseSession((ClientSession)session);
            return bl3;
        }
        SshManager.releaseConnService((SshConnService)sshShellService);
        SshManager.releaseSession((ClientSession)session);
        return bl;
    }

    private SshConnInfo getSshConnInfo() {
        String bmcIp = this.osDeployNode.getBaseInfo().getBmcIp();
        String bmcUser = this.osDeployNode.getBaseInfo().getBmcUser();
        String bmcPassword = this.osDeployNode.getBaseInfo().getBmcPassword();
        return SshConnInfo.builder().hostName(bmcIp).userName(bmcUser).userPwd(bmcPassword).build();
    }

    @Generated
    protected MonitAtlasIsoSetupSubTask(MonitAtlasIsoSetupSubTaskBuilder<?, ?> b) {
        super(b);
    }

    @Generated
    public static MonitAtlasIsoSetupSubTaskBuilder<?, ?> builder() {
        return new MonitAtlasIsoSetupSubTaskBuilderImpl();
    }

    @Generated
    private static final class MonitAtlasIsoSetupSubTaskBuilderImpl
    extends MonitAtlasIsoSetupSubTaskBuilder<MonitAtlasIsoSetupSubTask, MonitAtlasIsoSetupSubTaskBuilderImpl> {
        @Generated
        private MonitAtlasIsoSetupSubTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected MonitAtlasIsoSetupSubTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public MonitAtlasIsoSetupSubTask build() {
            return new MonitAtlasIsoSetupSubTask(this);
        }
    }

    @Generated
    public static abstract class MonitAtlasIsoSetupSubTaskBuilder<C extends MonitAtlasIsoSetupSubTask, B extends MonitAtlasIsoSetupSubTaskBuilder<C, B>>
    extends BasicBmcSubTask.BasicBmcSubTaskBuilder<C, B> {
        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "MonitAtlasIsoSetupSubTask.MonitAtlasIsoSetupSubTaskBuilder(super=" + super.toString() + ")";
        }
    }
}

