/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.os.service.task.subtask.impl;

import com.huawei.yinglong.river.sitedeployment.dcs.os.bean.OsDeployNode;
import com.huawei.yinglong.river.sitedeployment.dcs.os.bean.OsType;
import com.huawei.yinglong.river.sitedeployment.dcs.os.config.DeployOsConfigUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.os.exception.DeployOsError;
import com.huawei.yinglong.river.sitedeployment.dcs.os.exception.DeployOsException;
import com.huawei.yinglong.river.sitedeployment.dcs.os.utils.SshIpCheckUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.IpUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ThreadUtils;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitIsoSetupSubTask
extends BaseTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MonitIsoSetupSubTask.class);
    public static final String NAME_KEY = "monit.iso.setup";
    private OsDeployNode osDeployNode;

    public void execute() throws TaskException {
        this.appendTaskDetail("installing iso, now waiting");
        int waitRebootMinusTime = DeployOsConfigUtils.getRebootWaitTime();
        log.info("current {} wait reboot minus time is {}", (Object)this.osDeployNode.getBaseInfo().getBmcIp(), (Object)waitRebootMinusTime);
        long startTime = System.currentTimeMillis();
        while (true) {
            String ip = OsType.isAtlasOs(this.osDeployNode.getOsType()) ? this.osDeployNode.getBaseInfo().getAtlasIp() : this.osDeployNode.getBaseInfo().getCnaIp();
            boolean isReachableIp = IpUtils.isReachable((String)ip);
            log.info("query {} status {}", (Object)ip, (Object)isReachableIp);
            if (isReachableIp) {
                log.info("can reach current id {} ,wait 3 minus to wait os startup", (Object)ip);
                ThreadUtils.threadSafeSleep((int)3, (TimeUnit)TimeUnit.MINUTES);
                if (OsType.isAtlasOs(this.osDeployNode.getOsType())) {
                    String interconnectPwd = this.osDeployNode.getBaseInfo().getInterconnectPwd();
                    SshIpCheckUtils.checkIpSshConnected(ip, "manageromm", interconnectPwd, arg_0 -> ((MonitIsoSetupSubTask)this).appendTaskDetail(arg_0));
                }
                return;
            }
            long waitTime = System.currentTimeMillis() - startTime;
            if (TimeUnit.MILLISECONDS.toMinutes(waitTime) > (long)waitRebootMinusTime) {
                this.appendTaskDetail(StringUtils.formatTxt((String)"waiting reboot timeout.", (Object[])new Object[0]));
                throw new DeployOsException(DeployOsError.INSTALL_TIMEOUT);
            }
            ThreadUtils.threadSafeSleep((int)5, (TimeUnit)TimeUnit.SECONDS);
        }
    }

    @Generated
    protected MonitIsoSetupSubTask(MonitIsoSetupSubTaskBuilder<?, ?> b) {
        super(b);
        this.osDeployNode = ((MonitIsoSetupSubTaskBuilder)b).osDeployNode;
    }

    @Generated
    public static MonitIsoSetupSubTaskBuilder<?, ?> builder() {
        return new MonitIsoSetupSubTaskBuilderImpl();
    }

    @Generated
    private static final class MonitIsoSetupSubTaskBuilderImpl
    extends MonitIsoSetupSubTaskBuilder<MonitIsoSetupSubTask, MonitIsoSetupSubTaskBuilderImpl> {
        @Generated
        private MonitIsoSetupSubTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected MonitIsoSetupSubTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public MonitIsoSetupSubTask build() {
            return new MonitIsoSetupSubTask(this);
        }
    }

    @Generated
    public static abstract class MonitIsoSetupSubTaskBuilder<C extends MonitIsoSetupSubTask, B extends MonitIsoSetupSubTaskBuilder<C, B>>
    extends BaseTask.BaseTaskBuilder<C, B> {
        @Generated
        private OsDeployNode osDeployNode;

        @Generated
        public B osDeployNode(OsDeployNode osDeployNode) {
            this.osDeployNode = osDeployNode;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "MonitIsoSetupSubTask.MonitIsoSetupSubTaskBuilder(super=" + super.toString() + ", osDeployNode=" + this.osDeployNode + ")";
        }
    }
}

