/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.os.service.task.subtask.impl;

import com.huawei.yinglong.river.sitedeployment.dcs.os.exception.DeployOsError;
import com.huawei.yinglong.river.sitedeployment.dcs.os.exception.DeployOsException;
import com.huawei.yinglong.river.sitedeployment.dcs.os.service.task.subtask.BasicBmcSubTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Response;

public class ServerUserTask
extends BasicBmcSubTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServerUserTask.class);
    public static final String NAME_KEY = "server.user.add";
    private static final String USER_NAME = "fc2mgmt";

    public void execute() throws TaskException {
        Map<String, String> users = this.queryUsers();
        String userId = users.get(USER_NAME);
        if (StringUtils.isNotEmpty((CharSequence)userId)) {
            log.warn("The username: {} and ID: {} already exist.", (Object)USER_NAME, (Object)userId);
            this.appendTaskDetail(StringUtils.formatTxt((String)"The current user %s already exists. You do not need to add this user.", (Object[])new Object[]{USER_NAME}));
            return;
        }
        userId = String.valueOf(users.values().stream().map(Integer::parseInt).max(Integer::compareTo).orElse(2) + 1);
        log.info("find max user id : {}.", (Object)userId);
        if (!this.addUser(userId, this.osDeployNode.getBaseInfo().getFc2mgmtPwd())) {
            this.appendTaskDetail(StringUtils.formatTxt((String)"Failed to add user %s.", (Object[])new Object[]{USER_NAME}));
            throw new DeployOsException(DeployOsError.ADD_USER_FAILED);
        }
        this.appendTaskDetail(StringUtils.formatTxt((String)"Succeeded in adding user %s.", (Object[])new Object[]{USER_NAME}));
    }

    private Map<String, String> queryUsers() {
        try {
            Response response = this.requestApi.queryUsers(this.defaultBmcHeaders).execute();
            if (!response.isSuccessful() || MapUtils.isEmpty((Map)((Map)response.body()))) {
                return Collections.emptyMap();
            }
            Object members = ((Map)response.body()).get("Members");
            if (!(members instanceof List)) {
                return Collections.emptyMap();
            }
            HashMap<String, String> resultMaps = new HashMap<String, String>();
            List memberList = (List)members;
            memberList.forEach(map -> resultMaps.put(String.valueOf(map.get("UserName")), String.valueOf(map.get("Id"))));
            log.info("query all users, {}.", resultMaps);
            return resultMaps;
        }
        catch (IOException e) {
            log.error("query all user failed.", (Throwable)e);
            return Collections.emptyMap();
        }
    }

    private boolean addUser(String userId, String userPwd) {
        HashMap<String, String> maps = new HashMap<String, String>();
        maps.put("Id", userId);
        maps.put("UserName", USER_NAME);
        maps.put("Password", userPwd);
        maps.put("RoleId", "Administrator");
        try {
            log.info("add ibmc user, username : {}, id : {}.", (Object)USER_NAME, (Object)userId);
            return this.requestApi.createUser(this.defaultBmcHeaders, maps).execute().isSuccessful();
        }
        catch (IOException e) {
            log.error("add user failed.", (Throwable)e);
            return false;
        }
    }

    @Generated
    protected ServerUserTask(ServerUserTaskBuilder<?, ?> b) {
        super(b);
    }

    @Generated
    public static ServerUserTaskBuilder<?, ?> builder() {
        return new ServerUserTaskBuilderImpl();
    }

    @Generated
    private static final class ServerUserTaskBuilderImpl
    extends ServerUserTaskBuilder<ServerUserTask, ServerUserTaskBuilderImpl> {
        @Generated
        private ServerUserTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected ServerUserTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ServerUserTask build() {
            return new ServerUserTask(this);
        }
    }

    @Generated
    public static abstract class ServerUserTaskBuilder<C extends ServerUserTask, B extends ServerUserTaskBuilder<C, B>>
    extends BasicBmcSubTask.BasicBmcSubTaskBuilder<C, B> {
        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "ServerUserTask.ServerUserTaskBuilder(super=" + super.toString() + ")";
        }
    }
}

