/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.os.service.task.subtask.impl;

import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.SshException;
import com.huawei.yinglong.river.sitedeployment.dcs.os.bean.OsDeployBaseInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.os.bean.OsDeployNode;
import com.huawei.yinglong.river.sitedeployment.dcs.os.exception.DeployOsError;
import com.huawei.yinglong.river.sitedeployment.dcs.os.exception.DeployOsException;
import com.huawei.yinglong.river.sitedeployment.dcs.os.utils.SshIpCheckUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshConnInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshConnService;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshManager;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshShellService;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ThreadUtils;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.sshd.client.session.ClientSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimbaosInitSubTask
extends BaseTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SimbaosInitSubTask.class);
    public static final String NAME_KEY = "simbaos.init.name";
    private OsDeployNode osDeployNode;

    public void execute() throws TaskException {
        OsDeployBaseInfo baseInfo = this.osDeployNode.getBaseInfo();
        ClientSession session = null;
        SshShellService shellService = null;
        try {
            session = SshManager.getSession((SshConnInfo)SshConnInfo.builder().hostName(baseInfo.getBmcIp()).userName(baseInfo.getBmcUser()).userPwd(baseInfo.getBmcPassword()).build());
            shellService = SshManager.createSshShellService((ClientSession)session);
            shellService.connect();
            log.info("create ssh shell connection successfully, bmcIp={}.", (Object)baseInfo.getBmcIp());
            if (!this.changeBmcToOsEnvironment(shellService)) {
                throw new DeployOsException(DeployOsError.BMC_TO_OS_FAILED);
            }
            if (!this.loginOsSystem(shellService)) {
                throw new DeployOsException(DeployOsError.LOGIN_OS_FAILED);
            }
            this.setSystemTimeByLocalTime(shellService);
            this.executeSimbOsInit(shellService);
            ThreadUtils.threadSafeSleep((int)2, (TimeUnit)TimeUnit.MINUTES);
            for (int count = 0; count < 3; ++count) {
                log.info("simbaOS try connect count: {}", (Object)count);
                SshIpCheckUtils.checkIpSshConnected(baseInfo.getAtlasIp(), "manageromm", baseInfo.getInterconnectPwd(), arg_0 -> ((SimbaosInitSubTask)this).appendTaskDetail(arg_0));
                ThreadUtils.threadSafeSleep((int)1, (TimeUnit)TimeUnit.MINUTES);
            }
            if (!this.checkOsHasKadminAccount(baseInfo)) {
                throw new DeployOsException(DeployOsError.SIMBAOS_INIT_FAILED);
            }
        }
        catch (SshException e) {
            try {
                log.error("ssh connect failed.", (Throwable)e);
                throw new DeployOsException(DeployOsError.CONNECT_IBMC);
            }
            catch (Throwable throwable) {
                SshManager.releaseConnService(shellService);
                SshManager.releaseSession(session);
                throw throwable;
            }
        }
        SshManager.releaseConnService((SshConnService)shellService);
        SshManager.releaseSession((ClientSession)session);
    }

    boolean checkOsHasKadminAccount(OsDeployBaseInfo baseInfo) {
        boolean bl;
        SshShellService shellService = null;
        ClientSession clientSession = null;
        try {
            clientSession = SshManager.getSession((SshConnInfo)SshConnInfo.builder().hostName(baseInfo.getAtlasIp()).userName("manageromm").userPwd(baseInfo.getInterconnectPwd()).build());
            shellService = SshManager.createSshShellService((ClientSession)clientSession);
            shellService.connect();
            log.info("create ssh shell connection successfully, os={}.", (Object)baseInfo.getAtlasIp());
            String cmd = "id kadmin";
            String result = shellService.execCommand(cmd);
            log.info("execute id cmd [{}], result:{}.", (Object)cmd, (Object)result);
            bl = !StringUtils.containIgnoreCase((String)result, (String[])new String[]{"no such user"});
        }
        catch (SshException e) {
            try {
                log.error("ssh connect os failed.", (Throwable)e);
                throw new DeployOsException(DeployOsError.CONNECT_OS);
            }
            catch (Throwable throwable) {
                SshManager.releaseConnService(shellService);
                SshManager.releaseSession(clientSession);
                throw throwable;
            }
        }
        SshManager.releaseConnService((SshConnService)shellService);
        SshManager.releaseSession((ClientSession)clientSession);
        return bl;
    }

    private void executeTimeCommand(SshShellService shellService, String checkerCmd, String modifyCmd) throws SshException {
        String result = shellService.execCommand(checkerCmd);
        log.info("execute time cmd before [{}], result:{}.", (Object)checkerCmd, (Object)result);
        result = shellService.execCommand(modifyCmd);
        log.info("execute time cmd [{}], result:{}.", (Object)modifyCmd, (Object)result);
        result = shellService.execCommand(checkerCmd);
        log.info("execute time cmd after [{}], result:{}.", (Object)checkerCmd, (Object)result);
    }

    void setSystemTimeByLocalTime(SshShellService shellService) {
        try {
            String nowTime = StringUtils.formatTimeText((String)"yyyy-MM-dd HH:mm:ss");
            log.info("current local time is {}.", (Object)nowTime);
            this.executeTimeCommand(shellService, "date", StringUtils.formatTxt((String)"date -s \"%s\"", (Object[])new Object[]{nowTime}));
            this.executeTimeCommand(shellService, "hwclock", "hwclock -w");
            log.info("set system time success.");
        }
        catch (SshException e) {
            log.error("set system time failed.", (Throwable)e);
        }
    }

    private boolean changeBmcToOsEnvironment(SshShellService shellService) throws SshException {
        String result = shellService.execCommand("ipmcset -t sol -d activate -v 1 1");
        log.info("execute [{}], result:{}.", (Object)"ipmcset -t sol -d activate -v 1 1", (Object)result);
        this.appendTaskDetail(result);
        if (StringUtils.containIgnoreCase((String)result, (String[])new String[]{"Current SOL session is in private mode"})) {
            result = shellService.execCommand("ipmcset -t sol -d deactivate -v 1");
            log.info("execute [{}], result:{}.", (Object)"ipmcset -t sol -d deactivate -v 1", (Object)result);
            this.appendTaskDetail(result);
            result = shellService.execCommand("ipmcset -t sol -d activate -v 1 1");
            log.info("execute [{}], result:{}.", (Object)"ipmcset -t sol -d activate -v 1 1", (Object)result);
            this.appendTaskDetail(result);
        }
        return StringUtils.containIgnoreCase((String)result, (String[])new String[]{"Connect SOL successfully"});
    }

    private boolean loginOsSystem(SshShellService shellService) throws SshException {
        ThreadUtils.threadSafeSleep((int)2, (TimeUnit)TimeUnit.SECONDS);
        String cmd = "";
        String result = shellService.execCommandWithTimeout(cmd, (int)TimeUnit.MINUTES.toSeconds(1L));
        this.appendTaskDetail(result);
        log.info("execute [ENTER], result = {}.", (Object)result);
        if (StringUtils.containIgnoreCase((String)result, (String[])new String[]{"login:"})) {
            result = shellService.execCommand("root");
            this.appendTaskDetail(result);
            log.info("execute [root], result = {}.", (Object)result);
        }
        if (StringUtils.containIgnoreCase((String)result, (String[])new String[]{"Password:", "Please input new password:"})) {
            String rootPwd = this.osDeployNode.getBaseInfo().getKsPassword();
            result = shellService.execCommand(rootPwd);
            String logResult = StringUtils.replaceSensitiveTexts((String)result, (String)result);
            this.appendTaskDetail(logResult);
            log.info("execute [root text], result = {}.", (Object)logResult);
        }
        return StringUtils.containIgnoreCase((String)result, (String[])new String[]{"Last login:", "#"});
    }

    private void executeSimbOsInit(SshShellService shellService) {
        try {
            String cmd = "sh /opt/dsware/container/simbaos_init.sh -q";
            shellService.execCommandWithoutReturn(cmd);
            this.appendTaskDetail(cmd);
        }
        catch (SshException e) {
            log.warn("simba os init reboot os.", (Throwable)e);
        }
    }

    @Generated
    protected SimbaosInitSubTask(SimbaosInitSubTaskBuilder<?, ?> b) {
        super(b);
        this.osDeployNode = ((SimbaosInitSubTaskBuilder)b).osDeployNode;
    }

    @Generated
    public static SimbaosInitSubTaskBuilder<?, ?> builder() {
        return new SimbaosInitSubTaskBuilderImpl();
    }

    @Generated
    private static final class SimbaosInitSubTaskBuilderImpl
    extends SimbaosInitSubTaskBuilder<SimbaosInitSubTask, SimbaosInitSubTaskBuilderImpl> {
        @Generated
        private SimbaosInitSubTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected SimbaosInitSubTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public SimbaosInitSubTask build() {
            return new SimbaosInitSubTask(this);
        }
    }

    @Generated
    public static abstract class SimbaosInitSubTaskBuilder<C extends SimbaosInitSubTask, B extends SimbaosInitSubTaskBuilder<C, B>>
    extends BaseTask.BaseTaskBuilder<C, B> {
        @Generated
        private OsDeployNode osDeployNode;

        @Generated
        public B osDeployNode(OsDeployNode osDeployNode) {
            this.osDeployNode = osDeployNode;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "SimbaosInitSubTask.SimbaosInitSubTaskBuilder(super=" + super.toString() + ", osDeployNode=" + this.osDeployNode + ")";
        }
    }
}

