/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.os.service.task.subtask.network;

import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.SshException;
import com.huawei.yinglong.river.sitedeployment.dcs.os.bean.OsDeployNode;
import com.huawei.yinglong.river.sitedeployment.dcs.os.exception.DeployOsError;
import com.huawei.yinglong.river.sitedeployment.dcs.os.exception.DeployOsException;
import com.huawei.yinglong.river.sitedeployment.dcs.os.fit.ServiceDeployAssembler;
import com.huawei.yinglong.river.sitedeployment.dcs.os.network.bean.NetworkNodeInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.os.service.task.subtask.network.impl.ConfigStrategy;
import com.huawei.yinglong.river.sitedeployment.dcs.os.service.task.subtask.network.impl.ConfigStrategyManager;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import java.util.Collections;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StrategyConfigTask
extends BaseTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StrategyConfigTask.class);
    public static final String NAME_KEY = "config.strategy";
    private OsDeployNode osDeployNode;
    private ConfigStrategyManager manager;

    public void beforeExecute() {
        super.beforeExecute();
        this.manager = new ConfigStrategyManager();
        this.manager.setBmcIps(Collections.singleton(this.osDeployNode.getBaseInfo().getBmcIp()));
        this.manager.initConfigStrategies(this.osDeployNode.getNetworkPlaneInfoList());
    }

    public void execute() throws TaskException {
        NetworkNodeInfo networkNodeInfo = ServiceDeployAssembler.parseToNetworkNodeInfo(this.osDeployNode);
        boolean isInitialed = false;
        for (ConfigStrategy configStrategy : this.manager.getConfigStrategyList()) {
            configStrategy.setNetworkNodeInfo(networkNodeInfo);
            configStrategy.setDetailHandler(arg_0 -> ((StrategyConfigTask)this).appendTaskDetail(arg_0));
            try {
                if (!isInitialed) {
                    configStrategy.initSshShellService(networkNodeInfo);
                    configStrategy.restoreInitialConfiguration();
                    isInitialed = true;
                }
                configStrategy.execute();
            }
            catch (SshException e) {
                log.error("ssh connection error,", (Throwable)e);
                throw new DeployOsException(DeployOsError.SSH_EXECUTE_FAILED);
            }
            finally {
                configStrategy.releaseConnection(networkNodeInfo.getBmcIp());
            }
        }
    }

    @Generated
    protected StrategyConfigTask(StrategyConfigTaskBuilder<?, ?> b) {
        super(b);
        this.osDeployNode = ((StrategyConfigTaskBuilder)b).osDeployNode;
        this.manager = ((StrategyConfigTaskBuilder)b).manager;
    }

    @Generated
    public static StrategyConfigTaskBuilder<?, ?> builder() {
        return new StrategyConfigTaskBuilderImpl();
    }

    @Generated
    private static final class StrategyConfigTaskBuilderImpl
    extends StrategyConfigTaskBuilder<StrategyConfigTask, StrategyConfigTaskBuilderImpl> {
        @Generated
        private StrategyConfigTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected StrategyConfigTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public StrategyConfigTask build() {
            return new StrategyConfigTask(this);
        }
    }

    @Generated
    public static abstract class StrategyConfigTaskBuilder<C extends StrategyConfigTask, B extends StrategyConfigTaskBuilder<C, B>>
    extends BaseTask.BaseTaskBuilder<C, B> {
        @Generated
        private OsDeployNode osDeployNode;
        @Generated
        private ConfigStrategyManager manager;

        @Generated
        public B osDeployNode(OsDeployNode osDeployNode) {
            this.osDeployNode = osDeployNode;
            return (B)this.self();
        }

        @Generated
        public B manager(ConfigStrategyManager manager) {
            this.manager = manager;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "StrategyConfigTask.StrategyConfigTaskBuilder(super=" + super.toString() + ", osDeployNode=" + this.osDeployNode + ", manager=" + this.manager + ")";
        }
    }
}

