/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.os.service.task.subtask.network.impl;

import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.SshException;
import com.huawei.yinglong.river.sitedeployment.dcs.os.network.bean.BondPort;
import com.huawei.yinglong.river.sitedeployment.dcs.os.service.task.subtask.network.impl.ConfigStrategy;
import com.huawei.yinglong.river.sitedeployment.dcs.os.service.task.subtask.network.impl.NetworkConfigTemplate;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BondConfigStrategy
extends ConfigStrategy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BondConfigStrategy.class);
    private BondPort bondPort;

    @Override
    public void execute() throws SshException {
        log.info("start to config bond strategy.");
        this.initSshShellService(this.networkNodeInfo);
        String bondName = this.bondPort.getBondName();
        List<String> portNameList = this.getPortNames(this.bondPort.getPhysicalPorts());
        this.writeBondPhysicalsConfig(bondName, portNameList);
        String configInfo = "";
        if (this.containsIpv4()) {
            configInfo = NetworkConfigTemplate.createBondPortWithIpv4(this.bondPort, this.ipv4Address, portNameList);
        }
        this.writeNetWorFile(bondName, configInfo, 0);
        ArrayList<String> upPortList = new ArrayList<String>();
        upPortList.add(bondName);
        upPortList.addAll(portNameList);
        this.upPorts(upPortList);
    }

    @Generated
    protected BondConfigStrategy(BondConfigStrategyBuilder<?, ?> b) {
        super(b);
        this.bondPort = ((BondConfigStrategyBuilder)b).bondPort;
    }

    @Generated
    public static BondConfigStrategyBuilder<?, ?> builder() {
        return new BondConfigStrategyBuilderImpl();
    }

    @Generated
    private static final class BondConfigStrategyBuilderImpl
    extends BondConfigStrategyBuilder<BondConfigStrategy, BondConfigStrategyBuilderImpl> {
        @Generated
        private BondConfigStrategyBuilderImpl() {
        }

        @Override
        @Generated
        protected BondConfigStrategyBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public BondConfigStrategy build() {
            return new BondConfigStrategy(this);
        }
    }

    @Generated
    public static abstract class BondConfigStrategyBuilder<C extends BondConfigStrategy, B extends BondConfigStrategyBuilder<C, B>>
    extends ConfigStrategy.ConfigStrategyBuilder<C, B> {
        @Generated
        private BondPort bondPort;

        @Generated
        public B bondPort(BondPort bondPort) {
            this.bondPort = bondPort;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "BondConfigStrategy.BondConfigStrategyBuilder(super=" + super.toString() + ", bondPort=" + this.bondPort + ")";
        }
    }
}

