/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.os.service.task.subtask.network.impl;

import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.SshException;
import com.huawei.yinglong.river.sitedeployment.dcs.os.network.bean.BondPort;
import com.huawei.yinglong.river.sitedeployment.dcs.os.network.bean.Vlan;
import com.huawei.yinglong.river.sitedeployment.dcs.os.service.task.subtask.network.impl.ConfigStrategy;
import com.huawei.yinglong.river.sitedeployment.dcs.os.service.task.subtask.network.impl.NetworkConfigTemplate;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BondToVlanConfigStrategy
extends ConfigStrategy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BondToVlanConfigStrategy.class);
    private BondPort bondPort;
    private Vlan vlan;

    @Override
    public void execute() throws SshException {
        log.info("start to config vlan-bond strategy.");
        this.initSshShellService(this.networkNodeInfo);
        String bondName = this.bondPort.getBondName();
        List<String> portNameList = this.getPortNames(this.bondPort.getPhysicalPorts());
        this.writeBondPhysicalsConfig(bondName, portNameList);
        String configInfo = NetworkConfigTemplate.createBondPortNoIp(this.bondPort, portNameList);
        this.writeNetWorFile(bondName, configInfo, 0);
        this.writeVlanConfig(this.vlan, bondName);
        ArrayList<String> upPortList = new ArrayList<String>();
        upPortList.add(bondName);
        upPortList.addAll(portNameList);
        upPortList.add(this.vlan.getVlanName());
        this.upPorts(upPortList);
    }

    @Generated
    protected BondToVlanConfigStrategy(BondToVlanConfigStrategyBuilder<?, ?> b) {
        super(b);
        this.bondPort = ((BondToVlanConfigStrategyBuilder)b).bondPort;
        this.vlan = ((BondToVlanConfigStrategyBuilder)b).vlan;
    }

    @Generated
    public static BondToVlanConfigStrategyBuilder<?, ?> builder() {
        return new BondToVlanConfigStrategyBuilderImpl();
    }

    @Generated
    private static final class BondToVlanConfigStrategyBuilderImpl
    extends BondToVlanConfigStrategyBuilder<BondToVlanConfigStrategy, BondToVlanConfigStrategyBuilderImpl> {
        @Generated
        private BondToVlanConfigStrategyBuilderImpl() {
        }

        @Override
        @Generated
        protected BondToVlanConfigStrategyBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public BondToVlanConfigStrategy build() {
            return new BondToVlanConfigStrategy(this);
        }
    }

    @Generated
    public static abstract class BondToVlanConfigStrategyBuilder<C extends BondToVlanConfigStrategy, B extends BondToVlanConfigStrategyBuilder<C, B>>
    extends ConfigStrategy.ConfigStrategyBuilder<C, B> {
        @Generated
        private BondPort bondPort;
        @Generated
        private Vlan vlan;

        @Generated
        public B bondPort(BondPort bondPort) {
            this.bondPort = bondPort;
            return (B)this.self();
        }

        @Generated
        public B vlan(Vlan vlan) {
            this.vlan = vlan;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "BondToVlanConfigStrategy.BondToVlanConfigStrategyBuilder(super=" + super.toString() + ", bondPort=" + this.bondPort + ", vlan=" + this.vlan + ")";
        }
    }
}

