/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.os.service.task.subtask.network.impl;

import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.SshException;
import com.huawei.yinglong.river.sitedeployment.dcs.os.exception.DeployOsError;
import com.huawei.yinglong.river.sitedeployment.dcs.os.exception.DeployOsException;
import com.huawei.yinglong.river.sitedeployment.dcs.os.network.bean.DeviceModelEnum;
import com.huawei.yinglong.river.sitedeployment.dcs.os.network.bean.IpAddress;
import com.huawei.yinglong.river.sitedeployment.dcs.os.network.bean.NetworkNodeInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.os.network.bean.PhysicalPort;
import com.huawei.yinglong.river.sitedeployment.dcs.os.network.bean.Vlan;
import com.huawei.yinglong.river.sitedeployment.dcs.os.network.util.SshConnectNetworkManager;
import com.huawei.yinglong.river.sitedeployment.dcs.os.service.task.subtask.network.impl.NetworkConfigTemplate;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshShellService;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.NumberUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConfigStrategy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConfigStrategy.class);
    protected String portName;
    protected NetworkNodeInfo networkNodeInfo;
    protected SshShellService sshShellService;
    protected IpAddress ipv4Address;
    protected IpAddress ipv6Address;
    protected DeviceModelEnum deviceModel;
    private Consumer<String> detailHandler;
    private Map<String, String> slotToAddress;

    public boolean containsIpv4() {
        return this.ipv4Address != null;
    }

    public abstract void execute() throws SshException;

    public List<String> getSlotPorts(String slotAddress) throws SshException {
        String cmd = StringUtils.formatTxt((String)"ls -l /sys/class/net/** | grep %s", (Object[])new Object[]{this.removeSlotAddressFuncNum(slotAddress)});
        String result = this.executeAndRecord(cmd);
        return Arrays.stream(result.split("\n")).filter(line -> !line.contains("ls -l")).filter(line -> line.contains("/sys/class/net/")).filter(this::checkNetConfigValid).map(this::getLogicalName).collect(Collectors.toList());
    }

    protected int getPortNum(String port) {
        String[] portNums = port.toLowerCase(Locale.ROOT).split("port");
        return NumberUtils.parseInt((String)portNums[portNums.length - 1], (int)0);
    }

    private boolean checkNetConfigValid(String line) {
        String[] netConf = line.split("->");
        return netConf.length >= 2 && this.getLogicalName(netConf[0].trim()).equals(this.getLogicalName(netConf[1].trim()));
    }

    private String getLogicalName(String line) {
        String[] names = line.split("/");
        return names[names.length - 1].trim();
    }

    private String removeSlotAddressFuncNum(String slotAddress) {
        String[] addrs = slotAddress.split("\\.");
        if (addrs.length == 2) {
            return addrs[0] + ".";
        }
        log.error("abnormal slot address: {}", (Object)slotAddress);
        return slotAddress;
    }

    public void initSshShellService(NetworkNodeInfo networkNodeInfo) throws SshException {
        if (Objects.isNull(this.sshShellService) || !this.sshShellService.isConnected()) {
            this.sshShellService = SshConnectNetworkManager.getInstance().getShellClient(networkNodeInfo);
        }
    }

    private String executeAndRecord(String cmd) throws SshException {
        log.info("[{}_{}] execute command line: {}", new Object[]{this.getClass().getSimpleName(), this.ipv4Address.getIp(), cmd});
        String sshResult = this.sshShellService.execCommand(cmd);
        log.info("[{}_{}] result: {}", new Object[]{this.getClass().getSimpleName(), this.ipv4Address.getIp(), sshResult});
        this.detailHandler.accept(sshResult);
        return sshResult;
    }

    public void writeNetWorFile(String name, String configInfo, int timeout) throws SshException {
        String networkFileName = StringUtils.formatTxt((String)"ifcfg-%s", (Object[])new Object[]{name});
        String filePath = StringUtils.formatTxt((String)"/etc/sysconfig/network-scripts/%s", (Object[])new Object[]{networkFileName});
        this.recordSummaryConfiguration(filePath);
        if (configInfo.length() > 500) {
            int startIndex;
            String[] configInfos = configInfo.split("\n");
            List<String> configInfoList = Arrays.asList(configInfos);
            String writeCmd = StringUtils.formatTxt((String)"echo -e \"%s\" > %s", (Object[])new Object[]{configInfoList.subList(startIndex, 10), filePath});
            this.executeWrite(writeCmd, timeout);
            for (startIndex = 10; startIndex < configInfos.length; startIndex += 10) {
                writeCmd = StringUtils.formatTxt((String)"echo -e \"%s\" > %s", (Object[])new Object[]{configInfoList.subList(startIndex, startIndex + 10), filePath});
                this.executeWrite(writeCmd, timeout);
            }
        } else {
            String writeCmd = StringUtils.formatTxt((String)"echo -e \"%s\" > %s", (Object[])new Object[]{configInfo, filePath});
            this.executeWrite(writeCmd, timeout);
        }
        String chmodCmd = StringUtils.formatTxt((String)"chmod 640 %s", (Object[])new Object[]{filePath});
        this.executeAndRecord(chmodCmd);
        String chownCmd = StringUtils.formatTxt((String)"chown -h root:root %s", (Object[])new Object[]{filePath});
        this.executeAndRecord(chownCmd);
        String catCmd = StringUtils.formatTxt((String)"cat %s", (Object[])new Object[]{filePath});
        String sshResult = this.executeAndRecord(catCmd);
        for (String configLine : configInfo.split("\n")) {
            if (sshResult.contains(configLine)) continue;
            log.error("write_content:{} file_content:{}  check not pass", (Object)configInfo, (Object)sshResult);
        }
    }

    private void executeWrite(String writeCmd, int timeout) throws SshException {
        if (timeout > 0) {
            log.info("[{}_{}] execute command line: {}", new Object[]{this.getClass().getSimpleName(), this.ipv4Address.getIp(), writeCmd});
            String sshResult = this.sshShellService.execCommandWithTimeout(writeCmd, timeout);
            log.info("[{}_{}] result: {}", new Object[]{this.getClass().getSimpleName(), this.ipv4Address.getIp(), sshResult});
            this.detailHandler.accept(sshResult);
        } else {
            this.executeAndRecord(writeCmd);
        }
    }

    private void recordSummaryConfiguration(String filePath) throws SshException {
        String catCmd = StringUtils.formatTxt((String)"cat %s", (Object[])new Object[]{"/etc/sysconfig/network-record-smartkit/record_list"});
        String sshResult = this.executeAndRecord(catCmd);
        if (sshResult.contains(filePath)) {
            return;
        }
        String lsCmd = StringUtils.formatTxt((String)"ls %s", (Object[])new Object[]{filePath});
        String lsResult = this.executeAndRecord(lsCmd);
        if (lsResult.contains("No such file or directory")) {
            String cmd = StringUtils.formatTxt((String)"echo -e \"add %s\" >> %s", (Object[])new Object[]{filePath, "/etc/sysconfig/network-record-smartkit/record_list"});
            this.executeAndRecord(cmd);
        } else {
            String cmd = StringUtils.formatTxt((String)"/bin/cp -rf -a  %s %s", (Object[])new Object[]{filePath, "/etc/sysconfig/network-record-smartkit"});
            this.executeAndRecord(cmd);
            String fileName = new File(filePath).getName();
            String echo = StringUtils.formatTxt((String)"echo -e \"modify %s %s/%s\" >> %s", (Object[])new Object[]{filePath, "/etc/sysconfig/network-record-smartkit", fileName, "/etc/sysconfig/network-record-smartkit/record_list"});
            this.executeAndRecord(echo);
        }
    }

    public void restoreInitialConfiguration() throws SshException {
        String cmd = StringUtils.formatTxt((String)"cat %s", (Object[])new Object[]{"/etc/sysconfig/network-record-smartkit/record_list"});
        String catResult = this.executeAndRecord(cmd);
        if (catResult.contains("No such file or directory")) {
            String mkdirCmd = StringUtils.formatTxt((String)"mkdir %s", (Object[])new Object[]{"/etc/sysconfig/network-record-smartkit"});
            this.executeAndRecord(mkdirCmd);
            String touchCmd = StringUtils.formatTxt((String)"touch %s", (Object[])new Object[]{"/etc/sysconfig/network-record-smartkit/record_list"});
            this.executeAndRecord(touchCmd);
            return;
        }
        for (String line : catResult.split("\n")) {
            String[] paths;
            if (StringUtils.containIgnoreCase((String)line, (String[])new String[]{"add"})) {
                paths = line.trim().split(" ");
                if (paths.length < 2) {
                    return;
                }
                String filePath = paths[1];
                String rmCmd = StringUtils.formatTxt((String)"rm -f %s", (Object[])new Object[]{filePath});
                this.executeAndRecord(rmCmd);
            }
            if (!StringUtils.containIgnoreCase((String)line, (String[])new String[]{"modify"})) continue;
            paths = line.trim().split(" ");
            if (paths.length < 3) {
                return;
            }
            String modifyFilePath = paths[1];
            String saveFilePath = paths[2];
            String modifyCmd = StringUtils.formatTxt((String)"rm -f %s", (Object[])new Object[]{modifyFilePath});
            this.executeAndRecord(modifyCmd);
            String cpCmd = StringUtils.formatTxt((String)"/bin/cp -rf -a  %s %s", (Object[])new Object[]{saveFilePath, modifyFilePath});
            this.executeAndRecord(cpCmd);
        }
    }

    protected String getLogicalName(String slot, String port) throws SshException {
        if (StringUtils.isEmpty((CharSequence)slot)) {
            return "";
        }
        String slotAddress = this.getSlotAddress(slot.toLowerCase(Locale.ROOT));
        if (StringUtils.isEmpty((CharSequence)slotAddress)) {
            throw new DeployOsException(DeployOsError.BUS_ADDRESS_NOT_FOUND);
        }
        List<String> ports = this.getSlotPorts(slotAddress);
        int portNum = this.getPortNum(port);
        if (ports.size() < portNum) {
            throw new DeployOsException(DeployOsError.PORT_NAME_NOT_FOUND);
        }
        return portNum > 0 ? ports.get(portNum - 1) : "";
    }

    protected String getSlotAddress(String slot) throws SshException {
        if (this.slotToAddress.size() < 2) {
            this.initSlotToAddress();
        }
        return this.slotToAddress.getOrDefault(slot, "");
    }

    private synchronized void initSlotToAddress() throws SshException {
        String[] nics = this.deviceModel.getNicBusAddress().split(";");
        for (int index = 0; index < nics.length; ++index) {
            String key = StringUtils.formatTxt((String)"nic%s", (Object[])new Object[]{index + 1});
            this.slotToAddress.putIfAbsent(key, nics[index]);
        }
        String sshResult = this.executeAndRecord("dmidecode -t slot");
        boolean isFindAddress = false;
        String slotName = "";
        for (String line : sshResult.split("\n")) {
            if (!isFindAddress && line.contains("Designation: ")) {
                String[] designation = line.trim().split("Designation: ");
                slotName = designation[designation.length - 1].toLowerCase(Locale.ROOT);
                isFindAddress = true;
                continue;
            }
            if (!isFindAddress || !line.contains("Bus Address: ")) continue;
            String[] bus = line.trim().split("Bus Address: ");
            String slotAddress = bus[bus.length - 1];
            isFindAddress = false;
            if (!this.isValidSlotAddress(slotAddress)) continue;
            this.slotToAddress.putIfAbsent(slotName, slotAddress);
        }
    }

    private boolean isValidSlotAddress(String slotAddress) {
        return !slotAddress.matches("^[:0.]+$");
    }

    protected void writeBondPhysicalsConfig(String bondName, List<String> portNameList) throws SshException {
        for (String physicalPortName : portNameList) {
            String configInfo = NetworkConfigTemplate.createLogicalPortToBond(physicalPortName, bondName);
            this.writeNetWorFile(physicalPortName, configInfo, 0);
        }
    }

    protected List<String> getPortNames(List<PhysicalPort> physicalPorts) throws SshException {
        ArrayList<String> portNameList = new ArrayList<String>();
        for (PhysicalPort physicalPort : physicalPorts) {
            portNameList.add(this.getLogicalName(physicalPort.getSlot(), physicalPort.getPort()));
        }
        return portNameList;
    }

    protected void writeVlanConfig(Vlan vlan, String portName) throws SshException {
        String configInfo = "";
        String vlanName = vlan.getVlanName();
        if (this.containsIpv4()) {
            configInfo = NetworkConfigTemplate.createVlanWithIpv4(vlanName, this.ipv4Address, portName, vlan.getVlanId());
        }
        this.writeNetWorFile(vlanName, configInfo, 0);
    }

    protected void upPorts(List<String> portNames) throws SshException {
        for (String partName : portNames) {
            String ifUpCmd = StringUtils.formatTxt((String)"ifup %s", (Object[])new Object[]{partName});
            String ifUpResult = this.executeAndRecord(ifUpCmd);
            if (ifUpResult.contains("successfully")) continue;
            throw new DeployOsException(DeployOsError.UP_PORT_FAILED);
        }
    }

    public void releaseConnection(String bmcIp) {
        SshConnectNetworkManager.getInstance().releaseConnection(this.sshShellService, bmcIp);
    }

    @Generated
    private static Map<String, String> $default$slotToAddress() {
        return new HashMap<String, String>();
    }

    @Generated
    protected ConfigStrategy(ConfigStrategyBuilder<?, ?> b) {
        this.portName = ((ConfigStrategyBuilder)b).portName;
        this.networkNodeInfo = ((ConfigStrategyBuilder)b).networkNodeInfo;
        this.sshShellService = ((ConfigStrategyBuilder)b).sshShellService;
        this.ipv4Address = ((ConfigStrategyBuilder)b).ipv4Address;
        this.ipv6Address = ((ConfigStrategyBuilder)b).ipv6Address;
        this.deviceModel = ((ConfigStrategyBuilder)b).deviceModel;
        this.detailHandler = ((ConfigStrategyBuilder)b).detailHandler;
        this.slotToAddress = ((ConfigStrategyBuilder)b).slotToAddress$set ? ((ConfigStrategyBuilder)b).slotToAddress$value : ConfigStrategy.$default$slotToAddress();
    }

    @Generated
    public String getPortName() {
        return this.portName;
    }

    @Generated
    public void setNetworkNodeInfo(NetworkNodeInfo networkNodeInfo) {
        this.networkNodeInfo = networkNodeInfo;
    }

    @Generated
    public void setDetailHandler(Consumer<String> detailHandler) {
        this.detailHandler = detailHandler;
    }

    @Generated
    public static abstract class ConfigStrategyBuilder<C extends ConfigStrategy, B extends ConfigStrategyBuilder<C, B>> {
        @Generated
        private String portName;
        @Generated
        private NetworkNodeInfo networkNodeInfo;
        @Generated
        private SshShellService sshShellService;
        @Generated
        private IpAddress ipv4Address;
        @Generated
        private IpAddress ipv6Address;
        @Generated
        private DeviceModelEnum deviceModel;
        @Generated
        private Consumer<String> detailHandler;
        @Generated
        private boolean slotToAddress$set;
        @Generated
        private Map<String, String> slotToAddress$value;

        @Generated
        public B portName(String portName) {
            this.portName = portName;
            return this.self();
        }

        @Generated
        public B networkNodeInfo(NetworkNodeInfo networkNodeInfo) {
            this.networkNodeInfo = networkNodeInfo;
            return this.self();
        }

        @Generated
        public B sshShellService(SshShellService sshShellService) {
            this.sshShellService = sshShellService;
            return this.self();
        }

        @Generated
        public B ipv4Address(IpAddress ipv4Address) {
            this.ipv4Address = ipv4Address;
            return this.self();
        }

        @Generated
        public B ipv6Address(IpAddress ipv6Address) {
            this.ipv6Address = ipv6Address;
            return this.self();
        }

        @Generated
        public B deviceModel(DeviceModelEnum deviceModel) {
            this.deviceModel = deviceModel;
            return this.self();
        }

        @Generated
        public B detailHandler(Consumer<String> detailHandler) {
            this.detailHandler = detailHandler;
            return this.self();
        }

        @Generated
        public B slotToAddress(Map<String, String> slotToAddress) {
            this.slotToAddress$value = slotToAddress;
            this.slotToAddress$set = true;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "ConfigStrategy.ConfigStrategyBuilder(portName=" + this.portName + ", networkNodeInfo=" + this.networkNodeInfo + ", sshShellService=" + this.sshShellService + ", ipv4Address=" + this.ipv4Address + ", ipv6Address=" + this.ipv6Address + ", deviceModel=" + (Object)((Object)this.deviceModel) + ", detailHandler=" + this.detailHandler + ", slotToAddress$value=" + this.slotToAddress$value + ")";
        }
    }
}

