/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.os.service.task.subtask.network.impl;

import com.huawei.yinglong.river.sitedeployment.dcs.os.exception.DeployOsError;
import com.huawei.yinglong.river.sitedeployment.dcs.os.exception.DeployOsException;
import com.huawei.yinglong.river.sitedeployment.dcs.os.network.bean.BondPort;
import com.huawei.yinglong.river.sitedeployment.dcs.os.network.bean.IpAddress;
import com.huawei.yinglong.river.sitedeployment.dcs.os.network.bean.NetworkPlaneInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.os.network.bean.NetworkingPortType;
import com.huawei.yinglong.river.sitedeployment.dcs.os.network.bean.PhysicalPort;
import com.huawei.yinglong.river.sitedeployment.dcs.os.network.bean.StrategyInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.os.network.bean.Vlan;
import com.huawei.yinglong.river.sitedeployment.dcs.os.service.task.subtask.network.impl.BondConfigStrategy;
import com.huawei.yinglong.river.sitedeployment.dcs.os.service.task.subtask.network.impl.BondToVlanConfigStrategy;
import com.huawei.yinglong.river.sitedeployment.dcs.os.service.task.subtask.network.impl.ConfigStrategy;
import com.huawei.yinglong.river.sitedeployment.dcs.os.service.task.subtask.network.impl.PhysicalConfigStrategy;
import com.huawei.yinglong.river.sitedeployment.dcs.os.service.task.subtask.network.impl.PhysicalToVlanConfigStrategy;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigStrategyManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConfigStrategyManager.class);
    private static final ConfigStrategyManager INSTANCE = new ConfigStrategyManager();
    private Map<String, ConfigStrategy> configStrategies = new HashMap<String, ConfigStrategy>();
    private Map<String, Set<StrategyInfo>> strategyInfoMap = new HashMap<String, Set<StrategyInfo>>();
    private Set<String> bmcIps = new HashSet<String>();
    private Set<String> usedNetworkIps = new HashSet<String>();

    public static ConfigStrategyManager getInstance() {
        return INSTANCE;
    }

    public void initConfigStrategies(List<NetworkPlaneInfo> networkPlaneInfoList) {
        log.info("start parse network config strategy.");
        networkPlaneInfoList.forEach(this::parseMultiIpNetwork);
        log.info("parse network config strategy successfully.");
    }

    public List<ConfigStrategy> getConfigStrategyList() {
        return new ArrayList<ConfigStrategy>(this.configStrategies.values());
    }

    private void parseMultiIpNetwork(NetworkPlaneInfo networkPlaneInfo) {
        if (StringUtils.isEmpty((CharSequence)networkPlaneInfo.getIp())) {
            return;
        }
        String planeName = networkPlaneInfo.getNetWorkPlaneName();
        this.parseOneIpNetWork(networkPlaneInfo).ifPresent(configStrategy -> this.configStrategies.put(planeName, (ConfigStrategy)configStrategy));
    }

    private Optional<ConfigStrategy> parseOneIpNetWork(NetworkPlaneInfo networkPlaneInfo) {
        IpAddress ipAddress = this.createIpAddress(networkPlaneInfo);
        return this.judgeUsed2ParseStrategy(networkPlaneInfo, ipAddress);
    }

    private IpAddress createIpAddress(NetworkPlaneInfo networkPlaneInfo) {
        String ipPattern = networkPlaneInfo.getIpPattern();
        String ip = networkPlaneInfo.getIp();
        String netMaskOrPrefix = networkPlaneInfo.getNetmask();
        String gateway = networkPlaneInfo.getGateway();
        IpAddress.IpPattern pattern = IpAddress.IpPattern.valueOf(ipPattern.toUpperCase(Locale.ENGLISH));
        IpAddress ipAddress = new IpAddress();
        if (IpAddress.IpPattern.IPV4.equals((Object)pattern)) {
            ipAddress.setIpv4Address(ip, netMaskOrPrefix, gateway);
        } else {
            ipAddress.setIpv6Address(ip, netMaskOrPrefix, gateway);
        }
        if ("management".equals(networkPlaneInfo.getNetWorkPlaneName())) {
            ipAddress.setDefaultRoute(true);
        }
        return ipAddress;
    }

    private Optional<ConfigStrategy> judgeUsed2ParseStrategy(NetworkPlaneInfo networkPlaneInfo, IpAddress ipAddress) {
        Optional<ConfigStrategy> configStrategyOptional = this.parseNetworkStrategy(networkPlaneInfo, ipAddress);
        if (!configStrategyOptional.isPresent()) {
            return Optional.empty();
        }
        String portName = configStrategyOptional.get().getPortName();
        StrategyInfo strategyInfo = new StrategyInfo(portName, ipAddress);
        if (this.isOtherPlaneUsedConfigStrategy(networkPlaneInfo, strategyInfo)) {
            return Optional.empty();
        }
        this.addStrategyInfoToUsed(networkPlaneInfo, strategyInfo);
        if (!this.verifyUsedIp(ipAddress.getIp())) {
            return Optional.empty();
        }
        return configStrategyOptional;
    }

    private void addStrategyInfoToUsed(NetworkPlaneInfo networkPlaneInfo, StrategyInfo info) {
        this.strategyInfoMap.computeIfAbsent(networkPlaneInfo.getNetWorkPlaneName(), key -> new HashSet()).add(info);
    }

    private boolean isOtherPlaneUsedConfigStrategy(NetworkPlaneInfo networkPlaneInfo, StrategyInfo strategyInfo) {
        return this.strategyInfoMap.entrySet().stream().filter(entry -> !networkPlaneInfo.getNetWorkPlaneName().equals(entry.getKey())).map(Map.Entry::getValue).anyMatch(set -> set.contains(strategyInfo));
    }

    private boolean verifyUsedIp(String ip) {
        if (StringUtils.isEmpty((CharSequence)ip)) {
            return false;
        }
        if (this.usedNetworkIps.contains(ip) || this.bmcIps.contains(ip)) {
            throw new DeployOsException(DeployOsError.NETWORK_IP_HAS_BEEN_USED);
        }
        this.usedNetworkIps.add(ip);
        return true;
    }

    private Optional<ConfigStrategy> parseNetworkStrategy(NetworkPlaneInfo networkPlaneInfo, IpAddress ipAddress) {
        String physicalPortInfo = networkPlaneInfo.getNetCardName();
        String portType = networkPlaneInfo.getPortType();
        int vlanId = networkPlaneInfo.getVlanId();
        if (vlanId <= 0) {
            if (NetworkingPortType.BOND_PORT.getModeName().equals(portType)) {
                BondPort bondPort = this.toBondPort(networkPlaneInfo);
                return Optional.of(((BondConfigStrategy.BondConfigStrategyBuilder)((ConfigStrategy.ConfigStrategyBuilder)((BondConfigStrategy.BondConfigStrategyBuilder)BondConfigStrategy.builder().ipv4Address(ipAddress)).bondPort(bondPort)).deviceModel(networkPlaneInfo.getDeviceModel())).build());
            }
            if (NetworkingPortType.PHYSICAL_PORT.getModeName().equals(portType)) {
                PhysicalPort physicalPort = this.parsePhysicalPort(physicalPortInfo);
                return Optional.of(((PhysicalConfigStrategy.PhysicalConfigStrategyBuilder)((ConfigStrategy.ConfigStrategyBuilder)((PhysicalConfigStrategy.PhysicalConfigStrategyBuilder)PhysicalConfigStrategy.builder().ipv4Address(ipAddress)).physicalPort(physicalPort)).deviceModel(networkPlaneInfo.getDeviceModel())).build());
            }
            log.error("parse network strategy failed, cause the invalid port type [{}].", (Object)portType);
            throw new DeployOsException(DeployOsError.ILLEGAL_PORT_TYPE);
        }
        String vlanName = "vlan." + vlanId;
        Vlan vlan = new Vlan(vlanName, String.valueOf(vlanId));
        if (NetworkingPortType.PHYSICAL_PORT.getModeName().equals(portType)) {
            PhysicalPort physicalPort = this.parsePhysicalPort(physicalPortInfo);
            return Optional.of(((PhysicalToVlanConfigStrategy.PhysicalToVlanConfigStrategyBuilder)((ConfigStrategy.ConfigStrategyBuilder)((PhysicalToVlanConfigStrategy.PhysicalToVlanConfigStrategyBuilder)((PhysicalToVlanConfigStrategy.PhysicalToVlanConfigStrategyBuilder)PhysicalToVlanConfigStrategy.builder().ipv4Address(ipAddress)).physicalPort(physicalPort)).vlan(vlan)).deviceModel(networkPlaneInfo.getDeviceModel())).build());
        }
        if (NetworkingPortType.BOND_PORT.getModeName().equals(portType)) {
            BondPort bondPort = this.toBondPort(networkPlaneInfo);
            return Optional.of(((BondToVlanConfigStrategy.BondToVlanConfigStrategyBuilder)((ConfigStrategy.ConfigStrategyBuilder)((BondToVlanConfigStrategy.BondToVlanConfigStrategyBuilder)((BondToVlanConfigStrategy.BondToVlanConfigStrategyBuilder)BondToVlanConfigStrategy.builder().ipv4Address(ipAddress)).bondPort(bondPort)).vlan(vlan)).deviceModel(networkPlaneInfo.getDeviceModel())).build());
        }
        log.error("parse network strategy failed, cause the invalid port type [{}].", (Object)portType);
        throw new DeployOsException(DeployOsError.ILLEGAL_PORT_TYPE);
    }

    private List<PhysicalPort> parsePhysicalNetworkCard(String physicalCard) {
        return Arrays.stream(physicalCard.split(",")).map(this::parsePhysicalPort).collect(Collectors.toList());
    }

    private PhysicalPort parsePhysicalPort(String physicalPortInfo) {
        if (StringUtils.containIgnoreCase((String)physicalPortInfo, (String[])new String[]{","}) || !this.isValidPhysicalPort(physicalPortInfo)) {
            log.error("The format of physical port [{}] is illegal.", (Object)physicalPortInfo);
            throw new DeployOsException(DeployOsError.ILLEGAL_PHYSICAL_PORT);
        }
        String[] physicalPortInfos = physicalPortInfo.split("/");
        return new PhysicalPort(physicalPortInfos[0], physicalPortInfos[1]);
    }

    boolean isValidPhysicalPort(String physicalPortInfo) {
        return physicalPortInfo.matches(".+/([pP])ort[1-9][0-9]*");
    }

    public BondPort toBondPort(NetworkPlaneInfo networkPlaneInfo) {
        String bondMode = networkPlaneInfo.getBondMode();
        if (!this.checkBondPattern(bondMode)) {
            log.error("parse network strategy failed, cause the invalid bond mode [{}].", (Object)bondMode);
            throw new DeployOsException(DeployOsError.ILLEGAL_BOND_TYPE);
        }
        List<PhysicalPort> physicalPortList = this.parsePhysicalNetworkCard(networkPlaneInfo.getNetCardName());
        if (physicalPortList.size() < 2) {
            log.error("parse network strategy failed, cause the invalid bond port [{}].", (Object)networkPlaneInfo.getNetCardName());
            throw new DeployOsException(DeployOsError.ILLEGAL_PHYSICAL_PORT);
        }
        return BondPort.builder().bondName(networkPlaneInfo.getBondName()).physicalPorts(physicalPortList).bondPattern(BondPort.BondPattern.valueOf(bondMode.toUpperCase(Locale.ROOT))).mtu(String.valueOf(networkPlaneInfo.getMtu())).build();
    }

    private boolean checkBondPattern(String bondMode) {
        return Arrays.stream(BondPort.BondPattern.values()).anyMatch(bondPattern -> bondPattern.name().equalsIgnoreCase(bondMode));
    }

    @Generated
    public void setBmcIps(Set<String> bmcIps) {
        this.bmcIps = bmcIps;
    }

    @Generated
    public Set<String> getBmcIps() {
        return this.bmcIps;
    }
}

