/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.os.service.task.subtask.network.impl;

import com.huawei.yinglong.river.sitedeployment.dcs.os.network.bean.BondOpt;
import com.huawei.yinglong.river.sitedeployment.dcs.os.network.bean.BondPort;
import com.huawei.yinglong.river.sitedeployment.dcs.os.network.bean.IpAddress;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class NetworkConfigTemplate {
    private static final Map<String, String> LOGICAL_PORT_TO_BOND = new HashMap<String, String>();
    private static final Map<String, String> LOGICAL_PORT_TO_VLAN = new HashMap<String, String>();
    private static final Map<String, String> LOGICAL_PORT_WITH_IPV4 = new HashMap<String, String>();
    private static final Map<String, String> BOND_PORT_WITH_IPV4 = new HashMap<String, String>();
    private static final Map<String, String> BOND_PORT_NO_IP = new HashMap<String, String>();
    private static final Map<String, String> VLAN_WITH_IPV4 = new HashMap<String, String>();
    private static final Map<BondPort.BondPattern, List<BondOpt>> BOND_OPTS_MAP = new HashMap<BondPort.BondPattern, List<BondOpt>>();

    public static String transMapToFileEchoInfo(Map<String, String> template) {
        return template.entrySet().stream().map(entry -> String.format(Locale.ROOT, "%s=%s", entry.getKey(), entry.getValue())).collect(Collectors.joining("\n"));
    }

    private static void addIpv4ToTemplate(Map<String, String> template, IpAddress ipv4) {
        template.put("IPADDR", ipv4.getIp());
        template.put("NETMASK", ipv4.getNetMaskOrPrefix());
        String gateway = ipv4.getGateway();
        if (!StringUtils.isEmpty((CharSequence)gateway)) {
            template.put("NETWORKING", "yes");
            template.put("GATEWAY", gateway);
        }
        template.put("DEFROUTE", ipv4.isDefaultRoute() ? "yes" : "no");
    }

    public static String createVlanWithIpv4(String vlanName, IpAddress ipv4) {
        HashMap<String, String> template = new HashMap<String, String>(LOGICAL_PORT_WITH_IPV4);
        template.put("DEVICE", vlanName);
        NetworkConfigTemplate.addIpv4ToTemplate(template, ipv4);
        return NetworkConfigTemplate.transMapToFileEchoInfo(template);
    }

    public static String createLogicalPortToBond(String portName, String master) {
        HashMap<String, String> template = new HashMap<String, String>(LOGICAL_PORT_TO_BOND);
        template.put("DEVICE", portName);
        template.put("MASTER", master);
        return NetworkConfigTemplate.transMapToFileEchoInfo(template);
    }

    public static String createBondPortNoIp(BondPort bondPort, List<String> portNames) {
        HashMap<String, String> template = new HashMap<String, String>(BOND_PORT_NO_IP);
        template.put("DEVICE", bondPort.getBondName());
        NetworkConfigTemplate.addBondInfoToTemplate(template, bondPort, portNames);
        return NetworkConfigTemplate.transMapToFileEchoInfo(template);
    }

    private static String getBondBuildInfo(BondPort.BondPattern bondPattern) {
        return BOND_OPTS_MAP.get((Object)bondPattern).stream().sorted().map(BondOpt::toString).collect(Collectors.joining(" ", "'", "'"));
    }

    public static String createBondPortWithIpv4(BondPort bondPort, IpAddress ipv4, List<String> portNames) {
        HashMap<String, String> template = new HashMap<String, String>(BOND_PORT_WITH_IPV4);
        template.put("DEVICE", bondPort.getBondName());
        NetworkConfigTemplate.addIpv4ToTemplate(template, ipv4);
        NetworkConfigTemplate.addBondInfoToTemplate(template, bondPort, portNames);
        return NetworkConfigTemplate.transMapToFileEchoInfo(template);
    }

    private static void addBondInfoToTemplate(Map<String, String> template, BondPort bondPort, List<String> portNames) {
        template.put("MTU", bondPort.getMtu());
        template.put("BONDING_OPTS", NetworkConfigTemplate.getBondBuildInfo(bondPort.getBondPattern()));
        if (CollectionUtils.isNotEmpty(portNames)) {
            template.put("BONDING_SLAVE0", portNames.get(0));
        }
        if (portNames.size() > 1) {
            template.put("BONDING_SLAVE1", portNames.get(1));
        }
    }

    public static String createLogicalPortToVlan(String portName) {
        HashMap<String, String> template = new HashMap<String, String>(LOGICAL_PORT_TO_VLAN);
        template.put("DEVICE", portName);
        return NetworkConfigTemplate.transMapToFileEchoInfo(template);
    }

    public static String createVlanWithIpv4(String vlanName, IpAddress ipv4, String portName, String vlanId) {
        HashMap<String, String> template = new HashMap<String, String>(VLAN_WITH_IPV4);
        template.put("DEVICE", vlanName);
        NetworkConfigTemplate.addIpv4ToTemplate(template, ipv4);
        NetworkConfigTemplate.addVlanInfoToTemplate(template, portName, vlanId);
        return NetworkConfigTemplate.transMapToFileEchoInfo(template);
    }

    private static void addVlanInfoToTemplate(Map<String, String> template, String portName, String vlanId) {
        template.put("PHYSDEV", portName);
        template.put("VID", vlanId);
    }

    static {
        LOGICAL_PORT_TO_BOND.put("DEVICE", null);
        LOGICAL_PORT_TO_BOND.put("BOOTPROTO", "none");
        LOGICAL_PORT_TO_BOND.put("ONBOOT", "yes");
        LOGICAL_PORT_TO_BOND.put("MASTER", null);
        LOGICAL_PORT_TO_BOND.put("SLAVE", "yes");
        LOGICAL_PORT_TO_BOND.put("USERCTL", "no");
        LOGICAL_PORT_TO_VLAN.put("DEVICE", null);
        LOGICAL_PORT_TO_VLAN.put("BOOTPROTO", "none");
        LOGICAL_PORT_TO_VLAN.put("ONBOOT", "yes");
        LOGICAL_PORT_TO_VLAN.put("STARTMODE", "onboot");
        LOGICAL_PORT_WITH_IPV4.put("DEVICE", null);
        LOGICAL_PORT_WITH_IPV4.put("BOOTPROTO", "static");
        LOGICAL_PORT_WITH_IPV4.put("ONBOOT", "yes");
        LOGICAL_PORT_WITH_IPV4.put("STARTMODE", "onboot");
        LOGICAL_PORT_WITH_IPV4.put("IPADDR", null);
        LOGICAL_PORT_WITH_IPV4.put("NETMASK", null);
        LOGICAL_PORT_WITH_IPV4.put("IPV6_AUTOCONF", "no");
        BOND_PORT_WITH_IPV4.put("DEVICE", null);
        BOND_PORT_WITH_IPV4.put("IPADDR", null);
        BOND_PORT_WITH_IPV4.put("NETMASK", null);
        BOND_PORT_WITH_IPV4.put("ONBOOT", "yes");
        BOND_PORT_WITH_IPV4.put("BOOTPROTO", "static");
        BOND_PORT_WITH_IPV4.put("USERCTL", "no");
        BOND_PORT_WITH_IPV4.put("TYPE", "Bond");
        BOND_PORT_WITH_IPV4.put("MTU", null);
        BOND_PORT_WITH_IPV4.put("IPV6_AUTOCONF", "no");
        BOND_PORT_WITH_IPV4.put("BONDING_OPTS", null);
        BOND_PORT_WITH_IPV4.put("BONDING_SLAVE0", null);
        BOND_PORT_WITH_IPV4.put("BONDING_SLAVE1", null);
        BOND_PORT_NO_IP.put("DEVICE", null);
        BOND_PORT_NO_IP.put("ONBOOT", "yes");
        BOND_PORT_NO_IP.put("BOOTPROTO", "none");
        BOND_PORT_NO_IP.put("USERCTL", "no");
        BOND_PORT_NO_IP.put("TYPE", "Bond");
        BOND_PORT_NO_IP.put("MTU", null);
        BOND_PORT_NO_IP.put("BONDING_OPTS", null);
        BOND_PORT_NO_IP.put("BONDING_SLAVE0", null);
        BOND_PORT_NO_IP.put("BONDING_SLAVE1", null);
        VLAN_WITH_IPV4.put("DEVICE", null);
        VLAN_WITH_IPV4.put("IPADDR", null);
        VLAN_WITH_IPV4.put("NETMASK", null);
        VLAN_WITH_IPV4.put("BOOTPROTO", "static");
        VLAN_WITH_IPV4.put("PHYSDEV", null);
        VLAN_WITH_IPV4.put("ONBOOT", "yes");
        VLAN_WITH_IPV4.put("USERCTL", "no");
        VLAN_WITH_IPV4.put("VLAN", "yes");
        VLAN_WITH_IPV4.put("VID", null);
        VLAN_WITH_IPV4.put("IPV6_AUTOCONF", "no");
        ArrayList<BondOpt> bond1List = new ArrayList<BondOpt>();
        bond1List.add(BondOpt.mode("1"));
        bond1List.add(BondOpt.miimon());
        BOND_OPTS_MAP.put(BondPort.BondPattern.BOND1, bond1List);
        ArrayList<BondOpt> bond2List = new ArrayList<BondOpt>();
        bond2List.add(BondOpt.mode("2"));
        bond2List.add(BondOpt.miimon());
        bond2List.add(BondOpt.xmitHashPolicy());
        BOND_OPTS_MAP.put(BondPort.BondPattern.BOND2, bond2List);
        ArrayList<BondOpt> bond4List = new ArrayList<BondOpt>();
        bond4List.add(BondOpt.mode("4"));
        bond4List.add(BondOpt.miimon());
        bond4List.add(BondOpt.lacpRate());
        bond4List.add(BondOpt.xmitHashPolicy());
        BOND_OPTS_MAP.put(BondPort.BondPattern.BOND4, bond4List);
    }
}

