/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.os.service.task.subtask.network.impl;

import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.SshException;
import com.huawei.yinglong.river.sitedeployment.dcs.os.network.bean.PhysicalPort;
import com.huawei.yinglong.river.sitedeployment.dcs.os.network.bean.Vlan;
import com.huawei.yinglong.river.sitedeployment.dcs.os.service.task.subtask.network.impl.ConfigStrategy;
import com.huawei.yinglong.river.sitedeployment.dcs.os.service.task.subtask.network.impl.NetworkConfigTemplate;
import java.util.ArrayList;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhysicalToVlanConfigStrategy
extends ConfigStrategy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PhysicalToVlanConfigStrategy.class);
    private PhysicalPort physicalPort;
    private Vlan vlan;

    @Override
    public void execute() throws SshException {
        log.info("start to config vlan-physical strategy.");
        this.initSshShellService(this.networkNodeInfo);
        String portName = this.getLogicalName(this.physicalPort.getSlot(), this.physicalPort.getPort());
        String configInfo = "";
        if (this.containsIpv4()) {
            configInfo = NetworkConfigTemplate.createLogicalPortToVlan(portName);
        }
        this.writeNetWorFile(portName, configInfo, 0);
        this.writeVlanConfig(this.vlan, portName);
        ArrayList<String> upPortList = new ArrayList<String>();
        upPortList.add(portName);
        upPortList.add(this.vlan.getVlanName());
        this.upPorts(upPortList);
    }

    @Generated
    protected PhysicalToVlanConfigStrategy(PhysicalToVlanConfigStrategyBuilder<?, ?> b) {
        super(b);
        this.physicalPort = ((PhysicalToVlanConfigStrategyBuilder)b).physicalPort;
        this.vlan = ((PhysicalToVlanConfigStrategyBuilder)b).vlan;
    }

    @Generated
    public static PhysicalToVlanConfigStrategyBuilder<?, ?> builder() {
        return new PhysicalToVlanConfigStrategyBuilderImpl();
    }

    @Generated
    private static final class PhysicalToVlanConfigStrategyBuilderImpl
    extends PhysicalToVlanConfigStrategyBuilder<PhysicalToVlanConfigStrategy, PhysicalToVlanConfigStrategyBuilderImpl> {
        @Generated
        private PhysicalToVlanConfigStrategyBuilderImpl() {
        }

        @Override
        @Generated
        protected PhysicalToVlanConfigStrategyBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public PhysicalToVlanConfigStrategy build() {
            return new PhysicalToVlanConfigStrategy(this);
        }
    }

    @Generated
    public static abstract class PhysicalToVlanConfigStrategyBuilder<C extends PhysicalToVlanConfigStrategy, B extends PhysicalToVlanConfigStrategyBuilder<C, B>>
    extends ConfigStrategy.ConfigStrategyBuilder<C, B> {
        @Generated
        private PhysicalPort physicalPort;
        @Generated
        private Vlan vlan;

        @Generated
        public B physicalPort(PhysicalPort physicalPort) {
            this.physicalPort = physicalPort;
            return (B)this.self();
        }

        @Generated
        public B vlan(Vlan vlan) {
            this.vlan = vlan;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "PhysicalToVlanConfigStrategy.PhysicalToVlanConfigStrategyBuilder(super=" + super.toString() + ", physicalPort=" + this.physicalPort + ", vlan=" + this.vlan + ")";
        }
    }
}

