/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.os.service.task.subtask.raid;

import com.huawei.yinglong.river.sitedeployment.dcs.os.bean.OsDeployBaseInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.os.bean.raid.RaidNodeInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.os.entity.vo.CreateLogicalDiskRaidOemParamsVo;
import com.huawei.yinglong.river.sitedeployment.dcs.os.entity.vo.CreateLogicalDiskRaidParamsVo;
import com.huawei.yinglong.river.sitedeployment.dcs.os.entity.vo.GetBladeDiskParamsVo;
import com.huawei.yinglong.river.sitedeployment.dcs.os.entity.vo.UpdateLogicalDiskOemParamsVo;
import com.huawei.yinglong.river.sitedeployment.dcs.os.entity.vo.UpdateLogicalDiskParamsVo;
import com.huawei.yinglong.river.sitedeployment.dcs.os.exception.DeployOsError;
import com.huawei.yinglong.river.sitedeployment.dcs.os.exception.DeployOsException;
import com.huawei.yinglong.river.sitedeployment.dcs.os.fit.RaidInfoAssembler;
import com.huawei.yinglong.river.sitedeployment.dcs.os.service.task.subtask.BasicBmcSubTask;
import com.huawei.yinglong.river.sitedeployment.dcs.os.service.task.subtask.raid.TaskState;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ThreadUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.mapstruct.factory.Mappers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Response;

public class SetRaidTask
extends BasicBmcSubTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SetRaidTask.class);
    public static final String NAME_KEY = "config.raid";
    private static final int MAX_RETRY_COUNT = 2;
    private final RaidInfoAssembler assembler = (RaidInfoAssembler)Mappers.getMapper(RaidInfoAssembler.class);

    public void execute() throws TaskException {
        log.info("start set raid");
        OsDeployBaseInfo baseInfo = this.osDeployNode.getBaseInfo();
        RaidNodeInfo raidNodeInfo = this.osDeployNode.getRaidNodeInfo();
        if (baseInfo == null || raidNodeInfo == null) {
            log.error("raid info or os base info is empty");
            throw new DeployOsException(DeployOsError.PARAM_ERROR);
        }
        this.appendTaskDetail("start to config RAID.");
        this.setAndRaidLogicalDisk(baseInfo, raidNodeInfo);
        this.appendTaskDetail("finish to config RAID.");
    }

    private void updateSystemBasicRaidInfo(RaidNodeInfo raidNodeInfo) {
        this.tryUpdateSystemIdInfo(() -> this.requestApi.getSystems(this.defaultBmcHeaders).execute(), raidNodeInfo::setSystemId);
        this.tryUpdateSystemIdInfo(() -> this.requestApi.getSystemStorage(raidNodeInfo.getSystemId(), this.defaultBmcHeaders).execute(), raidNodeInfo::setRaidId);
        this.tryUpdateSystemIdInfo(() -> this.requestApi.getSystemLogicalDiskId(raidNodeInfo.getSystemId(), raidNodeInfo.getRaidId(), this.defaultBmcHeaders).execute(), raidNodeInfo::setLogicalDiskId);
    }

    private void setAndRaidLogicalDisk(OsDeployBaseInfo baseInfo, RaidNodeInfo raidNodeInfo) {
        this.updateSystemBasicRaidInfo(raidNodeInfo);
        this.appendTaskDetail("prepare to delete local disk.");
        if (!this.deleteLocalDisk(baseInfo, raidNodeInfo)) {
            throw new DeployOsException(DeployOsError.DELETE_LOGICAL_DISK);
        }
        this.appendTaskDetail("prepare to check drives.");
        if (!this.checkDrivesExist(baseInfo, raidNodeInfo)) {
            log.warn("no non-pcie card, skip create raid.");
            return;
        }
        this.appendTaskDetail("prepare to create logical disk.");
        if (!this.setRaid(baseInfo, raidNodeInfo)) {
            throw new DeployOsException(DeployOsError.CREATE_LOGICAL_DISK);
        }
        this.updateSystemBasicRaidInfo(raidNodeInfo);
        Optional<String> opETag = this.getLocalDisk(raidNodeInfo);
        if (!opETag.isPresent()) {
            throw new DeployOsException(DeployOsError.QUERY_LOGICAL_DISK);
        }
        this.appendTaskDetail("prepare to update boot sequence.");
        if (!this.updateLocalDisk(baseInfo, raidNodeInfo, opETag.get())) {
            throw new DeployOsException(DeployOsError.UPDATE_LOGICAL_DISK);
        }
    }

    private boolean checkDrivesExist(OsDeployBaseInfo baseInfo, RaidNodeInfo raidNodeInfo) {
        if (Objects.equals("Blade1", raidNodeInfo.getSystemId()) && this.checkBladeDrivesExist(baseInfo)) {
            baseInfo.setHardRaidDeviceLetter("sda");
            raidNodeInfo.setSystemId("Blade1");
            return false;
        }
        return this.checkRaidDrivesExist(baseInfo, raidNodeInfo);
    }

    private boolean checkBladeDrivesExist(OsDeployBaseInfo baseInfo) {
        Response response;
        try {
            response = this.requestApi.getBladeAllDisk(this.defaultBmcHeaders).execute();
        }
        catch (IOException e) {
            log.error("failed to check whether the blade exists, bmc ip: {}", (Object)baseInfo.getBmcIp(), (Object)e);
            return false;
        }
        if (response.code() == 404) {
            log.info("failed to check whether the blade exists, the resource does not exist, bmc ip: {}", (Object)baseInfo.getBmcIp());
            return false;
        }
        if (!response.isSuccessful() || response.body() == null) {
            log.info("failed to check whether the blade exists, bmc ip: {}", (Object)baseInfo.getBmcIp());
            return false;
        }
        return ((GetBladeDiskParamsVo)response.body()).getOdataIds().stream().anyMatch(id -> id.contains("M.2"));
    }

    private boolean checkRaidDrivesExist(OsDeployBaseInfo baseInfo, RaidNodeInfo raidNodeInfo) {
        List driveList;
        Response response;
        String bmcIp = baseInfo.getBmcIp();
        try {
            response = this.requestApi.getLogicalDisk(raidNodeInfo.getSystemId(), raidNodeInfo.getRaidId(), this.defaultBmcHeaders).execute();
        }
        catch (IOException e) {
            log.error("failed to check whether the PCIE card exists, bmc ip: {}", (Object)bmcIp, (Object)e);
            throw new DeployOsException(DeployOsError.CHECK_LOGICAL_DISK);
        }
        if (response.code() == 404) {
            log.info("check whether the PCIE card exists, the resource does not exist, bmc ip: {}", (Object)bmcIp);
            baseInfo.setHardRaid(false);
            baseInfo.setSoftRaidDeviceLetterA("nvme1n1");
            baseInfo.setSoftRaidDeviceLetterB("nvme0n1");
            return false;
        }
        if (!response.isSuccessful() || response.body() == null) {
            log.error("failed to check whether the PCIE card exists, bmc ip: {}", (Object)bmcIp);
            throw new DeployOsException(DeployOsError.CHECK_LOGICAL_DISK);
        }
        List drives = ((Map)response.body()).getOrDefault("Drives", Collections.emptyList());
        if (drives instanceof List && (driveList = drives).size() >= 2) {
            baseInfo.setHardRaidDeviceLetter("sda");
            return true;
        }
        baseInfo.setHardRaid(false);
        baseInfo.setSoftRaidDeviceLetterA("nvme1n1");
        baseInfo.setSoftRaidDeviceLetterB("nvme0n1");
        return false;
    }

    private boolean waitTaskComplete(Map<String, Object> body, String bmcIp) {
        String taskId = Optional.ofNullable(body).map(maps -> maps.get("Id")).map(String::valueOf).orElse("");
        if (StringUtils.isEmpty((CharSequence)taskId)) {
            log.error("wait task finish, taskId is empty.");
            return false;
        }
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < 600000L) {
            Optional<String> opTaskStatus = this.checkTaskStatus(taskId, bmcIp);
            if (!opTaskStatus.isPresent() || TaskState.isTaskRunning(opTaskStatus.get())) {
                ThreadUtils.threadSafeSleep((int)5, (TimeUnit)TimeUnit.SECONDS);
                continue;
            }
            log.info("wait task finish, state : {}.", opTaskStatus);
            return TaskState.isTaskSuccessfully(opTaskStatus.get());
        }
        log.error("wait task finish timeout.");
        return false;
    }

    private Optional<String> checkTaskStatus(String taskId, String bmcIp) {
        Response response;
        try {
            response = this.requestApi.getTaskProgress(taskId, this.defaultBmcHeaders).execute();
        }
        catch (IOException e) {
            log.error("failed to query task progress, bmc ip: {} . {}", (Object)bmcIp, (Object)e);
            return Optional.empty();
        }
        if (response.code() == 404) {
            log.info("failed to query task progress, the resource does not exist, bmc ip: {}", (Object)bmcIp);
            return Optional.empty();
        }
        if (!response.isSuccessful() || response.body() == null) {
            log.error("failed to query task progress, bmc ip: {}", (Object)bmcIp);
            return Optional.empty();
        }
        return Optional.of(response.body()).map(maps -> maps.get("TaskState")).map(String::valueOf);
    }

    private boolean deleteLocalDisk(OsDeployBaseInfo baseInfo, RaidNodeInfo raidNodeInfo) {
        Response response;
        String bmcIp = baseInfo.getBmcIp();
        try {
            response = this.requestApi.deleteLogicalDiskRaid(raidNodeInfo.getSystemId(), raidNodeInfo.getRaidId(), raidNodeInfo.getLogicalDiskId(), this.defaultBmcHeaders).execute();
        }
        catch (IOException e) {
            log.error("delete logical disk fail, bmc ip: {}", (Object)bmcIp, (Object)e);
            return false;
        }
        if (response.code() == 404) {
            log.info("have not logical disk 0, can create logical disk");
            return true;
        }
        if (!response.isSuccessful() || response.body() == null) {
            log.error("delete logical disk fail or body null, bmc ip: {}", (Object)bmcIp);
            return false;
        }
        return this.waitTaskComplete((Map)response.body(), bmcIp);
    }

    private boolean setRaid(OsDeployBaseInfo baseInfo, RaidNodeInfo raidNodeInfo) {
        int index = 0;
        boolean isPass = false;
        while (!isPass && index <= 2) {
            ThreadUtils.threadSafeSleep((int)(90 * ++index), (TimeUnit)TimeUnit.SECONDS);
            isPass = this.createLogicalDisk(baseInfo, raidNodeInfo);
            if (isPass) continue;
            this.updateSystemBasicRaidInfo(raidNodeInfo);
            this.deleteLocalDisk(baseInfo, raidNodeInfo);
        }
        return isPass;
    }

    private boolean createLogicalDisk(OsDeployBaseInfo baseInfo, RaidNodeInfo raidNodeInfo) {
        Response response;
        String bmcIp = baseInfo.getBmcIp();
        try {
            CreateLogicalDiskRaidParamsVo params = this.makeCreateLogicBody(raidNodeInfo);
            response = this.requestApi.createLogicalDiskRaid(raidNodeInfo.getSystemId(), raidNodeInfo.getRaidId(), this.defaultBmcHeaders, params).execute();
        }
        catch (IOException e) {
            log.error("create logical disk fail, bmc ip: {}", (Object)bmcIp, (Object)e);
            return false;
        }
        if (!response.isSuccessful() || response.body() == null) {
            log.error("create logical disk fail or body null, bmc ip: {}", (Object)bmcIp);
            return false;
        }
        return this.waitTaskComplete((Map)response.body(), bmcIp);
    }

    private CreateLogicalDiskRaidParamsVo makeCreateLogicBody(RaidNodeInfo raidNodeInfo) {
        HashMap<String, CreateLogicalDiskRaidOemParamsVo> map = new HashMap<String, CreateLogicalDiskRaidOemParamsVo>();
        CreateLogicalDiskRaidOemParamsVo vo = this.assembler.toOemVo(raidNodeInfo);
        vo.setDrives(raidNodeInfo.getDrives());
        map.put(raidNodeInfo.getServerModel(), vo);
        return new CreateLogicalDiskRaidParamsVo().setOem(map).setCapacityBytes(raidNodeInfo.getCapacityBytes()).setOptimumIOSizeBytes(raidNodeInfo.getOptimumIOSizeBytes());
    }

    private Optional<String> getLocalDisk(RaidNodeInfo raidNodeInfo) {
        Response response;
        try {
            response = this.requestApi.getLogicalDiskRaid(raidNodeInfo.getSystemId(), raidNodeInfo.getRaidId(), raidNodeInfo.getLogicalDiskId(), this.defaultBmcHeaders).execute();
        }
        catch (IOException e) {
            log.error("get local disk info failed", (Throwable)e);
            return Optional.empty();
        }
        if (!response.isSuccessful()) {
            log.error("get local disk info failed,current code {}", (Object)response.code());
            return Optional.empty();
        }
        return Optional.of(response.headers()).map(headers -> headers.get("ETag")).filter(StringUtils::isNotBlank);
    }

    private boolean updateLocalDisk(OsDeployBaseInfo baseInfo, RaidNodeInfo raidNodeInfo, String eTag) {
        Response response;
        UpdateLogicalDiskParamsVo vo = new UpdateLogicalDiskParamsVo();
        vo.getOem().put(raidNodeInfo.getServerModel(), new UpdateLogicalDiskOemParamsVo());
        Map<String, String> headers = this.getUpdateLocalDiskPatchHeader(eTag);
        String bmcIp = baseInfo.getBmcIp();
        try {
            response = this.requestApi.updateLogicalDiskRaid(raidNodeInfo.getSystemId(), raidNodeInfo.getRaidId(), raidNodeInfo.getLogicalDiskId(), headers, vo).execute();
        }
        catch (IOException e) {
            log.error("update logical disk fail, bmc ip: {}", (Object)bmcIp, (Object)e);
            return false;
        }
        if (!response.isSuccessful()) {
            log.error("update logical disk fail, bmc ip: {}", (Object)bmcIp);
            return false;
        }
        return true;
    }

    @NotNull
    private Map<String, String> getUpdateLocalDiskPatchHeader(String eTag) {
        HashMap<String, String> headers = new HashMap<String, String>(this.defaultBmcHeaders);
        headers.put("If-Match", eTag);
        return headers;
    }

    @Generated
    protected SetRaidTask(SetRaidTaskBuilder<?, ?> b) {
        super(b);
    }

    @Generated
    public static SetRaidTaskBuilder<?, ?> builder() {
        return new SetRaidTaskBuilderImpl();
    }

    @Generated
    private static final class SetRaidTaskBuilderImpl
    extends SetRaidTaskBuilder<SetRaidTask, SetRaidTaskBuilderImpl> {
        @Generated
        private SetRaidTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected SetRaidTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public SetRaidTask build() {
            return new SetRaidTask(this);
        }
    }

    @Generated
    public static abstract class SetRaidTaskBuilder<C extends SetRaidTask, B extends SetRaidTaskBuilder<C, B>>
    extends BasicBmcSubTask.BasicBmcSubTaskBuilder<C, B> {
        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "SetRaidTask.SetRaidTaskBuilder(super=" + super.toString() + ")";
        }
    }
}

