/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.os.utils;

import com.huawei.yinglong.river.sitedeployment.dcs.os.exception.DeployOsError;
import com.huawei.yinglong.river.sitedeployment.dcs.os.exception.DeployOsException;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ThreadUtils;
import java.time.LocalDateTime;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.function.Supplier;
import lombok.Generated;

public final class CommonRetryUtils {
    private static final int INTERVAL_SECOND = 10;

    public static void retry(Supplier<Boolean> producer, int timeout, TimeUnit timeUnit) {
        CommonRetryUtils.retry(producer, result -> result, timeout, timeUnit);
    }

    public static <T> T retry(Supplier<T> producer, Predicate<T> stopCondition, int timeout, TimeUnit timeUnit) {
        return CommonRetryUtils.retry(producer, stopCondition, timeout, timeUnit, 10);
    }

    public static <T> T retry(Supplier<T> producer, Predicate<T> stopCondition, int timeout, TimeUnit timeUnit, int intervalSeconds) {
        T result = producer.get();
        LocalDateTime timeLimit = LocalDateTime.now().plusSeconds(timeUnit.toSeconds(timeout));
        while (!stopCondition.test(result)) {
            if (timeLimit.isBefore(LocalDateTime.now())) {
                throw new DeployOsException(DeployOsError.TASK_TIMEOUT);
            }
            ThreadUtils.threadSafeSleep((int)intervalSeconds, (TimeUnit)TimeUnit.SECONDS);
            result = producer.get();
        }
        return result;
    }

    @Generated
    private CommonRetryUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

