/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.os.utils;

import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.SshException;
import com.huawei.yinglong.river.sitedeployment.dcs.os.config.DeployOsConfigUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.os.exception.DeployOsError;
import com.huawei.yinglong.river.sitedeployment.dcs.os.exception.DeployOsException;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshConnInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshManager;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ThreadUtils;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SshIpCheckUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SshIpCheckUtils.class);

    public static void checkIpSshConnected(String ip, String username, String pwd, Consumer<String> consumer) {
        if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{ip, username, pwd})) {
            log.error("check ip by ssh, ip, name or pwd is empty. ip = {}, usename = {}.", (Object)ip, (Object)username);
            return;
        }
        log.info("start to check ip:{},username:{} by ssh.", (Object)ip, (Object)username);
        consumer.accept(StringUtils.formatTxt((String)"start to check ip:%s,username:%s by ssh.", (Object[])new Object[]{ip, username}));
        int waitTimeout = DeployOsConfigUtils.getRebootWaitTime();
        for (int tryCount = 0; tryCount < waitTimeout; ++tryCount) {
            if (SshIpCheckUtils.tryToConnectOsBySsh(ip, username, pwd)) {
                log.info("check ip by ssh, ssh collect success.");
                consumer.accept("Check ip by ssh, ssh collect success. The iso installation is complete.");
                return;
            }
            consumer.accept(StringUtils.formatTxt((String)"iso is still being installed, please waiting...", (Object[])new Object[0]));
            ThreadUtils.threadSafeSleep((int)1, (TimeUnit)TimeUnit.MINUTES);
        }
        log.error("check ip by ssh [{}] timeout.", (Object)ip);
        consumer.accept(StringUtils.formatTxt((String)"check ip by ssh [%s] timeout.", (Object[])new Object[]{ip}));
        throw new DeployOsException(DeployOsError.INSTALL_TIMEOUT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean tryToConnectOsBySsh(String ip, String username, String pwd) {
        boolean bl;
        SshConnInfo connInfo = null;
        try {
            connInfo = SshConnInfo.builder().hostName(ip).userName(username).userPwd(pwd).build();
            bl = SshManager.isConnected((SshConnInfo)connInfo);
        }
        catch (SshException e) {
            try {
                log.warn("try to connect os failed, {}: {}.", (Object)ip, (Object)e.getErrorMessage());
            }
            catch (Throwable throwable) {
                SshManager.releaseSession(connInfo);
                throw throwable;
            }
            SshManager.releaseSession((SshConnInfo)connInfo);
            return false;
        }
        SshManager.releaseSession((SshConnInfo)connInfo);
        return bl;
    }

    @Generated
    private SshIpCheckUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

