/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.impl.NatsMessage;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;

public class NatsJetStreamMetaData {
    private static final long NANO_FACTOR = 1000000000L;
    private final String prefix;
    private final String domain;
    private final String accountHash;
    private final String stream;
    private final String consumer;
    private final long delivered;
    private final long streamSeq;
    private final long consumerSeq;
    private final ZonedDateTime timestamp;
    private final long pending;

    public String toString() {
        return "NatsJetStreamMetaData{prefix='" + this.prefix + '\'' + "domain='" + this.domain + '\'' + ", stream='" + this.stream + '\'' + ", consumer='" + this.consumer + '\'' + ", delivered=" + this.delivered + ", streamSeq=" + this.streamSeq + ", consumerSeq=" + this.consumerSeq + ", timestamp=" + this.timestamp + ", pending=" + this.pending + '}';
    }

    public NatsJetStreamMetaData(NatsMessage natsMessage) {
        boolean hasDomainAndHash;
        boolean hasPending;
        int streamIndex;
        if (!natsMessage.isJetStream()) {
            throw new IllegalArgumentException(this.notAJetStreamMessage(natsMessage.getReplyTo()));
        }
        String[] parts = natsMessage.getReplyTo().split("\\.");
        if (parts.length < 8 || !"ACK".equals(parts[1])) {
            throw new IllegalArgumentException(this.notAJetStreamMessage(natsMessage.getReplyTo()));
        }
        if (parts.length == 8) {
            streamIndex = 2;
            hasPending = false;
            hasDomainAndHash = false;
        } else if (parts.length == 9) {
            streamIndex = 2;
            hasPending = true;
            hasDomainAndHash = false;
        } else if (parts.length >= 11) {
            streamIndex = 4;
            hasPending = true;
            hasDomainAndHash = true;
        } else {
            throw new IllegalArgumentException(this.notAJetStreamMessage(natsMessage.getReplyTo()));
        }
        try {
            this.prefix = parts[0];
            this.domain = hasDomainAndHash ? parts[2] : null;
            this.accountHash = hasDomainAndHash ? parts[3] : null;
            this.stream = parts[streamIndex];
            this.consumer = parts[streamIndex + 1];
            this.delivered = Long.parseLong(parts[streamIndex + 2]);
            this.streamSeq = Long.parseLong(parts[streamIndex + 3]);
            this.consumerSeq = Long.parseLong(parts[streamIndex + 4]);
            long tsi = Long.parseLong(parts[streamIndex + 5]);
            long seconds = tsi / 1000000000L;
            int nanos = (int)(tsi - tsi / 1000000000L * 1000000000L);
            LocalDateTime ltd = LocalDateTime.ofEpochSecond(seconds, nanos, OffsetDateTime.now().getOffset());
            this.timestamp = ZonedDateTime.of(ltd, ZoneId.systemDefault());
            this.pending = hasPending ? Long.parseLong(parts[streamIndex + 6]) : -1L;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(this.notAJetStreamMessage(natsMessage.getReplyTo()));
        }
    }

    public String getDomain() {
        return this.domain;
    }

    public String getStream() {
        return this.stream;
    }

    public String getConsumer() {
        return this.consumer;
    }

    public long deliveredCount() {
        return this.delivered;
    }

    public long streamSequence() {
        return this.streamSeq;
    }

    public long consumerSequence() {
        return this.consumerSeq;
    }

    public long pendingCount() {
        return this.pending;
    }

    public ZonedDateTime timestamp() {
        return this.timestamp;
    }

    String getAccountHash() {
        return this.accountHash;
    }

    private String notAJetStreamMessage(String reply) {
        return "Message is not a JetStream message.  ReplySubject: <" + reply + ">";
    }
}

