/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.variable.serializer.jpa;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.persistence.Entity;
import javax.persistence.Id;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.variable.serializer.jpa.EntityMetaData;

public class JPAEntityScanner {
    public EntityMetaData scanClass(Class<?> clazz) {
        EntityMetaData metaData = new EntityMetaData();
        metaData.setEntityClass(clazz);
        boolean isEntity = this.isEntityAnnotationPresent(clazz);
        metaData.setJPAEntity(isEntity);
        if (isEntity) {
            Field idField = this.getIdField(clazz);
            if (idField != null) {
                metaData.setIdField(idField);
            } else {
                Method idMethod = this.getIdMethod(clazz);
                if (idMethod != null) {
                    metaData.setIdMethod(idMethod);
                } else {
                    throw new ProcessEngineException("Cannot find field or method with annotation @Id on class '" + clazz.getName() + "', only single-valued primary keys are supported on JPA-enities");
                }
            }
        }
        return metaData;
    }

    private Method getIdMethod(Class<?> clazz) {
        Method idMethod = null;
        Method[] methods = clazz.getMethods();
        Id idAnnotation = null;
        for (Method method : methods) {
            idAnnotation = method.getAnnotation(Id.class);
            if (idAnnotation == null) continue;
            idMethod = method;
            break;
        }
        return idMethod;
    }

    private Field getIdField(Class<?> clazz) {
        Class<?> superClass;
        Field idField = null;
        Field[] fields = clazz.getDeclaredFields();
        Id idAnnotation = null;
        for (Field field : fields) {
            idAnnotation = field.getAnnotation(Id.class);
            if (idAnnotation == null) continue;
            idField = field;
            break;
        }
        if (idField == null && (superClass = clazz.getSuperclass()) != null && !superClass.equals(Object.class)) {
            idField = this.getIdField(superClass);
        }
        return idField;
    }

    private boolean isEntityAnnotationPresent(Class<?> clazz) {
        return clazz.getAnnotation(Entity.class) != null;
    }
}

