/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.ebackup.fit.impl;

import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.river.deploy.virtualization.common.entity.DeployTaskInfoVo;
import com.huawei.yinglong.river.deploy.virtualization.deployebackup.entity.EbackupParams;
import com.huawei.yinglong.river.deploy.virtualization.deployebackup.entity.PortGroupInfo;
import com.huawei.yinglong.river.deploy.virtualization.deployebackup.entity.SwitchInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.constant.TaskOperateEnum;
import com.huawei.yinglong.river.sitedeployment.dcs.ebackup.assembler.EbackupAssembler;
import com.huawei.yinglong.river.sitedeployment.dcs.ebackup.exception.EBackUpError;
import com.huawei.yinglong.river.sitedeployment.dcs.ebackup.exception.EBackUpkException;
import com.huawei.yinglong.river.sitedeployment.dcs.ebackup.fit.entity.DeployEbackupParams;
import com.huawei.yinglong.river.sitedeployment.dcs.ebackup.task.DeployEBackUpTask;
import com.huawei.yinglong.river.sitedeployment.dcs.ebackup.task.EBackTaskContext;
import com.huawei.yinglong.river.sitedeployment.dcs.ebackup.task.EBackupTaskFactory;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.client.ApiClient;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.base.FcLoginInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.base.FcEntityBase;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.net.dvswitch.DvSwitch;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.service.FcClientService;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.CommonTaskManager;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ResponseUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.exception.ErrorDetail;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.mapstruct.factory.Mappers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DeployEbackupFitImpl {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeployEbackupFitImpl.class);
    private final EbackupAssembler assembler = (EbackupAssembler)Mappers.getMapper(EbackupAssembler.class);

    public Response<String> validEbackupParams(EbackupParams ebackupParams) {
        DeployEbackupParams deployEbackupParams = this.assembler.toValidParams(ebackupParams);
        List<String> invalidTips = deployEbackupParams.validate(0, new Class[0]);
        if (invalidTips != null && !invalidTips.isEmpty()) {
            return ResponseUtils.success((Object)String.join((CharSequence)"\uff1b", invalidTips));
        }
        return ResponseUtils.success((Object)"");
    }

    public Response<Boolean> updateEbackupParams(EbackupParams ebackupParams) {
        log.info("start update ebackup params");
        if (!EBackupTaskFactory.isUpdateTaskParamSuccess(ebackupParams)) {
            log.error("ebackup params update failed");
            return ResponseUtils.failed((Object)false);
        }
        EBackTaskContext.getInstance().setEbackupParams(ebackupParams);
        return ResponseUtils.success((Object)true);
    }

    public Response<Boolean> startDeployEbackup(EbackupParams ebackupParams) {
        log.info("start deploy ebackup");
        EBackTaskContext.reset();
        EBackTaskContext.getInstance().setEbackupParams(ebackupParams);
        CommonTaskManager taskManager = CommonTaskManager.getInstance();
        DeployEBackUpTask task = EBackupTaskFactory.createEBackUpTask(ebackupParams);
        taskManager.addTask((BaseTask)task);
        if (taskManager.startTaskById(task.getTaskId())) {
            return ResponseUtils.success((Object)true);
        }
        log.error("start deploy ebackup task [{}] failed", (Object)ebackupParams.getTaskId());
        return ResponseUtils.failed((Object)false);
    }

    public Response<Boolean> skipItem(String itemId) {
        log.info("start skip ebackup task [{}]", (Object)itemId);
        return this.handleRetrySkipCommonResponse(CommonTaskManager.getInstance().skipSubTaskById(itemId), itemId, TaskOperateEnum.SKIP);
    }

    public Response<Boolean> retryItem(String itemId) {
        log.info("start retry ebackup sub task [{}]", (Object)itemId);
        return this.handleRetrySkipCommonResponse(CommonTaskManager.getInstance().retrySubTaskById(itemId), itemId, TaskOperateEnum.RETRY);
    }

    public Response<DeployTaskInfoVo> queryDeployDetails(String taskId) {
        log.info("query ebackup task [{}]", (Object)taskId);
        Optional deployTaskInfoVo = CommonTaskManager.getInstance().queryTaskDetailById(taskId);
        return deployTaskInfoVo.map(ResponseUtils::success).orElse(ResponseUtils.failed((Object)DeployTaskInfoVo.builder().build()));
    }

    public Response<Boolean> retryAllItems(String taskId) {
        log.info("start retry ebackup task [{}]", (Object)taskId);
        return this.handleRetrySkipCommonResponse(CommonTaskManager.getInstance().retryAllTaskById(taskId), taskId, TaskOperateEnum.RETRY);
    }

    public Response<PortGroupInfo> queryAllPortGroup() {
        Optional<FcLoginInfo> fcLoginInfo = Optional.ofNullable(EBackTaskContext.getInstance().getEbackupParams()).map(EbackupParams::getFusionComputeInfo).map(this.assembler::toFusionCompute);
        if (!fcLoginInfo.isPresent()) {
            return ResponseUtils.failed((ErrorDetail)new EBackUpkException(EBackUpError.PARAM_ERROR));
        }
        return ResponseUtils.success((Object)PortGroupInfo.builder().switchInfo(this.getAllSwitchInfo(fcLoginInfo.get())).build());
    }

    private List<SwitchInfo> getAllSwitchInfo(FcLoginInfo fcLoginInfo) {
        ApiClient apiService = FcClientService.createApiService((FcLoginInfo)fcLoginInfo);
        List dvSwitchList = apiService.getDvSwitches();
        if (CollectionUtils.isEmpty((Collection)dvSwitchList)) {
            return Collections.emptyList();
        }
        return dvSwitchList.stream().map(this::buildSwitchInfo).collect(Collectors.toList());
    }

    private SwitchInfo buildSwitchInfo(DvSwitch dvSwitch) {
        return SwitchInfo.builder().switchName(dvSwitch.getName()).portGroupNames(dvSwitch.getPortGroups().stream().map(FcEntityBase::getName).collect(Collectors.toList())).build();
    }

    private Response<Boolean> handleRetrySkipCommonResponse(boolean isSuccess, String taskId, TaskOperateEnum operateEnum) {
        if (!isSuccess) {
            log.error("{} ebackup task [{}] failed", (Object)operateEnum.name(), (Object)taskId);
            return ResponseUtils.failed((Object)false);
        }
        return ResponseUtils.success((Object)true);
    }
}

