/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.ebackup.fit.utils;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.huawei.yinglong.river.sitedeployment.dcs.consistency.ConsistencyPattern;
import com.huawei.yinglong.river.sitedeployment.dcs.ebackup.fit.entity.DeployEbackupParams;
import com.huawei.yinglong.river.sitedeployment.dcs.ebackup.fit.entity.DeployEbackupServerInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.ebackup.fit.entity.DeployEbackupVmInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.ebackup.fit.entity.DeployEbackupVmPlane;
import com.huawei.yinglong.river.sitedeployment.dcs.ebackup.fit.entity.DeployFusionComputeInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.ebackup.utils.TaskResourceUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.task.CommonTaskManager;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.IpUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ValidationUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ValidationUtils.class);

    public static List<String> validateParams(DeployEbackupParams ebackupParams) {
        LinkedList<String> validResults = new LinkedList<String>();
        ValidationUtils.validTemplateFileExist(ebackupParams).ifPresent(validResults::add);
        validResults.addAll(ValidationUtils.validAllEbackupVmInfo(ebackupParams));
        return validResults;
    }

    private static Optional<String> validTemplateFileExist(DeployEbackupParams ebackupParams) {
        if (Objects.isNull(ebackupParams.getTemplateInfo())) {
            return Optional.empty();
        }
        String templateFilePath = ebackupParams.getTemplateInfo().getTemplateFile();
        if (StringUtils.isEmpty((CharSequence)templateFilePath)) {
            return Optional.empty();
        }
        File templateFile = new File(templateFilePath);
        if (!templateFile.exists() || !ConsistencyPattern.isMatchEbackupTemplateFile((String)templateFile.getName())) {
            return Optional.of(TaskResourceUtils.getString("error.validation.template.file.not.exist"));
        }
        return Optional.empty();
    }

    private static List<String> validAllEbackupVmInfo(DeployEbackupParams ebackupParams) {
        List<DeployEbackupVmInfo> vmInfos = ebackupParams.getEbackupVmInfo();
        if (CollectionUtils.isEmpty(vmInfos) || vmInfos.size() > 2) {
            return Collections.singletonList(TaskResourceUtils.getString("error.validation.vm.num.invalid"));
        }
        boolean isDoubleDeploy = vmInfos.size() == 2;
        ArrayListMultimap ipMultimap = ArrayListMultimap.create();
        ValidationUtils.initFloatIpToMultimap(ebackupParams, (Multimap<String, String>)ipMultimap);
        List<String> validResults = vmInfos.stream().map(arg_0 -> ValidationUtils.lambda$validAllEbackupVmInfo$0(isDoubleDeploy, (Multimap)ipMultimap, ebackupParams, arg_0)).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        ipMultimap.keySet().stream().filter(StringUtils::isNotEmpty).map(arg_0 -> ((Multimap)ipMultimap).get(arg_0)).forEach(ipNames -> {
            if (CollectionUtils.isNotEmpty((Collection)ipNames) && ipNames.size() > 1) {
                validResults.add(TaskResourceUtils.getString("error.validation.vm.ip.repeated", String.join((CharSequence)",", ipNames)));
            }
        });
        if (isDoubleDeploy) {
            validResults.addAll(ValidationUtils.validUnionEbackupVmInfo(vmInfos));
        }
        return validResults;
    }

    private static void initFloatIpToMultimap(DeployEbackupParams ebackupParams, Multimap<String, String> ipMultimap) {
        Optional.ofNullable(ebackupParams.getFusionComputeInfo()).map(DeployFusionComputeInfo::getFloatIp).filter(StringUtils::isNotEmpty).ifPresent(floatIp -> ipMultimap.put(floatIp, (Object)TaskResourceUtils.getString("fusionComputeInfo.floatIp")));
        ebackupParams.getEbackupVmInfo().stream().findFirst().ifPresent(vmInfo -> Optional.ofNullable(vmInfo.getInnerPlane()).map(DeployEbackupVmPlane::getInnerFloatIp).filter(StringUtils::isNotEmpty).ifPresent(floatIp -> ipMultimap.put(floatIp, (Object)TaskResourceUtils.getString("ebackupVmInfo.innerPlane.innerFloatIp", vmInfo.getName()))));
    }

    private static List<String> validUnionEbackupVmInfo(List<DeployEbackupVmInfo> vmInfos) {
        Optional<DeployEbackupVmInfo> opVmServerInfo = vmInfos.stream().filter(vmInfo -> Objects.equals(vmInfo.getRole(), "server")).findFirst();
        Optional<DeployEbackupVmInfo> opVmProxyInfo = vmInfos.stream().filter(vmInfo -> Objects.equals(vmInfo.getRole(), "proxy")).findFirst();
        if (!opVmServerInfo.isPresent() || !opVmProxyInfo.isPresent()) {
            return Collections.singletonList(TaskResourceUtils.getString("error.validation.double.role.invalid"));
        }
        LinkedList<String> validResults = new LinkedList<String>();
        DeployEbackupVmInfo vmServerInfo = opVmServerInfo.get();
        DeployEbackupVmInfo vmProxyInfo = opVmProxyInfo.get();
        DeployEbackupServerInfo serverInfo = vmProxyInfo.getEbackupServerInfo();
        if (vmServerInfo.getInnerPlane() != null && vmProxyInfo.getInnerPlane() != null && !Objects.equals(vmServerInfo.getInnerPlane().getInnerFloatIp(), vmProxyInfo.getInnerPlane().getInnerFloatIp())) {
            validResults.add(TaskResourceUtils.getString("error.validation.double.inner.plant.float.not.equal"));
        }
        if (serverInfo != null && vmServerInfo.getManagePlane() != null) {
            if (!Objects.equals(serverInfo.getManageIp(), vmServerInfo.getInnerPlane().getManageIp())) {
                validResults.add(TaskResourceUtils.getString("error.validation.double.proxy.server.manage.ip.not.equal"));
            }
            if (!Objects.equals(serverInfo.getHcpPassword(), vmServerInfo.getHcpPassword())) {
                validResults.add(TaskResourceUtils.getString("error.validation.double.proxy.server.hcp.password.not.equal"));
            }
            if (!Objects.equals(serverInfo.getRootPassword(), vmServerInfo.getRootPassword())) {
                validResults.add(TaskResourceUtils.getString("error.validation.double.proxy.server.root.password.not.equal"));
            }
        }
        return validResults;
    }

    private static List<String> validEachEbackupVmInfo(DeployEbackupVmInfo ebackupVmInfo, boolean isDoubleDeploy, Multimap<String, String> ipMultimap, String taskId) {
        LinkedList<String> validResults = new LinkedList<String>();
        LinkedList ipCheckedVmPlanes = new LinkedList();
        ValidationUtils.validEachVmServerInfo(ebackupVmInfo, validResults, isDoubleDeploy, taskId).ifPresent(ip -> ipMultimap.put(ip, (Object)TaskResourceUtils.getString("ebackupVmInfo.ebackupServerInfo.manageIp", ebackupVmInfo.getName())));
        ValidationUtils.validEachVmManagePlane(ebackupVmInfo, validResults, taskId).filter(ip -> ValidationUtils.checkVmPlaneIsNotUsedSamePlane(ipCheckedVmPlanes, ebackupVmInfo.getManagePlane())).ifPresent(ip -> ipMultimap.put(ip, (Object)TaskResourceUtils.getString("ebackupVmInfo.managePlane.manageIp", ebackupVmInfo.getName())));
        ValidationUtils.validEachVmInnerPlane(ebackupVmInfo, validResults, isDoubleDeploy, taskId).filter(ip -> ValidationUtils.checkVmPlaneIsNotUsedSamePlane(ipCheckedVmPlanes, ebackupVmInfo.getInnerPlane())).ifPresent(ip -> ipMultimap.put(ip, (Object)TaskResourceUtils.getString("ebackupVmInfo.innerPlane.manageIp", ebackupVmInfo.getName())));
        ValidationUtils.validEachVmProductionPlane(ebackupVmInfo, validResults, taskId).filter(ip -> ValidationUtils.checkVmPlaneIsNotUsedSamePlane(ipCheckedVmPlanes, ebackupVmInfo.getProductionPlane())).ifPresent(ip -> ipMultimap.put(ip, (Object)TaskResourceUtils.getString("ebackupVmInfo.productionPlane.manageIp", ebackupVmInfo.getName())));
        ValidationUtils.validEachVmBackupPlane(ebackupVmInfo, validResults, taskId).filter(ip -> ValidationUtils.checkVmPlaneIsNotUsedSamePlane(ipCheckedVmPlanes, ebackupVmInfo.getBackupPlane())).ifPresent(ip -> ipMultimap.put(ip, (Object)TaskResourceUtils.getString("ebackupVmInfo.backupPlane.manageIp", ebackupVmInfo.getName())));
        Map<String, List<DeployEbackupVmPlane>> vmPlaneByGroupName = ipCheckedVmPlanes.stream().collect(Collectors.groupingBy(DeployEbackupVmPlane::getPortGroupName));
        ValidationUtils.validSegmentGroupNameIP(vmPlaneByGroupName, validResults);
        return validResults;
    }

    private static void validSegmentGroupNameIP(Map<String, List<DeployEbackupVmPlane>> vmPlaneByGroupName, List<String> validResults) {
        for (Map.Entry<String, List<DeployEbackupVmPlane>> groupNameNetMaskEntry : vmPlaneByGroupName.entrySet()) {
            String groupName = groupNameNetMaskEntry.getKey();
            if (StringUtils.isEmpty((CharSequence)groupName)) {
                return;
            }
            List<DeployEbackupVmPlane> value = groupNameNetMaskEntry.getValue();
            if (value.size() <= 1) continue;
            HashSet result = new HashSet();
            value.stream().forEach(deployEbackupVmPlane -> ValidationUtils.computeIpValue(result, deployEbackupVmPlane));
            if (result.size() >= value.size()) continue;
            validResults.add(TaskResourceUtils.getString("error.validation.group.mask.same.ip.info", groupName));
        }
    }

    private static void computeIpValue(Set<Integer> result, DeployEbackupVmPlane deployEbackupVmPlane) {
        try {
            if (!IpUtils.isValidIpV4((String)deployEbackupVmPlane.getManageIp()) || !IpUtils.isValidIpV4((String)deployEbackupVmPlane.getNetmask())) {
                return;
            }
            result.add(ValidationUtils.transferIpToInt(deployEbackupVmPlane.getManageIp()) & ValidationUtils.transferIpToInt(deployEbackupVmPlane.getNetmask()));
        }
        catch (UnknownHostException e) {
            log.error("check ip v4 is failed.", (Throwable)e);
        }
    }

    private static int transferIpToInt(String ipAddress) throws UnknownHostException {
        return ByteBuffer.wrap(InetAddress.getByName(ipAddress).getAddress()).getInt();
    }

    private static boolean checkVmPlaneIsNotUsedSamePlane(List<DeployEbackupVmPlane> ipCheckedVmPlanes, DeployEbackupVmPlane checkVmPlane) {
        if (ipCheckedVmPlanes.stream().noneMatch(vmPlane -> vmPlane.isUseSamePlane(checkVmPlane))) {
            ipCheckedVmPlanes.add(checkVmPlane);
            return true;
        }
        return false;
    }

    private static Optional<String> validEachVmBackupPlane(DeployEbackupVmInfo ebackupVmInfo, List<String> validResults, String taskId) {
        DeployEbackupVmPlane backupPlane = ebackupVmInfo.getBackupPlane();
        if (Objects.isNull(backupPlane)) {
            return Optional.empty();
        }
        if (ValidationUtils.isNeedCheckReachable(taskId, backupPlane.getManageIp())) {
            validResults.add(TaskResourceUtils.getString("error.validation.backup.plane.manage.ip.reachable", ebackupVmInfo.getName()));
        }
        if (StringUtils.isNotEmpty((CharSequence)backupPlane.getTargetNetwork()) && StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{backupPlane.getTargetNetmask(), backupPlane.getTargetGateway()})) {
            validResults.add(TaskResourceUtils.getString("error.validation.backup.plane.target.network.invalid", ebackupVmInfo.getName()));
        }
        return Optional.ofNullable(backupPlane.getManageIp());
    }

    private static Optional<String> validEachVmProductionPlane(DeployEbackupVmInfo ebackupVmInfo, List<String> validResults, String taskId) {
        DeployEbackupVmPlane productionPlane = ebackupVmInfo.getProductionPlane();
        if (Objects.isNull(productionPlane)) {
            return Optional.empty();
        }
        if (ValidationUtils.isNeedCheckReachable(taskId, productionPlane.getManageIp())) {
            validResults.add(TaskResourceUtils.getString("error.validation.production.plane.manage.ip.reachable", ebackupVmInfo.getName()));
        }
        if (StringUtils.isNotEmpty((CharSequence)productionPlane.getTargetNetwork()) && StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{productionPlane.getTargetNetmask(), productionPlane.getTargetGateway()})) {
            validResults.add(TaskResourceUtils.getString("error.validation.production.plane.target.network.invalid", ebackupVmInfo.getName()));
        }
        return Optional.ofNullable(productionPlane.getManageIp());
    }

    private static Optional<String> validEachVmInnerPlane(DeployEbackupVmInfo ebackupVmInfo, List<String> validResults, boolean isDoubleDeploy, String taskId) {
        DeployEbackupVmPlane innerPlane = ebackupVmInfo.getInnerPlane();
        if (Objects.isNull(innerPlane)) {
            return Optional.empty();
        }
        if (StringUtils.isEmpty((CharSequence)innerPlane.getInnerFloatIp())) {
            validResults.add(TaskResourceUtils.getString("error.validation.inner.plane.float.ip.not.exist", ebackupVmInfo.getName()));
        } else if (IpUtils.isValidIpV4((String)innerPlane.getInnerFloatIp())) {
            if (isDoubleDeploy && ValidationUtils.isNeedCheckReachable(taskId, innerPlane.getInnerFloatIp())) {
                validResults.add(TaskResourceUtils.getString("error.validation.inner.plane.float.ip.reachable", ebackupVmInfo.getName()));
            }
            if (!isDoubleDeploy && Objects.equals(ebackupVmInfo.getRole(), "server") && ValidationUtils.isNeedCheckReachable(taskId, innerPlane.getInnerFloatIp())) {
                validResults.add(TaskResourceUtils.getString("error.validation.inner.plane.float.ip.reachable", ebackupVmInfo.getName()));
            }
        }
        if (ValidationUtils.isNeedCheckReachable(taskId, innerPlane.getManageIp())) {
            validResults.add(TaskResourceUtils.getString("error.validation.inner.plane.manage.ip.reachable", ebackupVmInfo.getName()));
        }
        if (StringUtils.isNotEmpty((CharSequence)innerPlane.getTargetNetwork()) && StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{innerPlane.getTargetNetmask(), innerPlane.getTargetGateway()})) {
            validResults.add(TaskResourceUtils.getString("error.validation.inner.plane.target.network.invalid", ebackupVmInfo.getName()));
        }
        return Optional.ofNullable(innerPlane.getManageIp());
    }

    private static Optional<String> validEachVmManagePlane(DeployEbackupVmInfo ebackupVmInfo, List<String> validResults, String taskId) {
        DeployEbackupVmPlane managePlane = ebackupVmInfo.getManagePlane();
        if (Objects.isNull(managePlane)) {
            return Optional.empty();
        }
        if (ValidationUtils.isNeedCheckReachable(taskId, managePlane.getManageIp())) {
            validResults.add(TaskResourceUtils.getString("error.validation.manage.plane.ip.reachable", ebackupVmInfo.getName()));
        }
        if (StringUtils.isEmpty((CharSequence)managePlane.getGateway())) {
            validResults.add(TaskResourceUtils.getString("error.validation.manage.plane.gateway.not.exist", ebackupVmInfo.getName()));
        } else if (!IpUtils.isReachable((String)managePlane.getGateway())) {
            validResults.add(TaskResourceUtils.getString("error.validation.manage.plane.gateway.unreachable", ebackupVmInfo.getName()));
        }
        if (!managePlane.isUsedManagePlane()) {
            validResults.add(TaskResourceUtils.getString("error.validation.manage.plane.portgroup.invalid", ebackupVmInfo.getName()));
        }
        return Optional.ofNullable(managePlane.getManageIp());
    }

    private static Optional<String> validEachVmServerInfo(DeployEbackupVmInfo ebackupVmInfo, List<String> validResults, boolean isDoubleDeploy, String taskId) {
        if (Objects.equals(ebackupVmInfo.getRole(), "proxy")) {
            DeployEbackupServerInfo serverInfo = ebackupVmInfo.getEbackupServerInfo();
            if (Objects.isNull(serverInfo) || StringUtils.isEmpty((CharSequence)serverInfo.getManageIp())) {
                validResults.add(TaskResourceUtils.getString("error.validation.proxy.must.config.server.info", ebackupVmInfo.getName()));
                return Optional.empty();
            }
            if (isDoubleDeploy && ValidationUtils.isNeedCheckReachable(taskId, serverInfo.getManageIp())) {
                validResults.add(TaskResourceUtils.getString("error.validation.proxy.config.server.ip.reachable", ebackupVmInfo.getName()));
            }
            if (!isDoubleDeploy) {
                return Optional.ofNullable(serverInfo.getManageIp());
            }
        }
        return Optional.empty();
    }

    private static boolean isNeedCheckReachable(String taskId, String ip) {
        return !CommonTaskManager.getInstance().isTaskExecuted(taskId) && IpUtils.isReachable((String)ip);
    }

    @Generated
    private ValidationUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static /* synthetic */ List lambda$validAllEbackupVmInfo$0(boolean isDoubleDeploy, Multimap ipMultimap, DeployEbackupParams ebackupParams, DeployEbackupVmInfo vmInfo) {
        return ValidationUtils.validEachEbackupVmInfo(vmInfo, isDoubleDeploy, (Multimap<String, String>)ipMultimap, ebackupParams.getTaskId());
    }
}

