/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.ebackup.task;

import com.huawei.yinglong.river.deploy.virtualization.common.entity.TemplateInfo;
import com.huawei.yinglong.river.deploy.virtualization.deployebackup.entity.EbackupVmInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.ebackup.assembler.EbackupAssembler;
import com.huawei.yinglong.river.sitedeployment.dcs.ebackup.exception.EBackUpError;
import com.huawei.yinglong.river.sitedeployment.dcs.ebackup.exception.EBackUpkException;
import com.huawei.yinglong.river.sitedeployment.dcs.ebackup.task.EBackTaskContext;
import com.huawei.yinglong.river.sitedeployment.dcs.ebackup.utils.EbackupConfigUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.ebackup.utils.TaskResourceUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.client.ApiClient;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.base.FcLoginInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.base.FcEntityBase;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.service.FcClientService;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskStatus;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.mapstruct.factory.Mappers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatastorePortGroupCheckTask
extends BaseTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DatastorePortGroupCheckTask.class);
    public static final String NAME_KEY = "config.port.group.datastore.task.name";

    public void execute() throws TaskException {
        List<EbackupVmInfo> vmInfos = EBackTaskContext.getInstance().getVmInfos();
        if (vmInfos.stream().anyMatch(this::isAnyPlanePorGroupError)) {
            log.error("port group name not configured.");
            this.appendTaskDetail(TaskResourceUtils.getString("task.config.datastore.detail"));
            throw new EBackUpkException(EBackUpError.PORT_GROUP_ERROR, TaskStatus.PAUSE);
        }
        if (this.checkNeedSkipSelectDatastore()) {
            log.info("eBackup skip select datastore.");
            this.appendTaskDetail("eBackup skip select datastore.");
            return;
        }
        if (vmInfos.stream().anyMatch(vmInfo -> StringUtils.isEmpty((CharSequence)vmInfo.getDatastoreName()))) {
            log.error("eBackup vm datastore name not configured.");
            this.appendTaskDetail(TaskResourceUtils.getString("task.config.datastore.detail"));
            throw new EBackUpkException(EBackUpError.PORT_GROUP_ERROR, TaskStatus.PAUSE);
        }
        vmInfos.forEach(vmInfo -> this.appendTaskDetail("eBackup VM datastore is " + vmInfo.getDatastoreName()));
        TemplateInfo templateInfo = EBackTaskContext.getInstance().getTemplateInfo();
        if (StringUtils.isEmpty((CharSequence)templateInfo.getDatastoreName())) {
            log.error("eBackup template datastore name not configured.");
            this.appendTaskDetail(TaskResourceUtils.getString("task.config.datastore.detail"));
            throw new EBackUpkException(EBackUpError.PORT_GROUP_ERROR, TaskStatus.PAUSE);
        }
        this.appendTaskDetail("eBackup Template datastore is " + templateInfo.getDatastoreName());
    }

    private boolean checkNeedSkipSelectDatastore() {
        return Boolean.parseBoolean(EbackupConfigUtils.getPropertiesValue("deploy.skip.datastore.select", "false"));
    }

    private boolean isAnyPlanePorGroupError(EbackupVmInfo vmInfo) {
        Set<String> allPortGroups = this.getAllPortGroups();
        return Stream.of(vmInfo.getManagePlane(), vmInfo.getInnerPlane(), vmInfo.getProductionPlane(), vmInfo.getBackupPlane()).anyMatch(plane -> StringUtils.isEmpty((CharSequence)plane.getPortGroupName()) || !allPortGroups.contains(plane.getPortGroupName()));
    }

    private Set<String> getAllPortGroups() {
        FcLoginInfo fcLoginInfo = ((EbackupAssembler)Mappers.getMapper(EbackupAssembler.class)).toFusionCompute(EBackTaskContext.getInstance().getEbackupParams().getFusionComputeInfo());
        ApiClient apiService = FcClientService.createApiService((FcLoginInfo)fcLoginInfo);
        return apiService.getDvSwitches().stream().flatMap(dvSwitch -> dvSwitch.getPortGroups().stream()).map(FcEntityBase::getName).collect(Collectors.toSet());
    }

    @Generated
    protected DatastorePortGroupCheckTask(DatastorePortGroupCheckTaskBuilder<?, ?> b) {
        super(b);
    }

    @Generated
    public static DatastorePortGroupCheckTaskBuilder<?, ?> builder() {
        return new DatastorePortGroupCheckTaskBuilderImpl();
    }

    @Generated
    private static final class DatastorePortGroupCheckTaskBuilderImpl
    extends DatastorePortGroupCheckTaskBuilder<DatastorePortGroupCheckTask, DatastorePortGroupCheckTaskBuilderImpl> {
        @Generated
        private DatastorePortGroupCheckTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected DatastorePortGroupCheckTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public DatastorePortGroupCheckTask build() {
            return new DatastorePortGroupCheckTask(this);
        }
    }

    @Generated
    public static abstract class DatastorePortGroupCheckTaskBuilder<C extends DatastorePortGroupCheckTask, B extends DatastorePortGroupCheckTaskBuilder<C, B>>
    extends BaseTask.BaseTaskBuilder<C, B> {
        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "DatastorePortGroupCheckTask.DatastorePortGroupCheckTaskBuilder(super=" + super.toString() + ")";
        }
    }
}

