/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.ebackup.task;

import com.google.common.collect.Multimap;
import com.huawei.yinglong.river.deploy.virtualization.deployebackup.entity.EbackupServerInfo;
import com.huawei.yinglong.river.deploy.virtualization.deployebackup.entity.EbackupVmInfo;
import com.huawei.yinglong.river.deploy.virtualization.deployebackup.entity.EbackupVmPlane;
import com.huawei.yinglong.river.sitedeployment.dcs.ebackup.exception.EBackUpError;
import com.huawei.yinglong.river.sitedeployment.dcs.ebackup.exception.EBackUpkException;
import com.huawei.yinglong.river.sitedeployment.dcs.ebackup.task.EBackupTaskFactory;
import com.huawei.yinglong.river.sitedeployment.dcs.ebackup.utils.EbackupConfigUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.SshException;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshConnInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshConnService;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshErrParser;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshManager;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshShellService;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ThreadUtils;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.apache.sshd.client.session.ClientSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EBackupInitTask
extends BaseTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EBackupInitTask.class);
    public static final String NAME_KEY = "ebackup.init.%s.task.name";
    @NotNull
    private EbackupVmInfo vmInfo;

    public void execute() throws TaskException {
        SshShellService shellService;
        ClientSession session;
        block6: {
            session = null;
            shellService = null;
            try {
                session = this.tryToCreateSession().orElseThrow(() -> new EBackUpkException(EBackUpError.SSH_CONNECT_ERROR));
                shellService = this.buildConnectedShellService(session);
                Optional<ClientSession> clientSession = this.tryToModifyPwdRebuildSession(session, shellService);
                if (clientSession.isPresent()) {
                    session = clientSession.get();
                    shellService = this.buildConnectedShellService(session);
                    log.info("modify pwd success, rebuild session.");
                }
                String result = this.switchUser2Root(shellService).orElseThrow(() -> new EBackUpkException(EBackUpError.SWITCH_ROOT_ERROR));
                result = this.change2ScriptDir(shellService, result).orElseThrow(() -> new EBackUpkException(EBackUpError.TMOUT_CD_ERROR));
                result = this.execEbackupUtilitiesScript(shellService, result).orElseThrow(() -> new EBackUpkException(EBackUpError.SH_EBACKUP_CONFIG));
                result = this.configNetworkType(shellService, result).orElseThrow(() -> new EBackUpkException(EBackUpError.CONFIG_NETWORK_TYPE_ERROR));
                result = this.configVmRole(shellService, result).orElseThrow(() -> new EBackUpkException(EBackUpError.CONFIG_VM_ROLE_ERROR));
                result = this.configNetworkPlane(shellService, result).orElseThrow(() -> new EBackUpkException(EBackUpError.CONFIG_NETWORK_PLANE_ERROR));
                if (this.isVmRoleServer()) {
                    this.configServerInit(shellService, result);
                    break block6;
                }
                this.configProxyInit(shellService, result);
            }
            catch (SshException e) {
                try {
                    throw new EBackUpkException(EBackUpError.SSH_CONNECT_ERROR);
                }
                catch (Throwable throwable) {
                    SshManager.releaseConnService(shellService);
                    SshManager.releaseSession((ClientSession)session);
                    throw throwable;
                }
            }
        }
        SshManager.releaseConnService((SshConnService)shellService);
        SshManager.releaseSession((ClientSession)session);
    }

    public void update(@NotNull EbackupVmInfo vmInfo) {
        this.vmInfo = vmInfo;
    }

    private SshShellService buildConnectedShellService(ClientSession session) throws SshException {
        SshShellService shellService = SshManager.createSshShellService((ClientSession)session);
        shellService.connect();
        return shellService;
    }

    private Optional<ClientSession> tryToModifyPwdRebuildSession(ClientSession session, SshShellService shellService) throws SshException {
        ThreadUtils.threadSafeSleep((int)3, (TimeUnit)TimeUnit.SECONDS);
        String hcpDefaultInfo = this.getVmHcpDefaultInfo();
        String hcpNewPwd = this.vmInfo.getHcpPassword();
        String result = shellService.execCommand(hcpDefaultInfo);
        log.info("input default hcp info, result  = {}.", (Object)this.replaceSensitiveTexts(result, hcpDefaultInfo));
        if (StringUtils.containIgnoreCase((String)result, (String[])new String[]{"New password:"})) {
            result = shellService.execCommand(hcpNewPwd);
            log.info("input new hcp info, result = {}.", (Object)this.replaceSensitiveTexts(result, hcpNewPwd));
        }
        if (StringUtils.containIgnoreCase((String)result, (String[])new String[]{"Retype new password:"})) {
            try {
                log.info("input new hcp info again, result = {}.", (Object)this.replaceSensitiveTexts(result, hcpNewPwd));
                shellService.execCommand(hcpNewPwd);
            }
            catch (SshException e) {
                log.warn("change info succeed, try to create session again.");
                SshManager.releaseConnService((SshConnService)shellService);
                SshManager.releaseSession((ClientSession)session);
                ThreadUtils.threadSafeSleep((int)5, (TimeUnit)TimeUnit.SECONDS);
                return this.tryToCreateSession();
            }
        }
        return Optional.empty();
    }

    private void configProxyInit(SshShellService shellService, String result) throws SshException {
        String execResult = this.configBackupServerLeaderIp(shellService, result).orElseThrow(() -> new EBackUpkException(EBackUpError.CONFIG_SERVER_LEADER_IP_ERROR));
        execResult = this.configBackupServerFloatIp(shellService, execResult).orElseThrow(() -> new EBackUpkException(EBackUpError.CONFIG_SERVER_FLOAT_IP_ERROR));
        execResult = this.configBackupServerPublicKey(shellService, execResult).orElseThrow(() -> new EBackUpkException(EBackUpError.CONFIG_SERVER_PUBLIC_KEY_ERROR));
        execResult = this.configBackupServerHcpPwd(shellService, execResult).orElseThrow(() -> new EBackUpkException(EBackUpError.CONFIG_SERVER_HCP_PWD_ERROR));
        execResult = this.configBackupServerRootPwd(shellService, execResult).orElseThrow(() -> new EBackUpkException(EBackUpError.CONFIG_SERVER_ROOT_PWD_ERROR));
        execResult = this.configMsuserPassword(shellService, execResult).orElseThrow(() -> new EBackUpkException(EBackUpError.CONFIG_MSUSER_PWD_ERROR));
        if (!StringUtils.containIgnoreCase((String)execResult, (String[])new String[]{"You can access the eBackup UI using the following link.", "service hcp start:completed"})) {
            throw new EBackUpkException(EBackUpError.CONFIG_VM_SERVICE_START_ERROR);
        }
        this.appendTaskDetail("backup proxy init successfully.");
        log.info("backup proxy init successfully.");
    }

    private Optional<String> configBackupServerLeaderIp(SshShellService shellService, String result) throws SshException {
        if (!StringUtils.containIgnoreCase((String)result, (String[])new String[]{"Please input the leader IP(The IP of internal communication plane at backup server):"})) {
            return Optional.empty();
        }
        String leaderIp = Optional.ofNullable(this.vmInfo.getEbackupServerInfo()).map(EbackupServerInfo::getManageIp).orElse("");
        String execResult = shellService.execCommand(leaderIp);
        log.info("execute [input leader ip:{}], result = {}.", (Object)leaderIp, (Object)execResult);
        this.appendTaskDetail(execResult);
        return SshErrParser.isInvalidResult((String)execResult) ? Optional.empty() : Optional.of(execResult);
    }

    private Optional<String> configBackupServerFloatIp(SshShellService shellService, String result) throws SshException {
        if (!StringUtils.containIgnoreCase((String)result, (String[])new String[]{"Please input the floating IP address at backup server:"})) {
            return Optional.empty();
        }
        String floatIp = this.getInnerPlaneFloatIp();
        String execResult = shellService.execCommand(floatIp);
        log.info("execute [input float ip:{}], result = {}.", (Object)floatIp, (Object)execResult);
        this.appendTaskDetail(execResult);
        return SshErrParser.isInvalidResult((String)execResult) ? Optional.empty() : Optional.of(execResult);
    }

    private Optional<String> configBackupServerPublicKey(SshShellService shellService, String result) throws SshException {
        if (!StringUtils.containIgnoreCase((String)result, (String[])new String[]{"To use the default public key, press Enter."})) {
            return Optional.empty();
        }
        String execResult = shellService.execCommand("");
        log.info("execute [ENTER], result = {}.", (Object)execResult);
        this.appendTaskDetail(execResult);
        return SshErrParser.isInvalidResult((String)execResult) ? Optional.empty() : Optional.of(execResult);
    }

    private Optional<String> configBackupServerHcpPwd(SshShellService shellService, String result) throws SshException {
        if (!StringUtils.containIgnoreCase((String)result, (String[])new String[]{"Please input hcp password of the backup server"})) {
            return Optional.empty();
        }
        String hcpPwd = Optional.ofNullable(this.vmInfo.getEbackupServerInfo()).map(EbackupServerInfo::getHcpPassword).orElse("");
        String execResult = shellService.execCommand(hcpPwd);
        String logResult = this.replaceSensitiveTexts(execResult, hcpPwd);
        this.appendTaskDetail(logResult);
        log.info("execute [hcp pwd], result = {}.", (Object)logResult);
        return SshErrParser.isInvalidResult((String)execResult) ? Optional.empty() : Optional.of(execResult);
    }

    private Optional<String> configBackupServerRootPwd(SshShellService shellService, String result) throws SshException {
        if (!StringUtils.containIgnoreCase((String)result, (String[])new String[]{"Please input root password of the backup server"})) {
            return Optional.empty();
        }
        String rootPwd = Optional.ofNullable(this.vmInfo.getEbackupServerInfo()).map(EbackupServerInfo::getRootPassword).orElse("");
        String execResult = shellService.execCommand(rootPwd);
        String logResult = this.replaceSensitiveTexts(execResult, rootPwd);
        this.appendTaskDetail(logResult);
        log.info("execute [root pwd], result = {}.", (Object)logResult);
        return SshErrParser.isInvalidResult((String)execResult) ? Optional.empty() : Optional.of(execResult);
    }

    private void configServerInit(SshShellService shellService, String result) throws SshException {
        String configResult = this.configInnerPlaneFloatIp(shellService, result).orElseThrow(() -> new EBackUpkException(EBackUpError.CONFIG_FLOAT_IP_ERROR));
        configResult = this.configMsuserPassword(shellService, configResult).orElseThrow(() -> new EBackUpkException(EBackUpError.CONFIG_MSUSER_PWD_ERROR));
        if (!StringUtils.containIgnoreCase((String)configResult, (String[])new String[]{"You can access the eBackup UI using the following link.", "service hcp start:completed"})) {
            throw new EBackUpkException(EBackUpError.CONFIG_VM_SERVICE_START_ERROR);
        }
        this.appendTaskDetail("backup server init successfully.");
        log.info("backup server init successfully.");
    }

    private Optional<String> configVmRole(SshShellService shellService, String result) throws SshException {
        if (!StringUtils.containIgnoreCase((String)result, (String[])new String[]{" 1.Backup Server", " 2.Backup Proxy "})) {
            return Optional.empty();
        }
        String vmRole = this.isVmRoleServer() ? "1" : "2";
        String execResult = shellService.execCommand(vmRole);
        this.appendTaskDetail(execResult);
        log.info("execute [vmRole:{}], result = {}.", (Object)vmRole, (Object)execResult);
        return SshErrParser.isInvalidResult((String)execResult) ? Optional.empty() : Optional.of(execResult);
    }

    private Optional<String> configNetworkType(SshShellService shellService, String result) throws SshException {
        if (!StringUtils.containIgnoreCase((String)result, (String[])new String[]{" 1.ipv4"})) {
            return Optional.empty();
        }
        String execResult = shellService.execCommand("1");
        this.appendTaskDetail(execResult);
        log.info("execute [1:ipv4], result = {}.", (Object)execResult);
        return SshErrParser.isInvalidResult((String)execResult) ? Optional.empty() : Optional.of(execResult);
    }

    private Optional<String> execEbackupUtilitiesScript(SshShellService shellService, String result) throws SshException {
        if (!StringUtils.containIgnoreCase((String)result, (String[])new String[]{"action]#"})) {
            return Optional.empty();
        }
        String cmd = "service hcp stop";
        String execResult = shellService.execCommand(cmd);
        this.appendTaskDetail(execResult);
        log.info("execute [{}], result = {}.", (Object)cmd, (Object)execResult);
        cmd = "sh ebackup_utilities.sh config";
        execResult = shellService.execCommand(cmd);
        this.appendTaskDetail(execResult);
        log.info("execute [{}], result = {}.", (Object)cmd, (Object)execResult);
        return SshErrParser.isInvalidResult((String)execResult) ? Optional.empty() : Optional.of(execResult);
    }

    private Optional<String> configInnerPlaneFloatIp(SshShellService shellService, String result) throws SshException {
        if (!StringUtils.containIgnoreCase((String)result, (String[])new String[]{"Enter a floating IP address that is in the same network segment as the internal communication plane."})) {
            return Optional.empty();
        }
        String floatIp = this.getInnerPlaneFloatIp();
        String execResult = shellService.execCommand(floatIp);
        this.appendTaskDetail(execResult);
        log.info("execute [input float ip:{}], result = {}.", (Object)floatIp, (Object)execResult);
        return SshErrParser.isInvalidResult((String)execResult) ? Optional.empty() : Optional.of(execResult);
    }

    private Optional<String> configMsuserPassword(SshShellService shellService, String result) throws SshException {
        if (!StringUtils.containIgnoreCase((String)result, (String[])new String[]{"Please enter the msuser password of the backup server:"})) {
            return Optional.empty();
        }
        String msuerPwd = this.vmInfo.getMsuserPassword();
        int timeout = Math.max(1, EbackupConfigUtils.getPropertiesValue("deploy.ebackup.config.msuser.timeout", 300));
        this.appendTaskDetail("config msuser pwd timeout : " + timeout);
        String execResult = shellService.execCommandWithTimeout(msuerPwd, timeout);
        String logResult = this.replaceSensitiveTexts(execResult, msuerPwd);
        this.appendTaskDetail(logResult);
        log.info("execute [input msuser pwd], result = {}.", (Object)logResult);
        if (StringUtils.containIgnoreCase((String)execResult, (String[])new String[]{"Please enter the msuser password again:"})) {
            execResult = shellService.execCommandWithTimeout(msuerPwd, timeout);
            logResult = this.replaceSensitiveTexts(execResult, msuerPwd);
            this.appendTaskDetail(logResult);
            log.info("execute [input msuser pwd again], result = {}.", (Object)logResult);
        }
        return Optional.of(execResult);
    }

    private Optional<String> configNetworkPlane(SshShellService shellService, String result) throws SshException {
        if (!StringUtils.containIgnoreCase((String)result, (String[])new String[]{"the 'Backup management' network plane?"})) {
            return Optional.empty();
        }
        Multimap<Integer, EbackupVmPlane> multimap = EBackupTaskFactory.classifyEbackupNicOfVmPlanes(this.vmInfo);
        String execResult = shellService.execCommand("1");
        this.appendTaskDetail(execResult);
        log.info("execute [config 1], result = {}.", (Object)execResult);
        if (!StringUtils.containIgnoreCase((String)execResult, (String[])new String[]{"the 'Internal communication' network plane?"})) {
            return Optional.empty();
        }
        int nicIndex = EBackupTaskFactory.findVmPlaneNicIndex(multimap, this.vmInfo.getInnerPlane(), 2);
        execResult = shellService.execCommand(String.valueOf(nicIndex));
        this.appendTaskDetail(execResult);
        log.info("execute [config 2], result = {}.", (Object)execResult);
        if (!StringUtils.containIgnoreCase((String)execResult, (String[])new String[]{"the 'Production management' network plane?"})) {
            return Optional.empty();
        }
        execResult = shellService.execCommand("1");
        this.appendTaskDetail(execResult);
        log.info("execute [config 1], result = {}.", (Object)execResult);
        if (!StringUtils.containIgnoreCase((String)execResult, (String[])new String[]{"the 'Production Storage' network plane?"})) {
            return Optional.empty();
        }
        nicIndex = EBackupTaskFactory.findVmPlaneNicIndex(multimap, this.vmInfo.getProductionPlane(), 3);
        execResult = shellService.execCommand(String.valueOf(nicIndex));
        this.appendTaskDetail(execResult);
        log.info("execute [config 3], result = {}.", (Object)execResult);
        if (!StringUtils.containIgnoreCase((String)execResult, (String[])new String[]{"the 'Backup Storage' network plane?"})) {
            return Optional.empty();
        }
        nicIndex = EBackupTaskFactory.findVmPlaneNicIndex(multimap, this.vmInfo.getBackupPlane(), 4);
        execResult = shellService.execCommand(String.valueOf(nicIndex));
        this.appendTaskDetail(execResult);
        log.info("execute [config 4], result = {}.", (Object)execResult);
        return SshErrParser.isInvalidResult((String)execResult) ? Optional.empty() : Optional.of(execResult);
    }

    private String getInnerPlaneFloatIp() {
        return Optional.ofNullable(this.vmInfo.getInnerPlane()).map(EbackupVmPlane::getInnerFloatIp).orElse("");
    }

    private boolean isVmRoleServer() {
        return Objects.equals("server", this.vmInfo.getRole());
    }

    private Optional<String> change2ScriptDir(SshShellService shellService, String result) throws SshException {
        if (!StringUtils.containIgnoreCase((String)result, (String[])new String[]{"#"})) {
            return Optional.empty();
        }
        String cmd = "TMOUT=0";
        String execResult = shellService.execCommand(cmd);
        this.appendTaskDetail(execResult);
        log.info("execute [TMOUT=0], result = {}.", (Object)execResult);
        cmd = "cd /opt/eBackup_*/action";
        execResult = shellService.execCommand(cmd);
        this.appendTaskDetail(execResult);
        log.info("execute [cd */action], result = {}.", (Object)execResult);
        return SshErrParser.isInvalidResult((String)execResult) ? Optional.empty() : Optional.of(execResult);
    }

    private Optional<ClientSession> tryToCreateSession() {
        int tryCount = Math.max(1, EbackupConfigUtils.getPropertiesValue("deploy.ebakcup.config.ssh.try.count", 12));
        int defaultDeltaWaitTime = 20;
        for (int idx = 1; idx <= tryCount; ++idx) {
            try {
                this.appendTaskDetail("try to connect VM, count : " + idx);
                log.info("try to connect VM, idx = {}.", (Object)idx);
                return Optional.ofNullable(this.buildSession());
            }
            catch (SshException e) {
                log.warn("try create session failed, idx : {}.", (Object)idx);
                ThreadUtils.threadSafeSleep((int)20, (TimeUnit)TimeUnit.SECONDS);
                continue;
            }
        }
        return Optional.empty();
    }

    private ClientSession buildSession() throws SshException {
        SshConnInfo connInfo = SshConnInfo.builder().userName("hcp").hostName(this.vmInfo.getManagePlane().getManageIp()).userPwd(this.getVmHcpDefaultInfo()).newPwd(this.vmInfo.getHcpPassword()).build();
        return SshManager.getSession((SshConnInfo)connInfo);
    }

    private Optional<String> switchUser2Root(SshShellService shellService) throws SshException {
        String rootPwd = Optional.ofNullable(this.vmInfo.getRootPassword()).filter(StringUtils::isNotEmpty).orElseThrow(() -> new EBackUpkException(EBackUpError.PARAM_ERROR));
        String result = shellService.execCommand("su root");
        log.info("switch user to root result = {}.", (Object)result);
        if (result.contains("Password:")) {
            result = shellService.execCommand(rootPwd);
            log.info("input root text, result={}.", (Object)this.replaceSensitiveTexts(result, rootPwd));
        }
        return result.trim().endsWith("#") ? Optional.of(result) : Optional.empty();
    }

    private String replaceSensitiveTexts(String result, String sensitive) {
        return result.replace(sensitive.trim(), "******");
    }

    private String getVmHcpDefaultInfo() {
        return new String(Base64.getDecoder().decode("UFhVOUBjdHVOb3YxNyE="), StandardCharsets.UTF_8);
    }

    @Generated
    protected EBackupInitTask(EBackupInitTaskBuilder<?, ?> b) {
        super(b);
        this.vmInfo = ((EBackupInitTaskBuilder)b).vmInfo;
    }

    @Generated
    public static EBackupInitTaskBuilder<?, ?> builder() {
        return new EBackupInitTaskBuilderImpl();
    }

    @Generated
    private static final class EBackupInitTaskBuilderImpl
    extends EBackupInitTaskBuilder<EBackupInitTask, EBackupInitTaskBuilderImpl> {
        @Generated
        private EBackupInitTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected EBackupInitTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public EBackupInitTask build() {
            return new EBackupInitTask(this);
        }
    }

    @Generated
    public static abstract class EBackupInitTaskBuilder<C extends EBackupInitTask, B extends EBackupInitTaskBuilder<C, B>>
    extends BaseTask.BaseTaskBuilder<C, B> {
        @Generated
        private EbackupVmInfo vmInfo;

        @Generated
        public B vmInfo(EbackupVmInfo vmInfo) {
            this.vmInfo = vmInfo;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "EBackupInitTask.EBackupInitTaskBuilder(super=" + super.toString() + ", vmInfo=" + this.vmInfo + ")";
        }
    }
}

