/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.ebackup.task;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.huawei.yinglong.river.deploy.virtualization.common.entity.FusionComputeInfo;
import com.huawei.yinglong.river.deploy.virtualization.common.entity.TemplateInfo;
import com.huawei.yinglong.river.deploy.virtualization.deployebackup.entity.EbackupParams;
import com.huawei.yinglong.river.deploy.virtualization.deployebackup.entity.EbackupVmInfo;
import com.huawei.yinglong.river.deploy.virtualization.deployebackup.entity.EbackupVmPlane;
import com.huawei.yinglong.river.sitedeployment.dcs.constant.TaskOperateEnum;
import com.huawei.yinglong.river.sitedeployment.dcs.ebackup.assembler.EbackupAssembler;
import com.huawei.yinglong.river.sitedeployment.dcs.ebackup.task.DatastorePortGroupCheckTask;
import com.huawei.yinglong.river.sitedeployment.dcs.ebackup.task.DeployEBackUpTask;
import com.huawei.yinglong.river.sitedeployment.dcs.ebackup.task.EBackTaskContext;
import com.huawei.yinglong.river.sitedeployment.dcs.ebackup.task.EBackupInitTask;
import com.huawei.yinglong.river.sitedeployment.dcs.ebackup.task.TemplateCleanAndCheckTask;
import com.huawei.yinglong.river.sitedeployment.dcs.ebackup.task.TemplateUnzipTask;
import com.huawei.yinglong.river.sitedeployment.dcs.ebackup.utils.EbackupConfigUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.ebackup.utils.TaskResourceUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.base.FcLoginInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.enviroment.EnvironmentCheckTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.enviroment.cmd.EnvironmentCheckCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.net.ClearInvalidNicTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.vm.start.StartVmTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.vm.template.CreateVmByTemplateTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.vm.template.UploadTemplateTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.vm.template.cmd.CreateVmByTemplateCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.vm.template.cmd.UploadTemplateCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.vm.template.cmd.VmNicConfigCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.service.FcTaskService;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.CommonTaskManager;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.mapstruct.factory.Mappers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EBackupTaskFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EBackupTaskFactory.class);
    private static final EbackupAssembler ASSEMBLER = (EbackupAssembler)Mappers.getMapper(EbackupAssembler.class);
    private static final List<TaskOperateEnum> OPERATE_RETRY = Collections.singletonList(TaskOperateEnum.RETRY);
    private static final List<TaskOperateEnum> OPERATE_RETRY_SKIP = Arrays.asList(TaskOperateEnum.RETRY, TaskOperateEnum.SKIP);
    private static final int EBACK_UP_DISK = 120;
    private static final int EBACK_UP_CPU = 8;
    private static final int EBACK_UP_MEMORY = 16;
    private static final String CREATE_VM_BY_TEMPLATE = "create.%s.vm.by.template";

    public static DeployEBackUpTask createEBackUpTask(EbackupParams ebackupParams) {
        return ((DeployEBackUpTask.DeployEBackUpTaskBuilder)((DeployEBackUpTask.DeployEBackUpTaskBuilder)((DeployEBackUpTask.DeployEBackUpTaskBuilder)((DeployEBackUpTask.DeployEBackUpTaskBuilder)((DeployEBackUpTask.DeployEBackUpTaskBuilder)((DeployEBackUpTask.DeployEBackUpTaskBuilder)DeployEBackUpTask.builder().taskId(ebackupParams.getTaskId())).taskName(TaskResourceUtils.getTaskName("ebackup.task.name"))).duration(TaskResourceUtils.getTaskDuration("ebackup.task.name"))).eventType("eBackupDeployEvent")).subTasks(EBackupTaskFactory.createSubTasks(ebackupParams))).supportOperates(OPERATE_RETRY)).build();
    }

    public static boolean isUpdateTaskParamSuccess(EbackupParams params) {
        return CommonTaskManager.getInstance().queryTaskById(params.getTaskId()).map(task -> EBackupTaskFactory.updateSubTask(task, params)).orElse(false);
    }

    static boolean updateSubTask(BaseTask task, EbackupParams params) {
        if (CollectionUtils.isEmpty((Collection)task.getSubTasks())) {
            log.info("No sub tasks to update");
            return true;
        }
        task.getSubTasks().forEach(subTask -> EBackupTaskFactory.updateTask(params, subTask));
        return EBackupTaskFactory.updateCreateVmByTemplateTask(task, params) && EBackupTaskFactory.updateEBackupInitTask(task, params);
    }

    private static boolean updateEBackupInitTask(BaseTask task, EbackupParams params) {
        List<EBackupInitTask> originInitTasks = task.getSubTasks().stream().filter(EBackupInitTask.class::isInstance).map(EBackupInitTask.class::cast).collect(Collectors.toList());
        if (originInitTasks.isEmpty()) {
            return true;
        }
        return EBackupTaskFactory.updateInitTask(originInitTasks, params);
    }

    private static boolean updateInitTask(List<EBackupInitTask> initTasks, EbackupParams params) {
        List<EbackupVmInfo> vmInfos = EBackupTaskFactory.getSortedVmInfos(params);
        if (initTasks.size() != vmInfos.size()) {
            log.warn("initTasks size not match");
            return false;
        }
        for (int i = 0; i < initTasks.size(); ++i) {
            initTasks.get(i).update(vmInfos.get(i));
        }
        return true;
    }

    private static boolean updateCreateVmByTemplateTask(BaseTask task, EbackupParams params) {
        List<CreateVmByTemplateTask> originVmTasks = EBackupTaskFactory.filterSubTasks(task, CreateVmByTemplateTask.class);
        List<ClearInvalidNicTask> originNicTasks = EBackupTaskFactory.filterSubTasks(task, ClearInvalidNicTask.class);
        List<StartVmTask> originStartVmTasks = EBackupTaskFactory.filterSubTasks(task, StartVmTask.class);
        if (originVmTasks.isEmpty() || originNicTasks.isEmpty() || originStartVmTasks.isEmpty()) {
            return true;
        }
        return EBackupTaskFactory.updateVmTask(originVmTasks, originNicTasks, originStartVmTasks, params);
    }

    private static <T extends BaseTask> List<T> filterSubTasks(BaseTask task, Class<T> clazz) {
        return task.getSubTasks().stream().filter(clazz::isInstance).map(clazz::cast).collect(Collectors.toList());
    }

    private static void updateTask(EbackupParams params, BaseTask subTask) {
        if (subTask instanceof EnvironmentCheckTask) {
            ((EnvironmentCheckTask)subTask).update((Object)EBackupTaskFactory.buildEnvironmentCheckCmd(params), ASSEMBLER.toFusionCompute(params.getFusionComputeInfo()));
        } else if (subTask instanceof UploadTemplateTask) {
            ((UploadTemplateTask)subTask).update((Object)EBackupTaskFactory.buildTemplateCmd(params), ASSEMBLER.toFusionCompute(params.getFusionComputeInfo()));
        } else {
            log.info("task {} does not need to update", (Object)subTask.getTaskName());
        }
    }

    private static boolean updateVmTask(List<CreateVmByTemplateTask> vmTasks, List<ClearInvalidNicTask> nicTasks, List<StartVmTask> startVmTasks, EbackupParams params) {
        List<EbackupVmInfo> vmInfos = EBackupTaskFactory.getSortedVmInfos(params);
        int vmTaskSize = vmTasks.size();
        if (vmTaskSize != vmInfos.size() || vmTaskSize != nicTasks.size() || vmTaskSize != startVmTasks.size()) {
            log.warn("vmTasks size not match");
            return false;
        }
        FcLoginInfo fcLoginInfo = ASSEMBLER.toFusionCompute(params.getFusionComputeInfo());
        for (int i = 0; i < vmTaskSize; ++i) {
            CreateVmByTemplateCmd createVmByTemplateCmd = EBackupTaskFactory.buildVmByTemplateCmd(vmInfos.get(i));
            vmTasks.get(i).update((Object)createVmByTemplateCmd, fcLoginInfo);
            nicTasks.get(i).update((Object)createVmByTemplateCmd.getValidNicNum(), fcLoginInfo);
            startVmTasks.get(i).update(null, fcLoginInfo);
        }
        return true;
    }

    private static List<BaseTask> createSubTasks(EbackupParams params) {
        ArrayList<BaseTask> subTasks = new ArrayList<BaseTask>();
        subTasks.add(EBackupTaskFactory.createDatastorePortGroupTask());
        subTasks.add((BaseTask)EBackupTaskFactory.createEnvironmentCheckTask(params));
        subTasks.add(EBackupTaskFactory.createUnzipTask());
        subTasks.add((BaseTask)FcTaskService.uploadTemplateTask((UploadTemplateCmd)EBackupTaskFactory.buildTemplateCmd(params), (FcLoginInfo)ASSEMBLER.toFusionCompute(params.getFusionComputeInfo())));
        List<EbackupVmInfo> vmInfos = EBackupTaskFactory.getSortedVmInfos(params);
        vmInfos.forEach(ebackupVmInfo -> subTasks.addAll(EBackupTaskFactory.createVmTask(ebackupVmInfo, params.getFusionComputeInfo())));
        vmInfos.forEach(ebackupVmInfo -> subTasks.add(EBackupTaskFactory.createInitTask(ebackupVmInfo)));
        subTasks.add(EBackupTaskFactory.createTemplateCleanTask());
        subTasks.forEach(subTask -> subTask.setEventType("eBackupDeployEvent"));
        return subTasks;
    }

    private static List<EbackupVmInfo> getSortedVmInfos(EbackupParams params) {
        if (CollectionUtils.isEmpty((Collection)params.getEbackupVmInfo())) {
            return Collections.emptyList();
        }
        return params.getEbackupVmInfo().stream().sorted((vmInfo1, vmInfo2) -> vmInfo2.getRole().compareTo(vmInfo1.getRole())).collect(Collectors.toList());
    }

    private static EnvironmentCheckTask createEnvironmentCheckTask(EbackupParams params) {
        return FcTaskService.createEnvironmentCheckTask((EnvironmentCheckCmd)EBackupTaskFactory.buildEnvironmentCheckCmd(params), (FcLoginInfo)ASSEMBLER.toFusionCompute(params.getFusionComputeInfo()));
    }

    private static EnvironmentCheckCmd buildEnvironmentCheckCmd(EbackupParams params) {
        EnvironmentCheckCmd checkCmd = EnvironmentCheckCmd.builder().cpuMuxRatio(EbackupConfigUtils.getCpuMuxRatio()).memoryMuxRatio(EbackupConfigUtils.getMemoryMuxRatio()).oldVmIds(() -> EBackTaskContext.getInstance().getVmIds()).build();
        Optional.ofNullable(params.getTemplateInfo()).ifPresent(templateInfo -> EBackupTaskFactory.addReservation(checkCmd, templateInfo.getBelongCnaName(), templateInfo.getDatastoreName()));
        if (CollectionUtils.isNotEmpty((Collection)params.getEbackupVmInfo())) {
            params.getEbackupVmInfo().forEach(ebackupVmInfo -> EBackupTaskFactory.addReservation(checkCmd, ebackupVmInfo.getBelongCnaName(), ebackupVmInfo.getDatastoreName()));
        }
        return checkCmd;
    }

    private static void addReservation(EnvironmentCheckCmd checkCmd, String cnaName, String datastoreName) {
        if (StringUtils.isNotEmpty((CharSequence)datastoreName)) {
            checkCmd.addDatastore(datastoreName, 120);
        } else {
            checkCmd.addDisk(cnaName, 120);
        }
        checkCmd.addCpu(cnaName, 8);
        checkCmd.addMemory(cnaName, 16);
    }

    private static EBackupInitTask createInitTask(EbackupVmInfo vmInfo) {
        return ((EBackupInitTask.EBackupInitTaskBuilder)((EBackupInitTask.EBackupInitTaskBuilder)((EBackupInitTask.EBackupInitTaskBuilder)((EBackupInitTask.EBackupInitTaskBuilder)((EBackupInitTask.EBackupInitTaskBuilder)EBackupInitTask.builder().taskName(TaskResourceUtils.getTaskName(StringUtils.formatTxt((String)"ebackup.init.%s.task.name", (Object[])new Object[]{vmInfo.getRole()})))).duration(TaskResourceUtils.getTaskDuration(StringUtils.formatTxt((String)"ebackup.init.%s.task.name", (Object[])new Object[]{vmInfo.getRole()})))).vmInfo(vmInfo).eventType("eBackupDeployEvent")).supportOperates(OPERATE_RETRY_SKIP)).skipMsg(TaskResourceUtils.getString("skip.msg.ebackup.init.vm"))).build();
    }

    private static DatastorePortGroupCheckTask createDatastorePortGroupTask() {
        return ((DatastorePortGroupCheckTask.DatastorePortGroupCheckTaskBuilder)((DatastorePortGroupCheckTask.DatastorePortGroupCheckTaskBuilder)((DatastorePortGroupCheckTask.DatastorePortGroupCheckTaskBuilder)((DatastorePortGroupCheckTask.DatastorePortGroupCheckTaskBuilder)DatastorePortGroupCheckTask.builder().taskName(TaskResourceUtils.getTaskName("config.port.group.datastore.task.name"))).duration(TaskResourceUtils.getTaskDuration("config.port.group.datastore.task.name"))).eventType("eBackupDeployEvent")).supportOperates(Arrays.asList(TaskOperateEnum.RETRY, TaskOperateEnum.RESUME))).build();
    }

    static List<BaseTask> createVmTask(EbackupVmInfo ebackupVmInfo, FusionComputeInfo fusionComputeInfo) {
        CreateVmByTemplateCmd createVmByTemplateCmd = EBackupTaskFactory.buildVmByTemplateCmd(ebackupVmInfo);
        FcLoginInfo fcLoginInfo = ASSEMBLER.toFusionCompute(fusionComputeInfo);
        return Arrays.asList(FcTaskService.createVmByTemplateTask((CreateVmByTemplateCmd)createVmByTemplateCmd, (FcLoginInfo)fcLoginInfo), FcTaskService.createClearNicTask((int)createVmByTemplateCmd.getValidNicNum(), (FcLoginInfo)fcLoginInfo), FcTaskService.createStartVmTask((FcLoginInfo)fcLoginInfo, (boolean)true));
    }

    private static CreateVmByTemplateCmd buildVmByTemplateCmd(EbackupVmInfo ebackupVmInfo) {
        EBackTaskContext context = EBackTaskContext.getInstance();
        return ((CreateVmByTemplateCmd.CreateVmByTemplateCmdBuilder)((CreateVmByTemplateCmd.CreateVmByTemplateCmdBuilder)((CreateVmByTemplateCmd.CreateVmByTemplateCmdBuilder)((CreateVmByTemplateCmd.CreateVmByTemplateCmdBuilder)((CreateVmByTemplateCmd.CreateVmByTemplateCmdBuilder)((CreateVmByTemplateCmd.CreateVmByTemplateCmdBuilder)CreateVmByTemplateCmd.builder().taskName(TaskResourceUtils.getTaskName(StringUtils.formatTxt((String)CREATE_VM_BY_TEMPLATE, (Object[])new Object[]{ebackupVmInfo.getRole()})))).templateId(context::getTemplateId).vmName(ebackupVmInfo.getName())).hostName(ebackupVmInfo.getName()).cnaName(ebackupVmInfo.getBelongCnaName())).password(ebackupVmInfo.getRootPassword()).datastoreName(ebackupVmInfo.getDatastoreName())).nicConfigs(EBackupTaskFactory.buildNicConfig(ebackupVmInfo)).vmIdHandler(context::addVmId)).isAutoStartVm(false)).build();
    }

    private static List<VmNicConfigCmd> buildNicConfig(EbackupVmInfo ebackupVmInfo) {
        Multimap<Integer, EbackupVmPlane> multimap = EBackupTaskFactory.classifyEbackupNicOfVmPlanes(ebackupVmInfo);
        List<VmNicConfigCmd> nicConfigCmdList = IntStream.range(1, 5).filter(arg_0 -> multimap.containsKey(arg_0)).mapToObj(arg_0 -> multimap.get(arg_0)).map(vmPlanes -> (EbackupVmPlane)vmPlanes.iterator().next()).map(ASSEMBLER::toNicConfig).collect(Collectors.toList());
        nicConfigCmdList.addAll(IntStream.range(nicConfigCmdList.size(), 4).mapToObj(index -> VmNicConfigCmd.builder().portGroupName("managePortgroup").build()).collect(Collectors.toList()));
        return nicConfigCmdList;
    }

    public static Multimap<Integer, EbackupVmPlane> classifyEbackupNicOfVmPlanes(EbackupVmInfo vmInfo) {
        ArrayListMultimap multimap = ArrayListMultimap.create();
        AtomicInteger nicIndex = new AtomicInteger(1);
        multimap.put((Object)nicIndex.getAndIncrement(), (Object)vmInfo.getManagePlane());
        Stream.of(vmInfo.getInnerPlane(), vmInfo.getProductionPlane(), vmInfo.getBackupPlane()).forEach(arg_0 -> EBackupTaskFactory.lambda$classifyEbackupNicOfVmPlanes$11((Multimap)multimap, nicIndex, arg_0));
        return multimap;
    }

    public static int findVmPlaneNicIndex(Multimap<Integer, EbackupVmPlane> multimap, EbackupVmPlane checkVmPlane, int defaultNicIndex) {
        return multimap.asMap().entrySet().stream().filter(entry -> ((Collection)entry.getValue()).stream().anyMatch(vmPlane -> EBackupTaskFactory.isSameVmPlane(vmPlane, checkVmPlane))).map(Map.Entry::getKey).findFirst().orElse(defaultNicIndex);
    }

    private static boolean isSameVmPlane(EbackupVmPlane vmPlane1, EbackupVmPlane vmPlane2) {
        return Objects.equals(vmPlane1.getManageIp(), vmPlane2.getManageIp()) && Objects.equals(vmPlane1.getNetmask(), vmPlane2.getNetmask()) && Objects.equals(vmPlane1.getPortGroupName(), vmPlane2.getPortGroupName());
    }

    private static TemplateCleanAndCheckTask createTemplateCleanTask() {
        return ((TemplateCleanAndCheckTask.TemplateCleanAndCheckTaskBuilder)((TemplateCleanAndCheckTask.TemplateCleanAndCheckTaskBuilder)((TemplateCleanAndCheckTask.TemplateCleanAndCheckTaskBuilder)((TemplateCleanAndCheckTask.TemplateCleanAndCheckTaskBuilder)((TemplateCleanAndCheckTask.TemplateCleanAndCheckTaskBuilder)TemplateCleanAndCheckTask.builder().taskName(TaskResourceUtils.getTaskName("template.clean.task.name"))).duration(TaskResourceUtils.getTaskDuration("template.clean.task.name"))).eventType("eBackupDeployEvent")).supportOperates(OPERATE_RETRY_SKIP)).skipMsg(TaskResourceUtils.getString("skip.msg.template.clean"))).build();
    }

    private static UploadTemplateCmd buildTemplateCmd(EbackupParams params) {
        EBackTaskContext context = EBackTaskContext.getInstance();
        String cnaName = Optional.ofNullable(params.getTemplateInfo()).map(TemplateInfo::getBelongCnaName).orElse("");
        return UploadTemplateCmd.builder().filePath(context::getTemplateVhdFile).ovfFilePath(context::getTemplateOvfFile).cnaName(cnaName).datastoreName(params.getTemplateInfo().getDatastoreName()).templateName("ebackupTemplate").templateIdHandler(EBackupTaskFactory.templateIdHandler(context)).build();
    }

    private static Consumer<String> templateIdHandler(EBackTaskContext context) {
        return templateId -> {
            context.setTemplateId((String)templateId);
            context.addVmId((String)templateId);
        };
    }

    private static TemplateUnzipTask createUnzipTask() {
        return ((TemplateUnzipTask.TemplateUnzipTaskBuilder)((TemplateUnzipTask.TemplateUnzipTaskBuilder)((TemplateUnzipTask.TemplateUnzipTaskBuilder)((TemplateUnzipTask.TemplateUnzipTaskBuilder)TemplateUnzipTask.builder().taskName(TaskResourceUtils.getTaskName("template.unzip.task.name"))).duration(TaskResourceUtils.getTaskDuration("template.unzip.task.name"))).eventType("eBackupDeployEvent")).supportOperates(OPERATE_RETRY)).build();
    }

    @Generated
    private EBackupTaskFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static /* synthetic */ void lambda$classifyEbackupNicOfVmPlanes$11(Multimap multimap, AtomicInteger nicIndex, EbackupVmPlane checkVmPlane) {
        int index = EBackupTaskFactory.findVmPlaneNicIndex((Multimap<Integer, EbackupVmPlane>)multimap, checkVmPlane, 0);
        if (index <= 0) {
            index = nicIndex.getAndIncrement();
            log.info("add new nic index:{}, ip:{}.", (Object)index, (Object)checkVmPlane.getManageIp());
        }
        multimap.put((Object)index, (Object)checkVmPlane);
    }
}

