/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.ebackup.task;

import com.huawei.yinglong.river.deploy.virtualization.common.entity.FusionComputeInfo;
import com.huawei.yinglong.river.deploy.virtualization.deployebackup.entity.EbackupParams;
import com.huawei.yinglong.river.deploy.virtualization.deployebackup.entity.EbackupVmInfo;
import com.huawei.yinglong.river.deploy.virtualization.deployebackup.entity.EbackupVmPlane;
import com.huawei.yinglong.river.sitedeployment.dcs.ebackup.assembler.EbackupAssembler;
import com.huawei.yinglong.river.sitedeployment.dcs.ebackup.exception.EBackUpError;
import com.huawei.yinglong.river.sitedeployment.dcs.ebackup.exception.EBackUpkException;
import com.huawei.yinglong.river.sitedeployment.dcs.ebackup.task.EBackTaskContext;
import com.huawei.yinglong.river.sitedeployment.dcs.ebackup.utils.EbackupConfigUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.client.ApiClient;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.base.FcLoginInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.service.FcClientService;
import com.huawei.yinglong.river.sitedeployment.dcs.http.HttpRequestApiFactory;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FileOperateUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ThreadUtils;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.mapstruct.factory.Mappers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.http.GET;

public class TemplateCleanAndCheckTask
extends BaseTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TemplateCleanAndCheckTask.class);
    public static final String NAME_KEY = "template.clean.task.name";
    private static final EbackupAssembler ASSEMBLER = (EbackupAssembler)Mappers.getMapper(EbackupAssembler.class);
    private static final String WAIT_TIME_KEY = "deploy.ebackup.limit.time";

    public void execute() throws TaskException {
        long waitTime;
        EBackTaskContext context = EBackTaskContext.getInstance();
        this.appendTaskDetail("start to delete local template file.");
        FileOperateUtils.deleteDirectory((String)context.getTemplateCacheFile());
        this.deleteFcTemplate(context);
        Optional<String> serverIp = this.getServerIp(context.getVmInfos());
        if (!serverIp.isPresent()) {
            log.info("not find eBackup server manage ip, not need to check.");
            this.appendTaskDetail("Not need to access eBackup UI portal.");
            return;
        }
        EBackUpHttpRequest requestApi = (EBackUpHttpRequest)HttpRequestApiFactory.createRequestApi((String)StringUtils.formatTxt((String)"https://%s:8088", (Object[])new Object[]{serverIp.get()}), EBackUpHttpRequest.class);
        long startTime = System.currentTimeMillis();
        int waitTimeOutMinutes = this.getWaitTimeOutMinutes();
        log.info("ebackup wait time:[{}} minus", (Object)waitTimeOutMinutes);
        this.appendTaskDetail("start to check eBackup service status.");
        do {
            ThreadUtils.threadSafeSleep((int)10, (TimeUnit)TimeUnit.SECONDS);
            this.appendTaskDetail("try to access eBackup UI portal.");
            if (this.isPortalAccess(requestApi)) {
                log.info("can access ebackup portal,deploy success");
                this.appendTaskDetail("access eBackup UI portal successfully.");
                return;
            }
            log.warn("can not access ebackup portal,wait to next access");
        } while ((waitTime = System.currentTimeMillis() - startTime) <= TimeUnit.MINUTES.toMillis(waitTimeOutMinutes));
        throw new EBackUpkException(EBackUpError.PORTAL_CHECK_ERROR);
    }

    private void deleteFcTemplate(EBackTaskContext context) {
        if (StringUtils.isEmpty((CharSequence)context.getTemplateId())) {
            log.info("template id is empty, no need to delete.");
            return;
        }
        FusionComputeInfo fcInfo = Optional.ofNullable(context.getEbackupParams()).map(EbackupParams::getFusionComputeInfo).orElseThrow(() -> new EBackUpkException(EBackUpError.PARAM_ERROR));
        ApiClient apiService = FcClientService.createApiService((FcLoginInfo)ASSEMBLER.toFusionCompute(fcInfo));
        apiService.deleteVm(context.getTemplateId());
        log.info("delete template {}", (Object)context.getTemplateId());
        this.appendTaskDetail("delete eBackup template, id:" + context.getTemplateId());
    }

    private int getWaitTimeOutMinutes() {
        return Math.max(1, EbackupConfigUtils.getPropertiesValue(WAIT_TIME_KEY, 10));
    }

    private Optional<String> getServerIp(List<EbackupVmInfo> ebackupVmInfos) {
        return ebackupVmInfos.stream().filter(vmInfo -> "server".equals(vmInfo.getRole())).map(EbackupVmInfo::getManagePlane).map(EbackupVmPlane::getManageIp).findFirst();
    }

    private boolean isPortalAccess(EBackUpHttpRequest requestApi) {
        try {
            return requestApi.getPortalStatus().execute().isSuccessful();
        }
        catch (IOException exception) {
            log.error("can not access ebackup portal", (Throwable)exception);
            return false;
        }
    }

    @Generated
    protected TemplateCleanAndCheckTask(TemplateCleanAndCheckTaskBuilder<?, ?> b) {
        super(b);
    }

    @Generated
    public static TemplateCleanAndCheckTaskBuilder<?, ?> builder() {
        return new TemplateCleanAndCheckTaskBuilderImpl();
    }

    @Generated
    private static final class TemplateCleanAndCheckTaskBuilderImpl
    extends TemplateCleanAndCheckTaskBuilder<TemplateCleanAndCheckTask, TemplateCleanAndCheckTaskBuilderImpl> {
        @Generated
        private TemplateCleanAndCheckTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected TemplateCleanAndCheckTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public TemplateCleanAndCheckTask build() {
            return new TemplateCleanAndCheckTask(this);
        }
    }

    @Generated
    public static abstract class TemplateCleanAndCheckTaskBuilder<C extends TemplateCleanAndCheckTask, B extends TemplateCleanAndCheckTaskBuilder<C, B>>
    extends BaseTask.BaseTaskBuilder<C, B> {
        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "TemplateCleanAndCheckTask.TemplateCleanAndCheckTaskBuilder(super=" + super.toString() + ")";
        }
    }

    private static interface EBackUpHttpRequest {
        @GET(value="/")
        public Call<Void> getPortalStatus();
    }
}

