/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.ebackup.task;

import com.huawei.yinglong.river.deploy.virtualization.common.entity.TemplateInfo;
import com.huawei.yinglong.river.deploy.virtualization.deployebackup.entity.EbackupParams;
import com.huawei.yinglong.river.sitedeployment.dcs.ebackup.constant.DeployEbackupConstant;
import com.huawei.yinglong.river.sitedeployment.dcs.ebackup.exception.EBackUpError;
import com.huawei.yinglong.river.sitedeployment.dcs.ebackup.task.EBackTaskContext;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FileOperateUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FilePathValidatorUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ZipUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.exception.ErrorKey;
import java.io.File;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.io.FileUtils;

public class TemplateUnzipTask
extends BaseTask {
    public static final String NAME_KEY = "template.unzip.task.name";

    public void execute() throws TaskException {
        EBackTaskContext context = EBackTaskContext.getInstance();
        String templateFilePath = this.getValidFilePath(context);
        String tempCachePath = this.getTempCachePath();
        FileOperateUtils.deleteDirectory((String)tempCachePath);
        this.appendTaskDetail("start to unzip template file.");
        ZipUtils.decompressFileBy7Zip((String)DeployEbackupConstant.ZIP_TOOL_PATH, (String)templateFilePath, (String)tempCachePath);
        this.appendTaskDetail("finish to unzip template file.");
        context.setTemplateCacheFile(tempCachePath);
        context.setTemplateVhdFile(this.getTemplateUnzipFile(tempCachePath, "vhd"));
        context.setTemplateOvfFile(this.getTemplateUnzipFile(tempCachePath, "ovf"));
    }

    private String getValidFilePath(EBackTaskContext context) {
        String templateFilePath = Optional.ofNullable(context.getEbackupParams()).map(EbackupParams::getTemplateInfo).map(TemplateInfo::getTemplateFile).orElseThrow(() -> new TaskException((ErrorKey)EBackUpError.PARAM_ERROR));
        if (!new File(templateFilePath).exists()) {
            throw new TaskException((ErrorKey)EBackUpError.TEMPLATE_FILE_NOT_EXIST);
        }
        return templateFilePath;
    }

    private String getTempCachePath() {
        String taskId = Optional.ofNullable(EBackTaskContext.getInstance().getEbackupParams()).map(EbackupParams::getTaskId).orElseThrow(() -> new TaskException((ErrorKey)EBackUpError.PARAM_ERROR));
        return (String)FileOperateUtils.createTemplateCacheFile((String)taskId).orElseThrow(() -> new TaskException((ErrorKey)EBackUpError.PARAM_ERROR));
    }

    private String getTemplateUnzipFile(String templateCacheDir, String fileSuffix) {
        return FileUtils.listFiles((File)new File(templateCacheDir), (String[])new String[]{fileSuffix}, (boolean)false).stream().findFirst().flatMap(FilePathValidatorUtils::getSafePath).orElse("");
    }

    @Generated
    protected TemplateUnzipTask(TemplateUnzipTaskBuilder<?, ?> b) {
        super(b);
    }

    @Generated
    public static TemplateUnzipTaskBuilder<?, ?> builder() {
        return new TemplateUnzipTaskBuilderImpl();
    }

    @Generated
    private static final class TemplateUnzipTaskBuilderImpl
    extends TemplateUnzipTaskBuilder<TemplateUnzipTask, TemplateUnzipTaskBuilderImpl> {
        @Generated
        private TemplateUnzipTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected TemplateUnzipTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public TemplateUnzipTask build() {
            return new TemplateUnzipTask(this);
        }
    }

    @Generated
    public static abstract class TemplateUnzipTaskBuilder<C extends TemplateUnzipTask, B extends TemplateUnzipTaskBuilder<C, B>>
    extends BaseTask.BaseTaskBuilder<C, B> {
        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "TemplateUnzipTask.TemplateUnzipTaskBuilder(super=" + super.toString() + ")";
        }
    }
}

