/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.dme.application;

import com.huawei.yinglong.river.deploy.virtualization.common.entity.DeployTaskDetailVo;
import com.huawei.yinglong.river.deploy.virtualization.common.entity.DeployTaskInfoVo;
import com.huawei.yinglong.river.deploy.virtualization.deploydme.entity.OptionItemBo;
import com.huawei.yinglong.river.deploy.virtualization.deploydme.entity.ParamTemplateBo;
import com.huawei.yinglong.river.deploy.virtualization.deploydme.entity.ResultInfoBo;
import com.huawei.yinglong.river.deploy.virtualization.deploydme.entity.TaskInfoBo;
import com.huawei.yinglong.river.sitedeployment.dcs.constant.TaskOperateEnum;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.domain.param.LanguageCombination;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.domain.param.OptionItem;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.domain.param.ParamTemplate;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.domain.task.GeneralTask;
import com.huawei.yinglong.river.sitedeployment.dcs.dme.domain.task.TaskInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.NumberUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.language.LanguageUtils;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.mapstruct.ReportingPolicy;

@Mapper(unmappedTargetPolicy=ReportingPolicy.IGNORE, componentModel="spring", imports={NumberUtils.class})
public interface DmeAssembler {
    public static final Map<String, List<String>> actionMap = new HashMap(){
        {
            this.put("1", Arrays.asList(TaskOperateEnum.RETRY.name(), TaskOperateEnum.SKIP.name()));
            this.put("2", Arrays.asList(TaskOperateEnum.RETRY.name()));
        }
    };

    public TaskInfoBo toBo(TaskInfo var1);

    public ResultInfoBo toBo(GeneralTask var1);

    @Mappings(value={@Mapping(target="validateMessage", source="template.validator.message"), @Mapping(target="validateRegex", source="template.validator.regex"), @Mapping(target="defaultValue", expression="java(template.getDefaultValue() == null ? \"\" : template.getDefaultValue().toString())")})
    public ParamTemplateBo toBo(ParamTemplate var1);

    default public String toBo(LanguageCombination languageCombination) {
        if (languageCombination == null) {
            return "";
        }
        return LanguageUtils.getCurrentLanguage().isZh() ? languageCombination.getCn() : languageCombination.getEn();
    }

    public OptionItemBo toBo(OptionItem var1);

    default public long localDateTimeToLong(LocalDateTime localDateTime) {
        return localDateTime == null ? 0L : localDateTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    @Mappings(value={@Mapping(target="beginTime", source="startTime"), @Mapping(target="finishTime", source="endTime")})
    public DeployTaskInfoVo toVo(GeneralTask var1);

    @Mappings(value={@Mapping(target="id", source="taskInfo.key"), @Mapping(target="taskName", source="taskInfo.name"), @Mapping(target="beginTime", source="taskInfo.startTime"), @Mapping(target="durationTime", expression="java(NumberUtils.parseDurationTime(taskInfo.getDurationTime()))"), @Mapping(target="finishTime", source="taskInfo.endTime"), @Mapping(target="suggestion", source="taskInfo.suggestMessage"), @Mapping(target="detail", source="taskInfo.description"), @Mapping(target="eventType", expression="java(\"dmeDeployEvent\")"), @Mapping(target="actions", source="taskInfo.parentTaskId"), @Mapping(target="errorMsg", source="taskInfo.errorMessage"), @Mapping(target="children", source="taskInfos")})
    public DeployTaskDetailVo toDetailVo(TaskInfo var1, List<TaskInfo> var2);

    default public List<DeployTaskDetailVo> toDeployTaskDetailVos(List<TaskInfo> taskInfos) {
        return taskInfos.stream().map(task -> this.toDetailVo((TaskInfo)task, Collections.emptyList())).collect(Collectors.toList());
    }

    default public List<String> toAction(String parentTaskId) {
        if (StringUtils.isEmpty((CharSequence)parentTaskId)) {
            return Collections.emptyList();
        }
        return actionMap.getOrDefault(parentTaskId, Collections.emptyList());
    }
}

